/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObjectBriefInfo;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.obj.ConfIntegerCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectBase;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectBrief;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectsCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructure;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructureCollection;
import com.genesyslab.platform.configuration.protocol.runtime.channel.AesUtil;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ConfSerializer;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReader;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReaderV6;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;
import java.io.StringWriter;

public class ConfSerializerV6
extends ConfSerializer {
    private static ILogger log = Log.getLogger(ConfSerializerV6.class);

    public ConfSerializerV6(CfgMetadata metadata, AesUtil aes) {
        super(metadata, aes);
    }

    public ConfObjectsCollection deserialize(CfgDescriptionObject typeDescription, String cfgStr) throws CodecException {
        TokenReaderV6 tokenReader;
        if (log.isDebug()) {
            log.debugFormat("Serializing {0}: {1}", (Object)new Object[]{typeDescription.getName(), this.createTruncatedLogTrace(cfgStr)});
        }
        if (this.dataLogger.isDebug()) {
            this.dataLogger.debugFormat("Serializing {0}: {1}", (Object)new Object[]{typeDescription.getName(), cfgStr});
        }
        if (!((TokenReader)(tokenReader = new TokenReaderV6(cfgStr))).read()) {
            return null;
        }
        ConfObjectBrief obj = null;
        if (!typeDescription.isCfgType(CfgTypeMask.BriefInfo)) {
            throw new CodecException("Unsupported objects collection type");
        }
        obj = new ConfObjectBrief((CfgDescriptionObjectBriefInfo)typeDescription);
        ConfObjectsCollection result = new ConfObjectsCollection(typeDescription);
        for (CfgDescriptionAttribute attribute : typeDescription.getAttributes()) {
            Object attr;
            if (!((TokenReader)tokenReader).read()) break;
            if (tokenReader.getTokenType() == TokenType.EMPTY || (attr = this.createElement(attribute, tokenReader)) == null) continue;
            obj.setPropertyValue(attribute.getIndex(), attr);
        }
        result.add(obj);
        return result;
    }

    public String serialize(ConfObjectsCollection objects) throws CodecException {
        if (objects == null) {
            throw new CodecException("ConfObjectsCollection is null");
        }
        if (objects.size() != 1) {
            throw new CodecException("Only one object serialization is supported by V6 format");
        }
        return this.serialize((ConfObject)objects.get(0));
    }

    public String serialize(ConfObject object) throws CodecException {
        CfgDescriptionObject typeDescription = object.getClassInfo();
        if (log.isDebug()) {
            log.debug((Object)("Encoding type '" + typeDescription.getName()));
        }
        StringWriter cfgWriter = new StringWriter();
        cfgWriter.write(typeDescription.getName());
        cfgWriter.write(61);
        cfgWriter.write(29);
        for (CfgDescriptionAttribute attribute : typeDescription.getAttributes()) {
            this.writeCfgString(attribute, object, cfgWriter);
        }
        cfgWriter.write(30);
        String s = cfgWriter.toString();
        if (log.isDebug()) {
            log.debugFormat("deserialized to: {0}", (Object)this.createTruncatedLogTrace(s));
        }
        if (this.dataLogger.isDebug()) {
            this.dataLogger.debugFormat("deserialized dump: {0}", (Object)s);
        }
        return s;
    }

    protected void serializeKVList(CfgDescriptionAttributeReference attr, KeyValueCollection value, StringWriter cfgWriter) throws CodecException {
    }

    protected void serializeIntList(CfgDescriptionAttributeReference attr, ConfIntegerCollection value, StringWriter cfgWriter) throws CodecException {
    }

    protected void serializeDBIdList(CfgDescriptionAttributeReference attr, ConfIntegerCollection value, StringWriter cfgWriter) throws CodecException {
    }

    protected void serializeObjList(CfgDescriptionAttributeReference attr, ConfStructureCollection value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(attr.getName());
        cfgWriter.write(61);
        cfgWriter.write(27);
        if (value != null) {
            for (ConfStructure val : value) {
                this.serializePObject(attr, val, cfgWriter);
            }
        }
        cfgWriter.write(28);
    }

    protected void serializePObject(CfgDescriptionAttributeReference attr, ConfObjectBase value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(attr.getName());
        cfgWriter.write(61);
        cfgWriter.write(29);
        if (value != null) {
            for (CfgDescriptionAttribute attribute : attr.getCfgClass().getAttributes()) {
                this.writeCfgString(attribute, value.getPropertyValue(attribute.getName()), cfgWriter);
            }
        }
        cfgWriter.write(30);
    }

    protected void serializePrimitive(CfgDescriptionAttribute attr, char delimiter, Object value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(attr.getName());
        cfgWriter.write(61);
        if (delimiter == '\u001f') {
            cfgWriter.write(delimiter);
        }
        if (value != null) {
            cfgWriter.write(value.toString());
        } else if (delimiter != '\u001f') {
            cfgWriter.write(48);
        }
        cfgWriter.write(24);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeCfgString(CfgDescriptionAttribute attributeDescription, Object value, StringWriter cfgWriter) throws CodecException {
        if (!attributeDescription.isCfgType(CfgTypeMask.List)) {
            if (attributeDescription.isCfgType(CfgTypeMask.Integer) || attributeDescription.isCfgType(CfgTypeMask.Link) || attributeDescription.isCfgType(CfgTypeMask.Enum)) {
                this.serializePrimitive(attributeDescription, '\u0017', value, cfgWriter);
                return;
            } else if (attributeDescription.isCfgType(CfgTypeMask.String)) {
                this.serializePrimitive(attributeDescription, '\u001f', value, cfgWriter);
                return;
            } else {
                if (!attributeDescription.isCfgType(CfgTypeMask.Class)) throw new CodecException("Type [" + attributeDescription.getTypeMaskString() + "] is not supported.");
                this.serializePObject((CfgDescriptionAttributeReference)attributeDescription, (ConfStructure)value, cfgWriter);
            }
            return;
        } else {
            if (!attributeDescription.isCfgType(CfgTypeMask.Class)) throw new CodecException("Type [" + attributeDescription.getTypeMaskString() + "] is not supported.");
            this.serializeObjList((CfgDescriptionAttributeReference)attributeDescription, (ConfStructureCollection)value, cfgWriter);
        }
    }
}

