/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.runtime.channel.AesUtil;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ObjectSerializer;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReader;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReaderV6;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;
import java.io.StringWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectSerializerV6
extends ObjectSerializer {
    private static ILogger log = Log.getLogger(ObjectSerializerV6.class);

    public ObjectSerializerV6(CfgMetadata metadata, AesUtil aes, boolean deltaCleanUp) {
        super(metadata, aes, deltaCleanUp);
    }

    public Document serialize(String objectTypeName, String cfgStr) throws CodecException {
        if (log.isDebug()) {
            log.debugFormat("serializing: {0}", (Object)this.createTruncatedLogTrace(cfgStr));
        }
        if (dataLogger.isDebug()) {
            dataLogger.debugFormat("serializing: {0}", (Object)cfgStr);
        }
        Document document = this.docCreator.newDocument();
        Element xmlElement = this.createElement(document, "ConfData");
        document.appendChild(xmlElement);
        Object typeDescription = this.getMetadata().getCfgClass(objectTypeName);
        TokenReaderV6 tokenReader = new TokenReaderV6(cfgStr);
        if (!((TokenReader)tokenReader).read()) {
            return document;
        }
        Element xmlObjectElement = this.createElement(document, ((CfgDescription)typeDescription).getName());
        for (CfgDescriptionAttribute attribute : ((CfgDescriptionClass)typeDescription).getAttributes()) {
            if (!((TokenReader)tokenReader).read()) break;
            if (tokenReader.getTokenType() == TokenType.EMPTY || (xmlElement = this.createXmlElement(attribute, tokenReader, document)) == null) continue;
            xmlObjectElement.appendChild(xmlElement);
        }
        document.getDocumentElement().appendChild(xmlObjectElement);
        return document;
    }

    public String deserialize(String objectTypeName, Document document) throws CodecException {
        StringWriter cfgWriter = new StringWriter();
        Object typeDescription = this.getMetadata().getCfgClass(objectTypeName);
        ObjectSerializer.DocumentWalker navigator = new ObjectSerializer.DocumentWalker(document.getDocumentElement());
        navigator.moveToFirstChild();
        cfgWriter.write(navigator.getName());
        cfgWriter.write(61);
        cfgWriter.write(29);
        if (navigator.hasChildren()) {
            navigator.moveToFirstChild();
            boolean toContinue = true;
            for (CfgDescriptionAttribute attribute : ((CfgDescriptionClass)typeDescription).getAttributes()) {
                if (toContinue) {
                    toContinue = this.writeCfgString(attribute, navigator, cfgWriter);
                    continue;
                }
                ObjectSerializerV6.injectMissingElement(attribute, cfgWriter);
            }
        }
        cfgWriter.write(30);
        String s = cfgWriter.toString();
        if (log.isDebug()) {
            log.debugFormat("deserialized to: {0}", (Object)this.createTruncatedLogTrace(s));
        }
        if (dataLogger.isDebug()) {
            dataLogger.debugFormat("deserialized dump: {0}", (Object)s);
        }
        return s;
    }

    protected boolean deserializeKVList(String name, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        return false;
    }

    protected boolean deserializeIntList(String name, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        return false;
    }

    protected boolean deserializeDBIdList(String name, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        return false;
    }

    protected boolean deserializeObjList(CfgDescriptionAttributeReference attr, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(attr.getName());
        cfgWriter.write(61);
        cfgWriter.write(27);
        if (attr.getName().equals(navigator.getName()) && navigator.hasChildren()) {
            navigator.moveToFirstChild();
            do {
                this.deserializePObject(attr, navigator, cfgWriter);
            } while (navigator.moveToNext());
            navigator.moveToParent();
        }
        cfgWriter.write(28);
        return true;
    }

    protected boolean deserializePObject(CfgDescriptionAttributeReference ref, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean attrExists = false;
        cfgWriter.write(navigator.getName());
        cfgWriter.write(61);
        cfgWriter.write(29);
        String sRef = ref.getCfgClass().getName();
        if (sRef.equals(navigator.getName())) {
            if (navigator.hasChildren()) {
                navigator.moveToFirstChild();
                boolean toContinue = true;
                Object typeDescription = this.getMetadata().getCfgClass(sRef);
                for (CfgDescriptionAttribute attribute : ((CfgDescriptionClass)typeDescription).getAttributes()) {
                    if (toContinue) {
                        toContinue = this.writeCfgString(attribute, navigator, cfgWriter);
                        continue;
                    }
                    ObjectSerializerV6.injectMissingElement(attribute, cfgWriter);
                }
                navigator.moveToParent();
            }
            attrExists = true;
        }
        cfgWriter.write(30);
        return attrExists;
    }

    protected boolean deserializePrimitive(String name, char delimiter, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean attrExists = false;
        cfgWriter.write(name);
        cfgWriter.write(61);
        if (delimiter == '\u001f') {
            cfgWriter.write(delimiter);
        }
        if (name.equals(navigator.getName())) {
            cfgWriter.write(navigator.getAttribute("value"));
            attrExists = true;
        } else if (delimiter != '\u001f') {
            cfgWriter.write(48);
        }
        cfgWriter.write(24);
        return attrExists;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean writeCfgString(CfgDescriptionAttribute attributeDescription, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean navigatorMoveToNext = false;
        if (!attributeDescription.isCfgType(CfgTypeMask.List)) {
            if (attributeDescription.isCfgType(CfgTypeMask.Integer) || attributeDescription.isCfgType(CfgTypeMask.Link) || attributeDescription.isCfgType(CfgTypeMask.Enum)) {
                navigatorMoveToNext = this.deserializePrimitive(attributeDescription.getName(), '\u0017', navigator, cfgWriter);
            } else if (attributeDescription.isCfgType(CfgTypeMask.String)) {
                navigatorMoveToNext = this.deserializePrimitive(attributeDescription.getName(), '\u001f', navigator, cfgWriter);
            } else {
                if (!attributeDescription.isCfgType(CfgTypeMask.Class)) throw new CodecException("Type [" + attributeDescription.getTypeMaskString() + "] is not supported.");
                navigatorMoveToNext = this.deserializePObject((CfgDescriptionAttributeReference)attributeDescription, navigator, cfgWriter);
            }
        } else {
            if (!attributeDescription.isCfgType(CfgTypeMask.Class)) throw new CodecException("Type [" + attributeDescription.getTypeMaskString() + "] is not supported.");
            navigatorMoveToNext = this.deserializeObjList((CfgDescriptionAttributeReference)attributeDescription, navigator, cfgWriter);
        }
        if (!navigatorMoveToNext) return true;
        boolean bl = navigator.moveToNext();
        return bl;
    }

    static void injectMissingElement(CfgDescriptionAttribute attributeDescription, StringWriter cfgWriter) {
        cfgWriter.write(attributeDescription.getName());
        cfgWriter.write(61);
        if (attributeDescription.isCfgType(CfgTypeMask.List)) {
            cfgWriter.write(27);
            cfgWriter.write(28);
        } else if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
            cfgWriter.write(29);
            cfgWriter.write(30);
        } else if (!attributeDescription.isCfgType(CfgTypeMask.String)) {
            cfgWriter.write(48);
            cfgWriter.write(24);
        } else {
            cfgWriter.write(31);
            cfgWriter.write(24);
        }
    }
}

