/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.configuration.protocol.runtime.channel.CharDelimitersV7;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReader;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;

public class TokenReaderV7
extends TokenReader {
    public TokenReaderV7(String confStr, boolean isDelta) {
        super(confStr, isDelta);
    }

    public boolean read() {
        int dataPosition;
        int startPosition = this.position++;
        if (this.position > this.len - 1) {
            return false;
        }
        if (this.confStr.charAt(this.position) == '\u0018') {
            if (this.confStr.charAt(startPosition) == '\u0017') {
                this.setToken(TokenType.EMPTY, null);
            } else {
                this.setToken(TokenType.END, null);
            }
            return true;
        }
        if (this.confStr.charAt(this.position) == '\u0017' && this.confStr.charAt(++this.position) == '\u0018') {
            this.setToken(TokenType.EMPTY, null);
            return true;
        }
        TokenType tokenType = this.getTokenType(this.position);
        if (tokenType == TokenType.KVLIST || tokenType == TokenType.NONE) {
            this.readKVPair();
            return true;
        }
        String tokenData = null;
        if (this.confStr.charAt(dataPosition = ++this.position) == '\u0017') {
            if (this.position == 2) {
                tokenType = TokenType.OBJECT;
            }
            this.setToken(tokenType, null);
            return true;
        }
        this.position = this.confStr.indexOf(24, dataPosition);
        if (this.position > dataPosition) {
            tokenData = this.confStr.substring(dataPosition, this.position);
        } else {
            tokenType = this.isDelta() && this.confStr.charAt(dataPosition - 1) == '\u001b' ? TokenType.STRING : TokenType.EMPTY;
        }
        this.setToken(tokenType, tokenData);
        return true;
    }

    private void readKVPair() {
        String tokenKey = null;
        String tokenData = null;
        int keyPosition = this.position++;
        if (this.confStr.charAt(this.position) == '\u0017') {
            this.setToken(TokenType.KVLIST, null);
        } else {
            this.position = CharDelimitersV7.indexOfAnyDelimiter(this.confStr, keyPosition);
            if (this.position > keyPosition) {
                tokenKey = this.confStr.substring(keyPosition, this.position);
            }
            if (this.confStr.charAt(this.position) == '\u0018') {
                this.setToken(TokenType.KVLIST, null, tokenKey);
                --this.position;
            } else if (this.confStr.charAt(++this.position) == '\u0017') {
                this.setToken(TokenType.KVLIST, null, tokenKey);
            } else if (this.confStr.charAt(this.position) == '\u0018') {
                if (tokenKey == null) {
                    if (this.isDelta() && this.confStr.charAt(this.position - 1) == '\u001d') {
                        this.setToken(TokenType.EMPTY, "");
                    } else {
                        this.setToken(TokenType.EMPTY, null, null);
                    }
                } else {
                    TokenType tokenType = this.getTokenType(this.position - 1);
                    if (tokenType == TokenType.NONE) {
                        tokenType = TokenType.KVLIST;
                    }
                    this.setToken(tokenType, null, tokenKey);
                    if (tokenType == TokenType.KVLIST) {
                        --this.position;
                    }
                }
            } else {
                int dataPosition = this.position;
                this.position = this.confStr.indexOf(24, dataPosition + 1);
                if (this.position > dataPosition) {
                    tokenData = this.confStr.substring(dataPosition, this.position);
                }
                this.setToken(this.getTokenType(dataPosition - 1), tokenData, tokenKey);
            }
        }
    }

    @Deprecated
    protected boolean isPunctuation(char c) {
        char[] punctuations = new char[]{'.', ',', '?', '_'};
        for (int i = 0; i < punctuations.length; ++i) {
            if (c != punctuations[i]) continue;
            return true;
        }
        return false;
    }

    protected TokenType getTokenType(int position) {
        return CharDelimitersV7.getTokenType(this.confStr.charAt(position));
    }
}

