/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectsCollection;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ConfSerializerV7;
import com.genesyslab.platform.configuration.protocol.runtime.codec.ConfObjectPack;

public class ConfObjectPackV7
extends ConfObjectPack {
    private static final ILogger log = Log.getLogger(ConfObjectPackV7.class);

    public void setProtocolData(Object protocolData) {
        if (protocolData instanceof ConfSerializerStorageV7) {
            this.serializer = ((ConfSerializerStorageV7)protocolData).getConfSerializerV7();
        }
        if (this.serializer == null) {
            log.warn((Object)"No ConfSerializer in the protocol data");
        }
    }

    public void onMessageEnd() throws CodecException {
        if (this.serializer == null || this.confObjectsData == null) {
            return;
        }
        CfgDescriptionObject objectType = this.getObjectDescription();
        ConfObjectsCollection objects = this.serializer.deserialize(objectType, this.confObjectsData);
        this.confObjectsData = null;
        if (objects != null) {
            if (objects.size() == 1) {
                ConfObject object = (ConfObject)objects.get(0);
                ((DataSupport)this.message).attributes().put("Object", object);
            } else {
                throw new CodecException("Create notification message should contain only one object");
            }
        }
    }

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        if (this.serializer == null || customTypeObject == null) {
            return transportState;
        }
        String cfgStr = null;
        if (customTypeObject instanceof ConfObject) {
            cfgStr = this.serializer.serialize((ConfObject)customTypeObject);
        } else if (customTypeObject instanceof ConfObjectsCollection) {
            cfgStr = this.serializer.serialize((ConfObjectsCollection)customTypeObject);
        } else {
            throw new CodecException("Invalid configuration object(s) type (" + customTypeObject.getClass().getName() + ")");
        }
        if (cfgStr != null) {
            this.ensureOutgoingObjectTypeAttr(customTypeObject, id, transport, transportState);
            return transport.onAttribute(transportState, Integer.toString(9), cfgStr);
        }
        return transportState;
    }

    public static interface ConfSerializerStorageV7 {
        public ConfSerializerV7 getConfSerializerV7();
    }
}

