/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.codec;

import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomPackager;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectsRead;
import java.util.ArrayList;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PathArrayCodec2
implements AttributeTypeCodec,
CustomPackager {
    protected static final int OBJECT_PATHES_ID = 51;
    protected static final int OBJECT_TYPE_ID = 10;
    protected static final int FOLDER_TYPE_ID = 22;
    protected static final String LOG_TYPE = "PathArray";
    protected static final String SPLITTER = "\b";
    protected static final String PATH_XML_ELEMENT = "Path";
    protected static final String LOG_PATH_SEPARATOR = ",";
    protected static final String NS_ATTR_NAME = "xmlns";
    private Message message;
    private String pathString;
    private int objectType;

    public void onMessageStart(Message message) {
        this.setMessage(message);
    }

    public void onAttribute(String id, Object value) {
        switch (Integer.parseInt(id)) {
            case 51: {
                this.pathString = (String)value;
                break;
            }
            case 10: {
                this.objectType = Integer.parseInt(value.toString());
            }
        }
    }

    public void onMessageEnd() {
        if (this.pathString != null && this.objectType == 22) {
            String[] pathArray = ((EventObjectsRead)this.message).getObjectPaths();
            for (int i = 0; i < pathArray.length; ++i) {
                if (!pathArray[i].equals("")) continue;
                pathArray[i] = "\\";
            }
        }
    }

    public String getNS() {
        return null;
    }

    public Object decodeFromConnection(Object obj, AttributeDescription attrDescr) {
        String pathArrayString = (String)obj;
        if (pathArrayString == null) {
            return null;
        }
        return pathArrayString.split(SPLITTER);
    }

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) {
        return transportState;
    }

    public void setProtocolData(Object protocolData) {
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        if (customTypeObject == null) {
            return;
        }
        String[] pathArray = (String[])customTypeObject;
        Document doc = attributeElement instanceof DOMResult ? ((DOMResult)attributeElement).getNode().getOwnerDocument() : CodecUtil.createDocument();
        String ns = ConfServerProtocol.PROTOCOL_DESCRIPTION.getNS();
        for (String path : pathArray) {
            Element listElement = doc.createElementNS(ns, PATH_XML_ELEMENT);
            listElement.setTextContent(path);
            CodecUtil.appendElement((Element)listElement, (Result)attributeElement);
        }
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attrDescr) throws CodecException {
        Element attrElem = CodecUtil.asElement((Source)attributeElement);
        if (attrElem.getFirstChild() == null) {
            return null;
        }
        ArrayList<String> pathArrayList = new ArrayList<String>();
        Element child = (Element)attrElem.getFirstChild();
        do {
            if (!child.hasChildNodes() || child.getFirstChild().getNodeType() != 3) continue;
            pathArrayList.add(child.getFirstChild().getNodeValue());
        } while ((child = (Element)child.getNextSibling()) != null);
        String[] pathArray = new String[pathArrayList.size()];
        for (int i = 0; i < pathArray.length; ++i) {
            pathArray[i] = (String)pathArrayList.get(i);
        }
        return pathArray;
    }

    public String getLogType() {
        return LOG_TYPE;
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) throws CodecException {
        if (customTypeObject == null) {
            return;
        }
        String[] pathArray = (String[])customTypeObject;
        for (int i = 0; i < pathArray.length - 1; ++i) {
            buf.append(pathArray[i]);
            buf.append(LOG_PATH_SEPARATOR);
        }
        buf.append(pathArray[pathArray.length - 1]);
        buf.append("\n");
    }
}

