/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomPackager;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectCreated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectUpdated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectsRead;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestCreateObject;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestUpdateObject;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ObjectSerializerV7;
import com.genesyslab.platform.configuration.protocol.runtime.codec.XmlDocumentCodec;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import org.w3c.dom.Document;

public class XmlDocumentCodecV7
extends XmlDocumentCodec
implements CustomPackager {
    private static final ILogger log = Log.getLogger(XmlDocumentCodecV7.class);

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        String objectTypeName = null;
        if (this.message instanceof RequestCreateObject || this.message instanceof RequestUpdateObject) {
            Integer objectTypeId = (Integer)this.message.getMessageAttribute("ObjectType");
            if (objectTypeId == null || objectTypeId <= 0 || objectTypeId >= CfgObjectType.CFGMaxObjectType.ordinal()) {
                throw new IllegalArgumentException("Object Type [" + objectTypeId + "] is out of range");
            }
            CfgDescriptionObject objectType = this.serializer.getMetadata().getClassById(objectTypeId);
            if (objectType == null) {
                throw new IllegalArgumentException("Object Type [" + objectTypeId + "] does not exist in current schema");
            }
            objectTypeName = objectType.getName();
            if (this.message instanceof RequestUpdateObject) {
                objectTypeName = objectTypeName.substring(0, 3) + "Delta" + objectTypeName.substring(3);
            }
        } else {
            throw new PlatformException("Unexpected message");
        }
        if (log.isDebug()) {
            log.debug((Object)("Encoding type '" + objectTypeName));
        }
        Document doc = this.asDocument(customTypeObject);
        String cfgStr = null;
        if (doc != null) {
            cfgStr = this.serializer.deserialize(objectTypeName, doc);
        }
        return transport.onAttribute(transportState, id, cfgStr);
    }

    public String getNS() {
        return null;
    }

    public void onMessageStart(Message message) {
        this.setMessage(message);
    }

    public void onAttribute(String id, Object value) throws CodecException {
        switch (this.asInt(id)) {
            case 10: {
                this.objectType = (Integer)value;
                break;
            }
            case 9: {
                this.confObject = (String)value;
            }
        }
    }

    public void onMessageEnd() throws CodecException {
        if (this.confObject == null) {
            return;
        }
        if (this.objectType == null) {
            throw new CodecException("Object type is expected, but not found");
        }
        CfgDescriptionObject objectTypeDescr = this.serializer.getMetadata().getClassById(this.objectType);
        if (objectTypeDescr == null) {
            throw new CodecException("Object Type [" + this.objectType + "] does not exist in current schema");
        }
        String objectTypeName = objectTypeDescr.getName();
        int messageId = this.message.messageId();
        if (messageId == 75) {
            objectTypeName = objectTypeName.substring(0, 3) + "Delta" + objectTypeName.substring(3);
        }
        if (log.isDebug()) {
            log.debug((Object)("Decoding type '" + objectTypeName));
        }
        Document doc = this.serializer.serialize(objectTypeName, this.confObject);
        switch (messageId) {
            case 73: {
                ((EventObjectsRead)this.message).setConfObject(doc);
                break;
            }
            case 74: {
                ((EventObjectCreated)this.message).setConfObject(doc);
                break;
            }
            case 75: {
                ((EventObjectUpdated)this.message).setConfObject(doc);
                break;
            }
            default: {
                log.warnFormat("Unexpected message in XmlDocumentCodec: {0}", (Object)this.message);
            }
        }
    }

    public void setProtocolData(Object protocolData) {
        if (protocolData instanceof ObjectSerializerStorageV7) {
            this.serializer = ((ObjectSerializerStorageV7)protocolData).getSerializerV7();
        }
        if (this.serializer == null) {
            log.warn((Object)"Failed to get ObjectSerializer from protocol data");
        }
    }

    public static interface ObjectSerializerStorageV7 {
        public ObjectSerializerV7 getSerializerV7();
    }
}

