/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.utilities;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import com.genesyslab.platform.configuration.protocol.metadata.CfgComparer;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeEnumItem;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObjectDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructure;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgOperation;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgAttributeOperationalInfo;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgClassOperationalInfo;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgListItemInfo;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgListOperationalInfo;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgNameOperationalInfo;
import com.genesyslab.platform.configuration.protocol.types.CfgEnumType;
import com.genesyslab.platform.configuration.protocol.types.CfgErrorType;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectProperty;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import com.genesyslab.platform.configuration.protocol.utilities.CfgErrorCode;
import com.genesyslab.platform.configuration.protocol.utilities.Linq;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditions;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditionsAdaptor;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CfgUtilities {
    private static final String ConfDataElementExceptionMessage = "The agrument should have 'ConfData' element as the root";
    private static final String ObjectElementExceptionMessage = "The agrument should have an object element as the root";
    private static final String DeltaElementExceptionMessage = "The agrument should have a delta object element as the root";
    private final CfgMetadata metadata;
    private final DocumentBuilder docBuilder;

    public CfgUtilities(CfgMetadata metadata) {
        this.metadata = metadata;
        try {
            this.docBuilder = XmlFactories.newDocumentBuilder((boolean)CfgMetadata.useConfDataNs);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Exception initializing of XML engine", e);
        }
    }

    public static String getDataNS() {
        return CfgMetadata.getNs();
    }

    public static CfgErrorCode getErrorCode(int errorCode) {
        CfgErrorType errorType = (CfgErrorType)GEnum.getValue(CfgErrorType.class, (int)(errorCode & 0xFF));
        CfgObjectType objType = (CfgObjectType)GEnum.getValue(CfgObjectType.class, (int)(errorCode >> 8 & 0xFF));
        CfgObjectProperty property = (CfgObjectProperty)GEnum.getValue(CfgObjectProperty.class, (int)(errorCode >> 16));
        return new CfgErrorCode(errorType, objType, property);
    }

    public static CfgErrorType getErrorType(int errorCode) {
        return (CfgErrorType)GEnum.getValue(CfgErrorType.class, (int)(errorCode & 0xFF));
    }

    public static Calendar getDateTime(int utc) {
        Calendar res = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        res.setTimeInMillis((long)utc * 1000L);
        res.setTimeZone(TimeZone.getDefault());
        return res;
    }

    public Object getAttributeValue(Element parentClass, String attributeName) {
        Object parentClassDescription = this.metadata.getCfgClass(parentClass.getLocalName());
        CfgDescriptionAttribute attributeDescription = ((CfgDescriptionClass)parentClassDescription).getAttribute(attributeName);
        return attributeDescription.getValue(parentClass);
    }

    public void applyDelta(Document xmlObject, Document xmlDelta) {
        Element objectRoot = null;
        if (xmlObject != null) {
            objectRoot = xmlObject.getDocumentElement();
        }
        if (objectRoot == null || !"ConfData".equals(objectRoot.getLocalName())) {
            throw new IllegalArgumentException("The agrument should have 'ConfData' element as the root (in xmlObject)");
        }
        Element deltaRoot = null;
        if (xmlDelta != null) {
            deltaRoot = xmlDelta.getDocumentElement();
        }
        if (deltaRoot == null || !"ConfData".equals(deltaRoot.getLocalName())) {
            throw new IllegalArgumentException("The agrument should have 'ConfData' element as the root (in xmlDelta)");
        }
        this.applyDelta((Element)objectRoot.getFirstChild(), (Element)deltaRoot.getFirstChild());
    }

    public void applyDelta(Element xObject, Element xDelta) {
        if (xObject == null || this.metadata.getCfgClass(xObject.getLocalName()) == null) {
            throw new IllegalArgumentException("The agrument should have an object element as the root (in xmlObject)");
        }
        if (xDelta == null || this.metadata.getCfgClass(xDelta.getLocalName()) == null) {
            throw new IllegalArgumentException("The agrument should have a delta object element as the root (in xmlDelta)");
        }
        final CfgDescriptionObjectDelta deltaDescription = (CfgDescriptionObjectDelta)this.metadata.getCfgClass(xDelta.getLocalName());
        List<Node> deltaContentElements = Linq.selectWithOrder(xDelta.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                CfgOperation op1 = deltaDescription.getAttributeByName(o1.getLocalName()).getOperation();
                CfgOperation op2 = deltaDescription.getAttributeByName(o2.getLocalName()).getOperation();
                return op2.compareTo(op1);
            }
        });
        CfgUtilities.applyDelta(xObject, deltaContentElements, deltaDescription);
    }

    public Document createDelta(Document originalObject, Document changedObject) {
        Element originalRoot = null;
        if (originalObject != null) {
            originalRoot = originalObject.getDocumentElement();
        }
        if (originalRoot == null || !"ConfData".equals(originalRoot.getLocalName())) {
            throw new IllegalArgumentException("The agrument should have 'ConfData' element as the root (in originalObject)");
        }
        Element changedRoot = null;
        if (changedObject != null) {
            changedRoot = changedObject.getDocumentElement();
        }
        if (changedRoot == null || !"ConfData".equals(changedRoot.getLocalName())) {
            throw new IllegalArgumentException("The agrument should have 'ConfData' element as the root (in changedObject)");
        }
        Element elemDelta = this.createDelta(CfgUtilities.getFirstChildElement(originalRoot), CfgUtilities.getFirstChildElement(changedRoot));
        if (elemDelta != null) {
            return elemDelta.getOwnerDocument();
        }
        return null;
    }

    public Element createDelta(Element originalObject, Element changedObject) {
        if (originalObject == null || this.metadata.getCfgClass(originalObject.getLocalName()) == null) {
            throw new IllegalArgumentException("The agrument should have an object element as the root (in originalObject)");
        }
        if (changedObject == null || this.metadata.getCfgClass(changedObject.getLocalName()) == null) {
            throw new IllegalArgumentException("The agrument should have an object element as the root (in changedObject)");
        }
        ICfgClassOperationalInfo deltaDescription = ((CfgDescriptionClass)this.metadata.getCfgClass(changedObject.getLocalName())).getDelta();
        Document resDoc = this.docBuilder.newDocument();
        Element rootNode = resDoc.createElementNS(CfgUtilities.getDataNS(), "ConfData");
        resDoc.appendChild(rootNode);
        Element deltaObject = resDoc.createElementNS(CfgUtilities.getDataNS(), deltaDescription.getName());
        rootNode.appendChild(deltaObject);
        return CfgUtilities.createDelta(originalObject, changedObject, deltaDescription, deltaObject);
    }

    public static String enumLiteralToName(String name) {
        if (name.equals("CFGSAgentInfo") || name.equals("CFGSAddress") || name.equals("CFGSPhones") || name.equals("CFGSOSInfo") || name.equals("CFGSOwnerID")) {
            return name.replace("CFGS", "Cfg");
        }
        return name.replace("CFG", "Cfg");
    }

    public static String nameToEnumLiteral(String name) {
        if (name.equals("CfgAgentInfo") || name.equals("CfgAddress") || name.equals("CfgPhones") || name.equals("CfgOSInfo") || name.equals("CfgOwnerID")) {
            return name.replace("Cfg", "CFGS");
        }
        return name.replace("Cfg", "CFG");
    }

    private static Element createDelta(Element class1, Element class2, ICfgClassOperationalInfo deltaDescription, Element delta) {
        CfgDescriptionClass subjectClassDescription = deltaDescription.getSubjectClassDescription();
        CfgUtilities.cleanUpClass(class1, subjectClassDescription);
        CfgUtilities.cleanUpClass(class2, subjectClassDescription);
        Element xClass = CfgUtilities.differClasses(class1, class2, subjectClassDescription, delta);
        if (xClass != null) {
            delta.insertBefore(xClass, delta.getFirstChild());
        }
        return delta;
    }

    private static Element differClasses(Element xClassElement, Element yClassElement, CfgDescriptionClass classDescription, Element parent) {
        Document resDoc = parent.getOwnerDocument();
        CfgUtilities.normalizeClass(yClassElement, xClassElement, yClassElement, classDescription, resDoc);
        List[] diffQueries = new List[]{Linq.except(CfgUtilities.getChildElements(yClassElement), CfgUtilities.getChildElements(xClassElement), (CfgComparer)CfgMetadata.getNodeEqualityComparer()), Linq.except(CfgUtilities.getChildElements(xClassElement), CfgUtilities.getChildElements(yClassElement), (CfgComparer)CfgDescription.getNameComparer())};
        Element xClass = CfgUtilities.createClassWithKeys(yClassElement, diffQueries, classDescription, resDoc);
        for (List diffQuery : diffQueries) {
            for (Node element : diffQuery) {
                CfgDescriptionAttribute attributeDescription = classDescription.getAttributeByName(element.getLocalName());
                if (!attributeDescription.isCfgType(CfgTypeMask.List)) {
                    if (attributeDescription.isCfgType(CfgTypeMask.Primitive) || attributeDescription.isCfgType(CfgTypeMask.Link)) {
                        CfgUtilities.processPrimitives(CfgUtilities.findChildElement(xClassElement, attributeDescription.getName()), CfgUtilities.findChildElement(yClassElement, attributeDescription.getName()), attributeDescription, xClass);
                        continue;
                    }
                    if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
                        CfgUtilities.processClassReferences(CfgUtilities.findChildElement(xClassElement, element.getNodeName()), (Element)element, (CfgDescriptionAttributeReference)attributeDescription, xClass, parent, classDescription, resDoc);
                        continue;
                    }
                    throw new RuntimeException("InvalidDataException");
                }
                CfgUtilities.processListReferences(xClassElement, yClassElement, (CfgDescriptionAttributeReference)attributeDescription, xClass, parent);
            }
        }
        LinkedList<Node> constElements = new LinkedList<Node>();
        for (CfgDescriptionAttribute attr : classDescription.getAttributes()) {
            if (!attr.isCfgType(CfgTypeMask.Primitive) || attr.getConst() == 0L) continue;
            Element elem = resDoc.createElementNS(CfgUtilities.getDataNS(), attr.getName());
            elem.setAttribute("value", Long.toString(attr.getConst()));
            constElements.add(elem);
        }
        CfgUtilities.addElements(xClass, constElements, classDescription);
        if (xClass != null && xClass.hasChildNodes()) {
            return xClass;
        }
        return null;
    }

    private static void normalizeClass(Node yClass, Node xClassElementsContainer, Node yClassElementsContainer, CfgDescriptionClass classDescription, Document resDoc) {
        List<Node> deletedElementsQuery = Linq.except(CfgUtilities.getChildElements(xClassElementsContainer), CfgUtilities.getChildElements(yClassElementsContainer), (CfgComparer)CfgDescription.getNameComparer());
        for (Node deletedElement : deletedElementsQuery) {
            CfgDescriptionAttribute attrDesc = classDescription.getAttributeByName(deletedElement.getLocalName());
            if (!attrDesc.isCfgType(CfgTypeMask.Class) || attrDesc.isCfgType(CfgTypeMask.List)) continue;
            CfgUtilities.addElement(yClass, resDoc.createElementNS(CfgUtilities.getDataNS(), deletedElement.getNodeName()), classDescription);
        }
    }

    private static Element createClassWithKeys(Node yClass, List<Node>[] diffQueries, CfgDescriptionClass classDescription, Document resDoc) {
        Element xClass = null;
        if (!classDescription.isCfgType(CfgTypeMask.Group)) {
            xClass = resDoc.createElementNS(CfgUtilities.getDataNS(), classDescription.getName());
            for (Node keyElem : classDescription.getKeys(yClass)) {
                xClass.appendChild(resDoc.importNode(keyElem, true));
            }
        } else {
            boolean noElements2;
            boolean noElements1 = CfgUtilities.findFirst(diffQueries[0], "CfgGroup") == null;
            boolean bl = noElements2 = CfgUtilities.findFirst(diffQueries[1], "CfgGroup") == null;
            if (noElements1 && noElements2) {
                Element group = resDoc.createElementNS(CfgUtilities.getDataNS(), "CfgGroup");
                group.appendChild(resDoc.importNode(CfgUtilities.findChildElement(CfgUtilities.findChildElement(yClass, "CfgGroup"), "DBID"), true));
                xClass = resDoc.createElementNS(CfgUtilities.getDataNS(), "CfgDeltaGroup");
                xClass.appendChild(group);
            }
        }
        return xClass;
    }

    private static void differKvLists(Node listElement1, Node listElement2, final CfgDescriptionAttribute attributeDescription, Document resDoc, Node[] out) {
        out[0] = null;
        out[1] = null;
        out[2] = null;
        if (listElement1 != null && listElement1.hasChildNodes()) {
            if (listElement2 != null && listElement2.hasChildNodes()) {
                List<Node> addedElementsQuery;
                List<Node> deletedElementsQuery = Linq.except(listElement1.getChildNodes(), listElement2.getChildNodes(), attributeDescription.getComparer());
                if (deletedElementsQuery.size() > 0) {
                    if (out[0] == null) {
                        out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), ((ICfgListOperationalInfo)((Object)attributeDescription)).getDeletedItemsAttributeDescription().getName());
                    }
                    for (Node node : deletedElementsQuery) {
                        Element element = resDoc.createElementNS(CfgUtilities.getDataNS(), node.getNodeName());
                        element.setAttribute("key", ((Element)node).getAttribute("key"));
                        out[0].appendChild(element);
                    }
                }
                if ((addedElementsQuery = Linq.except(listElement2.getChildNodes(), listElement1.getChildNodes(), attributeDescription.getComparer())).size() > 0) {
                    out[2] = resDoc.createElementNS(CfgUtilities.getDataNS(), listElement2.getNodeName());
                    for (Node node : addedElementsQuery) {
                        out[2].appendChild(resDoc.importNode(node, true));
                    }
                }
                List<Node> changedElementsQuery = Linq.intersect(listElement2.getChildNodes(), listElement1.getChildNodes(), attributeDescription.getComparer());
                Element[] elementArray = new Element[3];
                for (Node node : changedElementsQuery) {
                    elementArray[0] = null;
                    elementArray[1] = null;
                    elementArray[2] = null;
                    final Element elemI = (Element)node;
                    Element element1 = (Element)Linq.first(((Element)listElement1).getElementsByTagName(node.getNodeName()), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                        @Override
                        public boolean condition(Node item) {
                            return attributeDescription.getComparer().equals(item, elemI);
                        }
                    });
                    CfgUtilities.differKvListPairs(element1, (Element)node, attributeDescription, resDoc, elementArray);
                    if (elementArray[0] != null) {
                        if (out[0] == null) {
                            out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), ((ICfgListOperationalInfo)((Object)attributeDescription)).getDeletedItemsAttributeDescription().getName());
                        }
                        out[0].appendChild(elementArray[0]);
                    }
                    if (elementArray[1] != null && elementArray[1].hasChildNodes()) {
                        if (out[1] == null) {
                            out[1] = resDoc.createElementNS(CfgUtilities.getDataNS(), ((ICfgListOperationalInfo)((Object)attributeDescription)).getChangedItemsAttributeDescription().getName());
                        }
                        out[1].appendChild(elementArray[1]);
                    }
                    if (elementArray[2] == null) continue;
                    if (out[2] == null) {
                        out[2] = resDoc.createElementNS(CfgUtilities.getDataNS(), listElement2.getNodeName());
                    }
                    out[2].appendChild(elementArray[2]);
                }
            } else {
                out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), ((ICfgListOperationalInfo)((Object)attributeDescription)).getDeletedItemsAttributeDescription().getName());
            }
        } else if (listElement2 != null && listElement2.hasChildNodes()) {
            out[2] = resDoc.importNode(listElement2, true);
        }
    }

    private static void differKvListPairs(Element kvListElement1, Element kvListElement2, final CfgDescriptionAttribute listDescription, Document resDoc, Element[] out) {
        List<Node> deletedElementsQuery;
        out[0] = null;
        out[1] = null;
        out[2] = null;
        List<Node> addedElementsQuery = Linq.except(kvListElement2.getChildNodes(), kvListElement1.getChildNodes(), listDescription.getComparer());
        if (addedElementsQuery.size() > 0) {
            out[2] = resDoc.createElementNS(CfgUtilities.getDataNS(), kvListElement2.getNodeName());
            out[2].setAttribute("key", kvListElement2.getAttribute("key"));
            for (Node item : addedElementsQuery) {
                out[2].appendChild(resDoc.importNode(item, true));
            }
        }
        if ((deletedElementsQuery = Linq.except(kvListElement1.getChildNodes(), kvListElement2.getChildNodes(), listDescription.getComparer())).size() > 0) {
            out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), kvListElement2.getNodeName());
            out[0].setAttribute("key", kvListElement2.getAttribute("key"));
            for (Node node : deletedElementsQuery) {
                Element elem = resDoc.createElementNS(CfgUtilities.getDataNS(), node.getNodeName());
                elem.setAttribute("key", ((Element)node).getAttribute("key"));
                out[0].appendChild(elem);
            }
        }
        if (kvListElement2.hasChildNodes() && kvListElement1.hasChildNodes()) {
            List<Node> changedElementsQuery = Linq.intersect(kvListElement2.getChildNodes(), kvListElement1.getChildNodes(), listDescription.getComparer());
            if (changedElementsQuery.size() > 0) {
                Element[] out2 = new Element[3];
                for (Node node : changedElementsQuery) {
                    out2[0] = null;
                    out2[1] = null;
                    out2[2] = null;
                    final Element elemI = (Element)node;
                    Element element1 = (Element)Linq.first(kvListElement1.getElementsByTagName(node.getNodeName()), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                        @Override
                        public boolean condition(Node item) {
                            return listDescription.getComparer().equals(item, elemI);
                        }
                    });
                    CfgUtilities.differKvListPairs(element1, (Element)node, listDescription, resDoc, out2);
                    if (out2[0] != null) {
                        if (out[0] == null) {
                            out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), kvListElement2.getNodeName());
                            out[0].setAttribute("key", kvListElement2.getAttribute("key"));
                        }
                        out[0].appendChild(out2[0]);
                    }
                    if (out2[1] != null) {
                        if (out[1] == null) {
                            out[1] = resDoc.createElementNS(CfgUtilities.getDataNS(), kvListElement2.getNodeName());
                            out[1].setAttribute("key", kvListElement2.getAttribute("key"));
                        }
                        out[1].appendChild(out2[1]);
                    }
                    if (out2[2] == null) continue;
                    if (out[2] == null) {
                        out[2] = resDoc.createElementNS(CfgUtilities.getDataNS(), kvListElement2.getNodeName());
                        out[2].setAttribute("key", kvListElement2.getAttribute("key"));
                    }
                    out[2].appendChild(out2[2]);
                }
            }
        } else if (!CfgMetadata.getNodeEqualityComparer().equals(kvListElement1, kvListElement2) && out[1] == null) {
            out[1] = (Element)resDoc.importNode(kvListElement2, true);
        }
    }

    private static void processPrimitives(Element xPrimitive, Element yPrimitive, CfgDescriptionAttribute attributeDescription, Element parentClass) {
        Element deltaElement = CfgUtilities.differPrimitives(xPrimitive, yPrimitive, attributeDescription, parentClass.getOwnerDocument());
        CfgUtilities.addElement(parentClass, deltaElement, attributeDescription.getParent());
    }

    private static void processClassReferences(Element xClass, Element yClass, CfgDescriptionAttributeReference attributeDescription, Element parent, Element grandParent, CfgDescriptionClass grandParentClassDescription, Document resDoc) {
        Element deltaElement;
        CfgDescriptionClass classDescription = attributeDescription.getCfgClass();
        ICfgClassOperationalInfo delta = classDescription.getDelta();
        Element deltaClass = null;
        if (delta == null) {
            if (xClass == null) {
                deltaElement = yClass != null && yClass.hasChildNodes() ? (Element)resDoc.importNode(yClass, true) : null;
            } else {
                deltaElement = CfgUtilities.differClasses(xClass, yClass, classDescription, xClass);
                if (deltaElement != null) {
                    deltaElement = (Element)resDoc.adoptNode(deltaElement);
                }
            }
        } else {
            deltaClass = resDoc.createElementNS(CfgUtilities.getDataNS(), delta.getName());
            Element xClassN = xClass != null ? xClass : resDoc.createElementNS(CfgUtilities.getDataNS(), classDescription.getName());
            deltaElement = CfgUtilities.differClasses(xClassN, yClass, classDescription, deltaClass);
            CfgUtilities.addElement(grandParent, deltaClass, attributeDescription.getParent().getDelta().getClassDescription());
        }
        if (!grandParentClassDescription.isCfgType(CfgTypeMask.Group)) {
            CfgUtilities.addElement(parent, deltaElement, grandParentClassDescription);
        } else {
            CfgUtilities.addElement(deltaClass, deltaElement, delta.getClassDescription());
        }
    }

    private static void processListReferences(Element xClassElement, Element yClassElement, CfgDescriptionAttributeReference attributeDescription, Element parent, Element grandParent) {
        Document resDoc = grandParent.getOwnerDocument();
        Node[] out = new Element[]{null, null, null};
        CfgDescriptionClass classDescription = attributeDescription.getParent();
        if (attributeDescription.isCfgType(CfgTypeMask.Link)) {
            final String attrXName = attributeDescription.isCfgType(CfgTypeMask.Delta) ? ((ICfgNameOperationalInfo)((Object)attributeDescription)).getSubjectName() : attributeDescription.getName();
            CfgDescriptionAttributeReference attrDescr = classDescription.isCfgType(CfgTypeMask.Group) ? Linq.first(classDescription.getDelta().getClassDescription().getAttributes(), new LinqConditionsAdaptor<CfgDescriptionAttribute>(){

                @Override
                public boolean condition(CfgDescriptionAttribute item) {
                    return ((ICfgNameOperationalInfo)((Object)item)).getSubjectName().equals(attrXName) && item.getOperation() == CfgOperation.Add;
                }
            }) : attributeDescription;
            CfgUtilities.differLinkLists(CfgUtilities.findChildElement(xClassElement, attrXName), CfgUtilities.findChildElement(yClassElement, attrXName), attrDescr, resDoc, (Element[])out);
        } else if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
            CfgUtilities.differClassLists(CfgUtilities.findChildElement(xClassElement, attributeDescription.getName()), CfgUtilities.findChildElement(yClassElement, attributeDescription.getName()), attributeDescription, resDoc, (Element[])out);
        } else if (attributeDescription.isCfgType(CfgTypeMask.KvList)) {
            CfgUtilities.differKvLists(CfgUtilities.findChildElement(xClassElement, attributeDescription.getName()), CfgUtilities.findChildElement(yClassElement, attributeDescription.getName()), attributeDescription, resDoc, out);
        } else {
            throw new RuntimeException("InvalidDataException");
        }
        Element addElementSubject = classDescription.isCfgType(CfgTypeMask.Group) ? grandParent : parent;
        CfgDescriptionClass classDescription2 = classDescription.isCfgType(CfgTypeMask.Group) ? attributeDescription.getParent().getDelta().getClassDescription() : classDescription;
        CfgUtilities.addElement(addElementSubject, out[2], classDescription2);
        CfgUtilities.addElement(grandParent, out[0], attributeDescription.getParent().getDelta().getClassDescription());
        CfgUtilities.addElement(grandParent, out[1], attributeDescription.getParent().getDelta().getClassDescription());
    }

    private static Element differPrimitives(Element primitive1, Element primitive2, CfgDescriptionAttribute attributeDescription, Document resDoc) {
        if (primitive2 == null || !primitive2.hasAttributes()) {
            return CfgUtilities.processPrimitiveExceptionalConditions(primitive1, attributeDescription, resDoc, false);
        }
        if (primitive1 == null || !primitive1.hasAttributes()) {
            return CfgUtilities.processPrimitiveExceptionalConditions(primitive2, attributeDescription, resDoc, true);
        }
        if (!attributeDescription.isCfgType(CfgTypeMask.String) && primitive2.getAttribute("value").equals("0")) {
            if (!attributeDescription.isCfgType(CfgTypeMask.Enum) || !(attributeDescription instanceof CfgDescriptionAttributeEnumItem) || ((CfgDescriptionAttributeEnumItem)attributeDescription).getEnumDescription().getCfgEnum() != CfgEnumType.CfgFlag) {
                Element elem = resDoc.createElementNS(CfgUtilities.getDataNS(), attributeDescription.getName());
                elem.setAttribute("value", primitive1.getAttribute("value"));
                return elem;
            }
        } else {
            Element elem = resDoc.createElementNS(CfgUtilities.getDataNS(), attributeDescription.getName());
            elem.setAttribute("value", primitive2.getAttribute("value"));
            return elem;
        }
        throw new IllegalArgumentException("Type: " + attributeDescription.getTypeMaskString() + " is not a primitive type");
    }

    private static Element processPrimitiveExceptionalConditions(Element primitive, CfgDescriptionAttribute attributeDescription, Document resDoc, boolean isAdded) {
        if (primitive == null || !primitive.hasAttributes()) {
            return null;
        }
        String attrValue = primitive.getAttribute("value");
        if (attributeDescription.isCfgType(CfgTypeMask.String)) {
            Element elemStr = null;
            if (attrValue != null && !attrValue.equals("")) {
                elemStr = resDoc.createElementNS(CfgUtilities.getDataNS(), attributeDescription.getName());
                if (isAdded) {
                    elemStr.setAttribute("value", attrValue);
                } else {
                    elemStr.setAttribute("value", "");
                }
            }
            return elemStr;
        }
        if (!attributeDescription.isCfgType(CfgTypeMask.Enum) || !(attributeDescription instanceof CfgDescriptionAttributeEnumItem) || ((CfgDescriptionAttributeEnumItem)attributeDescription).getEnumDescription() == null || ((CfgDescriptionAttributeEnumItem)attributeDescription).getEnumDescription().getCfgEnum() != CfgEnumType.CfgFlag) {
            Element elemInt = null;
            if (!attrValue.equals("0")) {
                elemInt = resDoc.createElementNS(CfgUtilities.getDataNS(), attributeDescription.getName());
                elemInt.setAttribute("value", attrValue);
            }
            return elemInt;
        }
        if (attributeDescription instanceof CfgDescriptionAttributeEnumItem && ((CfgDescriptionAttributeEnumItem)attributeDescription).getEnumDescription() != null && ((CfgDescriptionAttributeEnumItem)attributeDescription).getEnumDescription().getCfgEnum() == CfgEnumType.CfgFlag) {
            Element elemFlag = null;
            if (attrValue != null && !attrValue.equals("")) {
                elemFlag = resDoc.createElementNS(CfgUtilities.getDataNS(), attributeDescription.getName());
                elemFlag.setAttribute("value", attrValue);
            }
            return elemFlag;
        }
        throw new IllegalArgumentException("Type: " + attributeDescription.getTypeMaskString() + " is not a primitive type");
    }

    private static void differClassLists(Element listElement1, Element listElement2, CfgDescriptionAttributeReference attributeDescription, Document resDoc, Element[] out) {
        out[0] = null;
        out[1] = null;
        out[2] = null;
        if (listElement1 != null) {
            if (listElement2 != null) {
                CfgUtilities.getAddedClassListItemsDeltaElement(listElement1, listElement2, attributeDescription, resDoc, out);
                CfgUtilities.getChangedClassListItemsDeltaElement(listElement1, listElement2, attributeDescription, resDoc, out);
                CfgUtilities.getDeletedClassListItemsDeltaElement(listElement1, listElement2, attributeDescription, resDoc, out);
            } else {
                CfgUtilities.getDeletedClassListItemsDeltaElement(listElement1, listElement2, attributeDescription, resDoc, out);
            }
        } else {
            CfgUtilities.getAddedClassListItemsDeltaElement(listElement1, listElement2, attributeDescription, resDoc, out);
        }
    }

    private static void differLinkLists(Element element1, Element element2, CfgDescriptionAttribute attributeDescription, Document resDoc, Element[] out) {
        block8: {
            block6: {
                String deletedAttributeXName;
                block7: {
                    List<Node> deletedElementsQuery;
                    out[0] = null;
                    out[2] = null;
                    if (element1 == null) break block6;
                    String string = deletedAttributeXName = attributeDescription.isCfgType(CfgTypeMask.Delta) ? ((ICfgListOperationalInfo)((Object)((ICfgAttributeOperationalInfo)((Object)attributeDescription)).getSubjectAttributeDescription())).getDeletedItemsAttributeDescription().getName() : ((ICfgListOperationalInfo)((Object)attributeDescription)).getDeletedItemsAttributeDescription().getName();
                    if (element2 == null) break block7;
                    List<Node> addedElementsQuery = Linq.except(element2.getChildNodes(), element1.getChildNodes(), (CfgComparer)CfgMetadata.getNodeEqualityComparer());
                    if (addedElementsQuery.size() > 0) {
                        out[2] = resDoc.createElementNS(CfgUtilities.getDataNS(), attributeDescription.getName());
                        for (Node item : addedElementsQuery) {
                            out[2].appendChild(resDoc.importNode(item, true));
                        }
                    }
                    if ((deletedElementsQuery = Linq.except(element1.getChildNodes(), element2.getChildNodes(), (CfgComparer)CfgMetadata.getNodeEqualityComparer())).size() <= 0) break block8;
                    out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), deletedAttributeXName);
                    for (Node item : deletedElementsQuery) {
                        out[0].appendChild(resDoc.importNode(item, true));
                    }
                    break block8;
                }
                out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), deletedAttributeXName);
                for (Node item : Linq.select(element1.getChildNodes(), null)) {
                    out[0].appendChild(resDoc.importNode(item, true));
                }
                break block8;
            }
            if (element2 != null) {
                out[2] = resDoc.createElementNS(CfgUtilities.getDataNS(), attributeDescription.getName());
                for (Node item : Linq.select(element2.getChildNodes(), null)) {
                    out[2].appendChild(resDoc.importNode(item, true));
                }
            }
        }
    }

    private static void getAddedClassListItemsDeltaElement(Element listElement1, Element listElement2, CfgDescriptionAttributeReference attributeDescription, Document resDoc, Element[] out) {
        boolean isCfgId;
        if (attributeDescription.getCfgClass().getDelta() != null) {
            throw new IllegalArgumentException("Classes with defined deltas should not be in a class list's content");
        }
        out[2] = null;
        CfgDescriptionStructure structureDescription = (CfgDescriptionStructure)attributeDescription.getCfgClass();
        boolean bl = isCfgId = structureDescription != null && ("CfgID".equals(structureDescription.getAliasName()) || "CfgID".equals(structureDescription.getName()));
        List<Node> addedListItemsQuery = listElement1 != null ? Linq.except(listElement2.getChildNodes(), listElement1.getChildNodes(), (CfgComparer)(isCfgId ? CfgMetadata.getNodeEqualityComparer() : attributeDescription.getCfgClass().getEqualityComparer())) : Linq.select(listElement2.getChildNodes(), null);
        if (addedListItemsQuery.size() == 0) {
            return;
        }
        ICfgListOperationalInfo listInfo = null;
        if (attributeDescription instanceof ICfgListOperationalInfo) {
            listInfo = (ICfgListOperationalInfo)((Object)attributeDescription);
        }
        out[2] = listInfo == null || listInfo.getAddedItemsAttributeDescription() == null ? resDoc.createElementNS(CfgUtilities.getDataNS(), attributeDescription.getName()) : resDoc.createElementNS(CfgUtilities.getDataNS(), listInfo.getAddedItemsAttributeDescription().getName());
        for (Node elem : addedListItemsQuery) {
            out[2].appendChild(resDoc.importNode(elem, true));
        }
    }

    private static void getChangedClassListItemsDeltaElement(Element listElement1, Element listElement2, CfgDescriptionAttributeReference attributeDescription, Document resDoc, Element[] out) {
        out[1] = null;
        CfgDescriptionAttributeReference changedListItemsAttributeDescription = ((ICfgListOperationalInfo)((Object)attributeDescription)).getChangedItemsAttributeDescription();
        if (changedListItemsAttributeDescription == null) {
            return;
        }
        List<Node> intersectedListItemsRootsQuery = Linq.intersect(listElement2.getChildNodes(), listElement1.getChildNodes(), attributeDescription.getCfgClass().getEqualityComparer());
        if (intersectedListItemsRootsQuery.size() == 0) {
            return;
        }
        List<Node> changedListItemsQuery = Linq.except(intersectedListItemsRootsQuery, listElement1.getChildNodes(), (CfgComparer)CfgMetadata.getNodeEqualityComparer());
        if (changedListItemsQuery.size() == 0) {
            return;
        }
        for (Node changedListItem : changedListItemsQuery) {
            if (out[1] == null) {
                out[1] = resDoc.createElementNS(CfgUtilities.getDataNS(), changedListItemsAttributeDescription.getName());
            }
            Element elemTmp = resDoc.createElementNS(CfgUtilities.getDataNS(), listElement1.getNodeName());
            elemTmp.appendChild(resDoc.importNode(changedListItem, true));
            Element originalListElement = (Element)Linq.intersect(listElement1.getChildNodes(), elemTmp.getChildNodes(), attributeDescription.getCfgClass().getEqualityComparer()).get(0);
            Element xClass = CfgUtilities.differClasses(originalListElement, (Element)changedListItem, attributeDescription.getCfgClass(), resDoc.createElementNS(CfgUtilities.getDataNS(), listElement1.getNodeName()));
            out[1].appendChild(xClass);
        }
    }

    private static void getDeletedClassListItemsDeltaElement(Element listElement1, Element listElement2, CfgDescriptionAttributeReference attributeDescription, Document resDoc, Element[] out) {
        boolean isCfgId;
        CfgDescriptionAttributeReference deletedListItemsAttributeDescription = ((ICfgListOperationalInfo)((Object)attributeDescription)).getDeletedItemsAttributeDescription();
        out[0] = null;
        CfgDescriptionStructure structureDescription = (CfgDescriptionStructure)attributeDescription.getCfgClass();
        boolean bl = isCfgId = structureDescription != null && ("CfgID".equals(structureDescription.getAliasName()) || "CfgID".equals(structureDescription.getName()));
        List<Node> deletedListItemsQuery = listElement2 != null ? Linq.except(listElement1.getChildNodes(), listElement2.getChildNodes(), (CfgComparer)(isCfgId ? CfgMetadata.getNodeEqualityComparer() : attributeDescription.getCfgClass().getEqualityComparer())) : Linq.select(listElement1.getChildNodes(), null);
        if (deletedListItemsQuery.size() == 0) {
            return;
        }
        if (deletedListItemsAttributeDescription.isCfgType(CfgTypeMask.Link)) {
            out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), deletedListItemsAttributeDescription.getName());
            for (Node deletedListItem : deletedListItemsQuery) {
                List<Node> keys = deletedListItemsAttributeDescription.getCfgClass().getKeys(deletedListItem);
                Element linkKey = resDoc.createElementNS(CfgUtilities.getDataNS(), "DBID");
                linkKey.setAttribute("value", ((Element)keys.get(0)).getAttribute("value"));
                out[0].appendChild(linkKey);
            }
        } else if (deletedListItemsAttributeDescription.isCfgType(CfgTypeMask.Class)) {
            if (deletedListItemsAttributeDescription.getCfgClass().isCfgType(CfgTypeMask.Alias)) {
                for (Node deletedListItem : deletedListItemsQuery) {
                    List<Node> keys = attributeDescription.getCfgClass().getKeys(deletedListItem);
                    if (keys.size() == 0) {
                        return;
                    }
                    Element keysElement = resDoc.createElementNS(CfgUtilities.getDataNS(), ((ICfgListItemInfo)((Object)deletedListItemsAttributeDescription)).getItemName());
                    for (Node key : keys) {
                        Collection<CfgDescriptionAttribute> attributes = attributeDescription.getCfgClass().getAttributes();
                        Collection<CfgDescriptionAttribute> attributes2 = deletedListItemsAttributeDescription.getCfgClass().getAttributes();
                        LinkedList<String> attributeNameQuery = new LinkedList<String>();
                        for (CfgDescriptionAttribute attribute : attributes) {
                            if (!key.getNodeName().equals(attribute.getName())) continue;
                            for (CfgDescriptionAttribute attribute2 : attributes2) {
                                if (!attribute.getName().equals(attribute2.getName()) && !attribute.getMappingName().equals(attribute2.getMappingName())) continue;
                                attributeNameQuery.add(attribute2.getName());
                            }
                        }
                        if (attributeNameQuery.size() <= 0) continue;
                        Element elem = resDoc.createElementNS(CfgUtilities.getDataNS(), (String)attributeNameQuery.get(0));
                        elem.setAttribute("value", ((Element)key).getAttribute("value"));
                        keysElement.appendChild(elem);
                    }
                    if (out[0] == null) {
                        out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), deletedListItemsAttributeDescription.getName());
                    }
                    out[0].appendChild(keysElement);
                }
            } else {
                out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), deletedListItemsAttributeDescription.getName());
                LinkedList<Node> classDefaultElementsQuery = new LinkedList<Node>();
                for (CfgDescriptionAttribute attr : attributeDescription.getCfgClass().getAttributes()) {
                    Element elem = resDoc.createElementNS(CfgUtilities.getDataNS(), attr.getName());
                    if (attr.isCfgType(CfgTypeMask.String)) {
                        elem.setAttribute("value", "");
                    } else {
                        elem.setAttribute("value", "0");
                    }
                    classDefaultElementsQuery.add(elem);
                }
                for (Node elem : deletedListItemsQuery) {
                    List<Node> missingElementsQuery = Linq.except(classDefaultElementsQuery, elem.getChildNodes(), (CfgComparer)CfgDescription.getNameComparer());
                    CfgUtilities.addElementsClones(elem, missingElementsQuery, attributeDescription.getCfgClass());
                    out[0].insertBefore(resDoc.importNode(elem, true), out[0].getFirstChild());
                }
            }
        } else if (deletedListItemsAttributeDescription.isCfgType(CfgTypeMask.String) || deletedListItemsAttributeDescription.isCfgType(CfgTypeMask.Integer)) {
            out[0] = resDoc.createElementNS(CfgUtilities.getDataNS(), deletedListItemsAttributeDescription.getName());
            for (Node deletedListItem : deletedListItemsQuery) {
                Element key = (Element)Linq.firstOrDefault(attributeDescription.getCfgClass().getKeys(deletedListItem), null);
                if (key == null) continue;
                Element elem = resDoc.createElementNS(CfgUtilities.getDataNS(), ((ICfgListItemInfo)((Object)deletedListItemsAttributeDescription)).getItemName());
                elem.setAttribute("value", key.getAttribute("value"));
                out[0].appendChild(elem);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static void applyDelta(Element subjectClass, Collection<Node> deltaContentElements, CfgDescriptionClass deltaClassDescription) {
        Document resDoc = subjectClass.getOwnerDocument();
        for (Node deltaElement : deltaContentElements) {
            CfgDescriptionAttributeReference deltaAttributeDescription = (CfgDescriptionAttributeReference)deltaClassDescription.getAttributeByName(deltaElement.getLocalName());
            if (!deltaElement.hasChildNodes() && !deltaAttributeDescription.isCfgType(CfgTypeMask.KvList)) continue;
            if (!deltaAttributeDescription.isCfgType(CfgTypeMask.List)) {
                if (!deltaAttributeDescription.isCfgType(CfgTypeMask.Class)) {
                    throw new RuntimeException("Attribute [" + deltaAttributeDescription.getName() + "] has invalid type: " + deltaAttributeDescription.getTypeMaskString());
                }
                if (!deltaAttributeDescription.isCfgType(CfgTypeMask.Delta)) {
                    if (!deltaElement.getLocalName().equals(subjectClass.getLocalName())) {
                        throw new IllegalArgumentException("Invalid xml content");
                    }
                    CfgUtilities.applyDeltaClass(subjectClass, (Element)deltaElement, ((ICfgClassOperationalInfo)((Object)deltaClassDescription)).getSubjectClassDescription());
                    continue;
                }
                final CfgDescriptionAttributeReference deltaAttrRef = deltaAttributeDescription;
                List<Node> deltaContentElements2 = Linq.selectWithOrder(deltaElement.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                    @Override
                    public int compare(Node o1, Node o2) {
                        CfgOperation op1 = deltaAttrRef.getCfgClass().getAttributeByName(o1.getLocalName()).getOperation();
                        CfgOperation op2 = deltaAttrRef.getCfgClass().getAttributeByName(o2.getLocalName()).getOperation();
                        return op2.compareTo(op1);
                    }
                });
                String subjAttrXName = ((ICfgNameOperationalInfo)((Object)deltaAttributeDescription)).getSubjectName();
                CfgUtilities.applyDelta(CfgUtilities.findChildElement(subjectClass, subjAttrXName), deltaContentElements2, deltaAttributeDescription.getCfgClass());
                continue;
            }
            String subjAttrXName = ((ICfgNameOperationalInfo)((Object)deltaAttributeDescription)).getSubjectName();
            Element subjectElement = CfgUtilities.findChildElement(subjectClass, subjAttrXName);
            if (!deltaAttributeDescription.isCfgType(CfgTypeMask.KvList)) {
                if (subjectElement == null) {
                    CfgDescriptionClass subjClassDesc = ((ICfgClassOperationalInfo)((Object)deltaClassDescription)).getSubjectClassDescription();
                    subjectElement = resDoc.createElementNS(CfgUtilities.getDataNS(), subjAttrXName);
                    CfgUtilities.addElement(subjectClass, subjectElement, subjClassDesc);
                }
                CfgUtilities.applyDeltaList(subjectElement, (Element)deltaElement, deltaAttributeDescription);
                continue;
            }
            CfgUtilities.applyDeltaKvList(subjectElement, (Element)deltaElement, deltaAttributeDescription);
        }
    }

    private static void applyDeltaClass(Element subjectClass, Element deltaClass, CfgDescriptionClass subjectClassDescription) {
        for (Node element = deltaClass.getFirstChild(); element != null; element = element.getNextSibling()) {
            CfgDescriptionAttribute subjectAttributeDescription = subjectClassDescription.getAttributeByName(element.getLocalName());
            if (subjectAttributeDescription.isKey()) continue;
            Element subjectElement = CfgUtilities.findChildElement(subjectClass, element.getNodeName());
            if (subjectElement == null) {
                CfgUtilities.addElement(subjectClass, subjectClass.getOwnerDocument().importNode(element, true), subjectClassDescription);
                continue;
            }
            if (!subjectAttributeDescription.isCfgType(CfgTypeMask.KvList)) {
                CfgUtilities.performOperation(subjectElement, (Element)element, subjectAttributeDescription);
                continue;
            }
            CfgUtilities.applyDeltaKvList(subjectElement, (Element)element, subjectAttributeDescription);
        }
    }

    private static void applyDeltaList(Element subjectList, Element deltaList, CfgDescriptionAttributeReference deltaAttributeDescription) {
        if (deltaAttributeDescription.getOperation() == CfgOperation.Add) {
            CfgUtilities.performOperation(subjectList, deltaList, deltaAttributeDescription);
        } else {
            Element subjectListElement = null;
            for (Element deltaElement = (Element)deltaList.getFirstChild(); deltaElement != null; deltaElement = (Element)deltaElement.getNextSibling()) {
                subjectListElement = !deltaAttributeDescription.isCfgType(CfgTypeMask.Class) ? CfgUtilities.findClassByKey(subjectList, deltaElement, deltaAttributeDescription) : (!deltaAttributeDescription.getCfgClass().isCfgType(CfgTypeMask.Alias) ? CfgUtilities.findClassByClass(subjectList, deltaElement, deltaAttributeDescription) : CfgUtilities.findClassByCfgId(subjectList, deltaElement, deltaAttributeDescription));
                if (subjectListElement == null) continue;
                CfgUtilities.performOperation(subjectListElement, deltaElement, deltaAttributeDescription);
            }
            if (!subjectList.hasChildNodes()) {
                subjectList.getParentNode().removeChild(subjectList);
            }
        }
    }

    private static void applyDeltaKvList(Element subjectList, Element deltaList, final CfgDescriptionAttribute deltaAttributeDescription) {
        if (deltaList.hasChildNodes()) {
            for (Node element = deltaList.getFirstChild(); element != null; element = element.getNextSibling()) {
                final Element deltaElem = (Element)element;
                Element subjectElement = (Element)Linq.firstOrDefault(subjectList.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                    @Override
                    public boolean condition(Node item) {
                        return deltaAttributeDescription.getComparer().equals(item, deltaElem);
                    }
                });
                if (subjectElement == null) {
                    if (deltaAttributeDescription.getOperation() != CfgOperation.Add) {
                        throw new IllegalArgumentException("Invalid xml content");
                    }
                    CfgUtilities.performOperation(subjectList, (Element)element, deltaAttributeDescription);
                    continue;
                }
                CfgUtilities.applyDeltaKvList(subjectElement, (Element)element, deltaAttributeDescription);
            }
        } else {
            CfgUtilities.performOperation(subjectList, deltaList, deltaAttributeDescription);
        }
    }

    private static void performOperation(Element subjectElement, Element deltaElement, CfgDescriptionAttribute attributeDescription) {
        Document resDoc = subjectElement.getOwnerDocument();
        switch (attributeDescription.getOperation()) {
            case Change: {
                if (attributeDescription.isCfgType(CfgTypeMask.KvList)) {
                    subjectElement.setAttribute("value", deltaElement.getAttribute("value"));
                    break;
                }
                if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
                    CfgUtilities.applyDeltaClass(subjectElement, deltaElement, ((CfgDescriptionAttributeReferenceClass)attributeDescription).getCfgClass());
                    break;
                }
                CfgUtilities.changePrimitive(subjectElement, deltaElement, attributeDescription);
                break;
            }
            case Remove: {
                if (attributeDescription.isCfgType(CfgTypeMask.KvList)) {
                    Element parent = (Element)subjectElement.getParentNode();
                    parent.removeChild(subjectElement);
                    if (parent.hasAttributes() || parent.hasChildNodes()) break;
                    parent.getParentNode().removeChild(parent);
                    break;
                }
                subjectElement.getParentNode().removeChild(subjectElement);
                break;
            }
            case Add: {
                if (attributeDescription.isCfgType(CfgTypeMask.KvList)) {
                    subjectElement.appendChild(resDoc.importNode(deltaElement, true));
                    break;
                }
                for (Node element : Linq.select(deltaElement.getChildNodes(), null)) {
                    subjectElement.appendChild(resDoc.importNode(CfgUtilities.cleanUpElement((Element)element), true));
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid Operation: " + (Object)((Object)attributeDescription.getOperation()));
            }
        }
    }

    private static Element findClassByKey(Element classList, final Element deltaKey, final CfgDescriptionAttributeReference deltaAttributeDescription) {
        final CfgDescriptionAttributeReference subjAttrDesc = (CfgDescriptionAttributeReference)((ICfgAttributeOperationalInfo)((Object)deltaAttributeDescription)).getSubjectAttributeDescription();
        final boolean isClass = subjAttrDesc.isCfgType(CfgTypeMask.Class);
        return (Element)Linq.first(classList.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

            @Override
            public boolean condition(Node item) {
                return deltaAttributeDescription.getComparer().equals(isClass ? subjAttrDesc.getCfgClass().getKeys(item).get(0) : item, deltaKey);
            }
        });
    }

    private static Element findClassByClass(Element classList, final Element clazz, final CfgDescriptionAttributeReference deltaAttributeDescription) {
        return (Element)Linq.firstOrDefault(classList.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

            @Override
            public boolean condition(Node item) {
                return deltaAttributeDescription.getCfgClass().getEqualityComparer().equals(item, clazz);
            }
        });
    }

    private static Element findClassByCfgId(Element classList, Element clazz, final CfgDescriptionAttributeReference deltaAttributeDescription) {
        final CfgDescriptionAttributeReference subjAttrDesc = (CfgDescriptionAttributeReference)((ICfgAttributeOperationalInfo)((Object)deltaAttributeDescription)).getSubjectAttributeDescription();
        final List<Node> deltaKeys = deltaAttributeDescription.getCfgClass().getKeys(clazz);
        return (Element)Linq.first(classList.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

            @Override
            public boolean condition(Node item) {
                return Linq.sequenceEqual(deltaKeys, subjAttrDesc.getCfgClass().getKeys(item), deltaAttributeDescription.getComparer());
            }
        });
    }

    private static void changePrimitive(Element subjectElement, Element deltaElement, CfgDescriptionAttribute attributeDescription) {
        if (attributeDescription.isCfgType(CfgTypeMask.String)) {
            Attr attr = deltaElement.getAttributeNode("value");
            if (attr != null) {
                subjectElement.setAttribute("value", attr.getValue());
            } else {
                subjectElement.getParentNode().removeChild(subjectElement);
            }
        } else if (attributeDescription.isCfgType(CfgTypeMask.Integer) || attributeDescription.isCfgType(CfgTypeMask.Link) || attributeDescription.isCfgType(CfgTypeMask.Enum)) {
            if (subjectElement.getAttribute("value").equals(deltaElement.getAttribute("value"))) {
                if (!attributeDescription.isCfgType(CfgTypeMask.Enum) || !(attributeDescription instanceof CfgDescriptionAttributeEnumItem) || ((CfgDescriptionAttributeEnumItem)attributeDescription).getEnumDescription() == null || ((CfgDescriptionAttributeEnumItem)attributeDescription).getEnumDescription().getCfgEnum() != CfgEnumType.CfgFlag) {
                    subjectElement.setAttribute("value", "0");
                }
            } else {
                subjectElement.setAttribute("value", deltaElement.getAttribute("value"));
            }
        } else {
            throw new RuntimeException("Attribute [" + attributeDescription.getName() + "] has invalid type: " + attributeDescription.getTypeMaskString());
        }
    }

    private static void addElement(Node subjectClass, Node elementToAdd, CfgDescriptionClass subjectClassDescription) {
        if (elementToAdd == null) {
            return;
        }
        CfgDescriptionAttribute deltaAttributeDescription = subjectClassDescription.getAttributeByName(elementToAdd.getLocalName());
        Node addAfter = null;
        for (Node child = subjectClass.getFirstChild(); child != null; child = child.getNextSibling()) {
            CfgDescriptionAttribute attr = subjectClassDescription.getAttributeByName(child.getLocalName());
            if (attr.getIndex() >= deltaAttributeDescription.getIndex()) continue;
            addAfter = (Element)child;
        }
        if (addAfter != null) {
            if (addAfter.getNextSibling() != null) {
                subjectClass.insertBefore(elementToAdd, addAfter.getNextSibling());
            } else {
                subjectClass.appendChild(elementToAdd);
            }
        } else {
            subjectClass.insertBefore(elementToAdd, subjectClass.getFirstChild());
        }
    }

    private static void addElements(Node subjectClass, List<Node> elementsToAdd, CfgDescriptionClass subjectClassDescription) {
        for (Node element : elementsToAdd) {
            CfgUtilities.addElement(subjectClass, element, subjectClassDescription);
        }
    }

    private static void addElementsClones(Node subjectClass, List<Node> elementsToAdd, CfgDescriptionClass subjectClassDescription) {
        Document doc = subjectClass.getOwnerDocument();
        for (Node element : elementsToAdd) {
            CfgUtilities.addElement(subjectClass, doc.importNode(element, true), subjectClassDescription);
        }
    }

    private static Element cleanUpElement(Element deltaElement) {
        Node child = deltaElement.getFirstChild();
        while (child != null) {
            String val = null;
            Node attr = child.getAttributes().getNamedItem("value");
            if (attr != null) {
                val = attr.getNodeValue();
            }
            if (val == null || val.equals("")) {
                Node child1 = child.getNextSibling();
                deltaElement.removeChild(child);
                child = child1;
                continue;
            }
            child = child.getNextSibling();
        }
        return deltaElement;
    }

    private static void cleanUpClass(Element clazz, CfgDescriptionClass classDescription) {
        Element elemT;
        Element elem = CfgUtilities.getFirstChildElement(clazz);
        while (elem != null) {
            if (elem.hasAttributes() && !classDescription.getAttributeByName(elem.getLocalName()).isCfgType(CfgTypeMask.String) && (elem.getAttribute("value").equals("") || elem.getAttribute("value").equals("0"))) {
                elemT = CfgUtilities.getNextSiblingElement(elem);
                clazz.removeChild(elem);
                elem = elemT;
                continue;
            }
            elem = CfgUtilities.getNextSiblingElement(elem);
        }
        elem = CfgUtilities.getFirstChildElement(clazz);
        while (elem != null) {
            if (!(elem.hasAttributes() || elem.hasChildNodes() || classDescription.getAttributeByName(elem.getLocalName()).isCfgType(CfgTypeMask.KvList))) {
                elemT = CfgUtilities.getNextSiblingElement(elem);
                clazz.removeChild(elem);
                elem = elemT;
                continue;
            }
            elem = CfgUtilities.getNextSiblingElement(elem);
        }
        elem = CfgUtilities.getFirstChildElement(clazz);
        while (elem != null) {
            if (!elem.hasAttributes() && elem.hasChildNodes() && classDescription.getAttributeByName(elem.getLocalName()).isCfgType(CfgTypeMask.Class)) {
                CfgDescriptionAttributeReference referenceDescription = (CfgDescriptionAttributeReference)classDescription.getAttributeByName(elem.getLocalName());
                if (referenceDescription.isCfgType(CfgTypeMask.List)) {
                    for (Element listClassElement = CfgUtilities.getFirstChildElement(elem); listClassElement != null; listClassElement = (Element)listClassElement.getNextSibling()) {
                        CfgUtilities.cleanUpClass(listClassElement, referenceDescription.getCfgClass());
                    }
                } else {
                    CfgUtilities.cleanUpClass(elem, referenceDescription.getCfgClass());
                }
            }
            elem = CfgUtilities.getNextSiblingElement(elem);
        }
    }

    public static Element getFirstChildElement(Node container) {
        for (Node child = container.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node element) {
        for (Node next = element.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (!(next instanceof Element)) continue;
            return (Element)next;
        }
        return null;
    }

    public static List<Element> getChildElements(Node container) {
        LinkedList<Element> res = null;
        if (container instanceof Element) {
            res = new LinkedList<Element>();
            for (Node child = container.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof Element)) continue;
                res.add((Element)child);
            }
        }
        return res;
    }

    public static Element findChildElement(Node container, String name) {
        for (Node child = container.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Node findFirst(List<Node> list, String name) {
        for (Node item : list) {
            if (!item.getNodeName().equals(name)) continue;
            return item;
        }
        return null;
    }
}

