/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.confserver;

import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventAccountRead;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventAccountUpdated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventAuthenticated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventBriefInfo;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventError;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventError2;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventHistoryLogSent;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventLocaleRead;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventNotificationRegistered;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventNotificationUnregistered;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectCreated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectDeleted;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectPermissionsRead;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectUpdated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectsRead;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectsSent;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventOperationalModeChanged;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventOperationalModeRead;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventPasswordChanged;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventPermissionsChanged;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventPermissionsNotificationRegistered;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventPermissionsNotificationUnregistered;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventPermissionsRead;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventPermissionsUpdated;
import com.genesyslab.platform.configuration.protocol.confserver.requests.connectivity.RequestHistoryLog;
import com.genesyslab.platform.configuration.protocol.confserver.requests.locale.RequestReadLocale;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestCreateObject;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestDeleteObject;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestGetBriefInfo;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestReadObjects;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestReadObjects2;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestRegisterNotification;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestUnregisterNotification;
import com.genesyslab.platform.configuration.protocol.confserver.requests.objects.RequestUpdateObject;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestAuthenticate;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestChangeOperationalMode;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestChangePassword;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestReadAccount;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestReadObjectPermissions;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestReadOperationalMode;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestReadPermissions;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestRegisterPermissionsNotification;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestUnregisterPermissionsNotification;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestUpdateAccount;
import com.genesyslab.platform.configuration.protocol.confserver.requests.security.RequestUpdatePermissions;

public class ConfServerProtocolFactory
extends AbstractProtocolFactory {
    public static final ProtocolDescription PROTOCOL_DESCRIPTION = new ProtocolDescription("Configuration", "ConfServer");

    public ProtocolDescription getProtocolDescription() {
        return PROTOCOL_DESCRIPTION;
    }

    public String getProtocolVersion() {
        return "7.6.000";
    }

    protected Message createRequest(int id) {
        switch (id) {
            case 7: {
                return RequestCreateObject.create();
            }
            case 8: {
                return RequestUpdateObject.create();
            }
            case 9: {
                return RequestDeleteObject.create();
            }
            case 10: {
                return RequestReadObjects.create();
            }
            case 24: {
                return RequestReadPermissions.create();
            }
            case 26: {
                return RequestUpdatePermissions.create();
            }
            case 28: {
                return RequestGetBriefInfo.create();
            }
            case 30: {
                return RequestReadAccount.create();
            }
            case 32: {
                return RequestUpdateAccount.create();
            }
            case 36: {
                return RequestChangeOperationalMode.create();
            }
            case 38: {
                return RequestReadOperationalMode.create();
            }
            case 41: {
                return RequestHistoryLog.create();
            }
            case 47: {
                return RequestReadObjectPermissions.create();
            }
            case 58: {
                return RequestReadLocale.create();
            }
            case 62: {
                return RequestRegisterPermissionsNotification.create();
            }
            case 63: {
                return RequestUnregisterPermissionsNotification.create();
            }
            case 69: {
                return RequestAuthenticate.create();
            }
            case 77: {
                return RequestUnregisterNotification.create();
            }
            case 78: {
                return RequestRegisterNotification.create();
            }
            case 81: {
                return RequestChangePassword.create();
            }
            case 83: {
                return RequestReadObjects2.create();
            }
        }
        return null;
    }

    protected Message createEvent(int id) {
        switch (id) {
            case 2: {
                return EventError.create();
            }
            case 4: {
                return EventError2.create();
            }
            case 12: {
                return EventNotificationUnregistered.create();
            }
            case 13: {
                return EventNotificationRegistered.create();
            }
            case 16: {
                return EventObjectDeleted.create();
            }
            case 20: {
                return EventObjectsSent.create();
            }
            case 25: {
                return EventPermissionsRead.create();
            }
            case 27: {
                return EventPermissionsUpdated.create();
            }
            case 29: {
                return EventBriefInfo.create();
            }
            case 31: {
                return EventAccountRead.create();
            }
            case 33: {
                return EventAccountUpdated.create();
            }
            case 37: {
                return EventOperationalModeChanged.create();
            }
            case 39: {
                return EventOperationalModeRead.create();
            }
            case 42: {
                return EventHistoryLogSent.create();
            }
            case 48: {
                return EventObjectPermissionsRead.create();
            }
            case 59: {
                return EventLocaleRead.create();
            }
            case 64: {
                return EventPermissionsNotificationRegistered.create();
            }
            case 65: {
                return EventPermissionsNotificationUnregistered.create();
            }
            case 66: {
                return EventPermissionsChanged.create();
            }
            case 70: {
                return EventAuthenticated.create();
            }
            case 73: {
                return EventObjectsRead.create();
            }
            case 74: {
                return EventObjectCreated.create();
            }
            case 75: {
                return EventObjectUpdated.create();
            }
            case 82: {
                return EventPasswordChanged.create();
            }
        }
        return null;
    }

    protected String getEventMessageName(int id) {
        switch (id) {
            case 2: {
                return "EventError";
            }
            case 4: {
                return "EventError2";
            }
            case 12: {
                return "EventNotificationUnregistered";
            }
            case 13: {
                return "EventNotificationRegistered";
            }
            case 16: {
                return "EventObjectDeleted";
            }
            case 20: {
                return "EventObjectsSent";
            }
            case 25: {
                return "EventPermissionsRead";
            }
            case 27: {
                return "EventPermissionsUpdated";
            }
            case 29: {
                return "EventBriefInfo";
            }
            case 31: {
                return "EventAccountRead";
            }
            case 33: {
                return "EventAccountUpdated";
            }
            case 37: {
                return "EventOperationalModeChanged";
            }
            case 39: {
                return "EventOperationalModeRead";
            }
            case 42: {
                return "EventHistoryLogSent";
            }
            case 48: {
                return "EventObjectPermissionsRead";
            }
            case 59: {
                return "EventLocaleRead";
            }
            case 64: {
                return "EventPermissionsNotificationRegistered";
            }
            case 65: {
                return "EventPermissionsNotificationUnregistered";
            }
            case 66: {
                return "EventPermissionsChanged";
            }
            case 70: {
                return "EventAuthenticated";
            }
            case 73: {
                return "EventObjectsRead";
            }
            case 74: {
                return "EventObjectCreated";
            }
            case 75: {
                return "EventObjectUpdated";
            }
            case 82: {
                return "EventPasswordChanged";
            }
        }
        return "";
    }

    protected String getRequestMessageName(int id) {
        switch (id) {
            case 7: {
                return "RequestCreateObject";
            }
            case 8: {
                return "RequestUpdateObject";
            }
            case 9: {
                return "RequestDeleteObject";
            }
            case 10: {
                return "RequestReadObjects";
            }
            case 24: {
                return "RequestReadPermissions";
            }
            case 26: {
                return "RequestUpdatePermissions";
            }
            case 28: {
                return "RequestGetBriefInfo";
            }
            case 30: {
                return "RequestReadAccount";
            }
            case 32: {
                return "RequestUpdateAccount";
            }
            case 36: {
                return "RequestChangeOperationalMode";
            }
            case 38: {
                return "RequestReadOperationalMode";
            }
            case 41: {
                return "RequestHistoryLog";
            }
            case 47: {
                return "RequestReadObjectPermissions";
            }
            case 58: {
                return "RequestReadLocale";
            }
            case 62: {
                return "RequestRegisterPermissionsNotification";
            }
            case 63: {
                return "RequestUnregisterPermissionsNotification";
            }
            case 69: {
                return "RequestAuthenticate";
            }
            case 77: {
                return "RequestUnregisterNotification";
            }
            case 78: {
                return "RequestRegisterNotification";
            }
            case 81: {
                return "RequestChangePassword";
            }
            case 83: {
                return "RequestReadObjects2";
            }
        }
        return "";
    }

    public String getMessageName(int id) {
        String name = this.getEventMessageName(id);
        if (name != null && !name.equals("")) {
            return name;
        }
        name = this.getRequestMessageName(id);
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Protocol doesn't support message #" + id);
        }
        return name;
    }

    public Message createMessage(int id) {
        Message message = this.createEvent(id);
        if (message != null) {
            return message;
        }
        message = this.createRequest(id);
        if (message != null) {
            return message;
        }
        throw new IllegalArgumentException("Protocol doesn't support message #" + id);
    }

    public Message createMessage(int id, String name) {
        if (name == null || name.equals("")) {
            return this.createMessage(id);
        }
        Message message = null;
        message = name.startsWith("Event") ? this.createEvent(id) : this.createRequest(id);
        if (message == null) {
            throw new IllegalArgumentException("Protocol doesn't support message #" + id);
        }
        return message;
    }
}

