/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceLink;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructure;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgOperation;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.obj.ConfIntegerCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectBase;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectsCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfStringCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructure;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructureCollection;
import com.genesyslab.platform.configuration.protocol.runtime.channel.AesUtil;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReader;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;
import java.io.StringWriter;
import java.util.ArrayList;

public abstract class ConfSerializer
implements EncodingSupport {
    protected static final String PASSWORD = "password";
    protected AesUtil aes;
    protected CfgMetadata metadata;
    protected String stringsEncoding = null;
    protected final ILogger dataLogger = Log.getDataLogger();

    protected ConfSerializer(CfgMetadata metadata, AesUtil aes) {
        this.metadata = metadata;
        this.aes = aes;
    }

    public CfgMetadata getMetadata() {
        return this.metadata;
    }

    public void setStringAttributesEncoding(String strEncoding) {
        this.stringsEncoding = strEncoding != null && !strEncoding.equals("") ? strEncoding : null;
    }

    public abstract ConfObjectsCollection deserialize(CfgDescriptionObject var1, String var2) throws CodecException;

    public abstract String serialize(ConfObject var1) throws CodecException;

    public abstract String serialize(ConfObjectsCollection var1) throws CodecException;

    protected KeyValuePair deserializeKVPair(TokenReader tokenReader) throws CodecException {
        TokenType tokenType = tokenReader.getTokenType();
        if (tokenType == TokenType.EMPTY) {
            return null;
        }
        String tokenKey = tokenReader.getKey();
        String tokenData = tokenReader.getData();
        KeyValuePair pair = null;
        if (tokenType == TokenType.STRING) {
            String strValue = null;
            strValue = PASSWORD.equals(tokenKey) ? this.getDecrypted(tokenData) : tokenData;
            if (strValue == null) {
                strValue = "";
            }
            pair = new KeyValuePair(tokenKey, strValue);
        } else if (tokenType == TokenType.INTEGER) {
            pair = new KeyValuePair(tokenKey, Integer.parseInt(tokenData));
        } else if (tokenType == TokenType.BINARY) {
            pair = new KeyValuePair(tokenKey, Hex.decodeHex((char[])tokenData.toCharArray()));
        } else {
            return null;
        }
        return pair;
    }

    protected KeyValuePair deserializeKVListPair(TokenReader tokenReader) throws CodecException {
        String key = tokenReader.getKey();
        KeyValueCollection value = new KeyValueCollection();
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            KeyValuePair pair = tokenReader.getTokenType() == TokenType.KVLIST ? this.deserializeKVListPair(tokenReader) : this.deserializeKVPair(tokenReader);
            if (pair == null) continue;
            value.add((Object)pair);
        }
        return new KeyValuePair(key, value);
    }

    protected Object createElement(CfgDescriptionAttribute attr, TokenReader tokenReader) throws CodecException {
        return this.createElement(attr, tokenReader, false);
    }

    protected Object createElement(CfgDescriptionAttribute attributeDescription, TokenReader tokenReader, boolean isAddedObjlistElement) throws CodecException {
        if (attributeDescription.isCfgType(CfgTypeMask.List)) {
            if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
                return this.deserializeObjList((CfgDescriptionAttributeReferenceClass)attributeDescription, tokenReader);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.String)) {
                return this.deserializeStrList((CfgDescriptionAttributeReference)attributeDescription, tokenReader);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.Integer)) {
                return this.deserializeIntList((CfgDescriptionAttributeReference)attributeDescription, tokenReader);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.Link)) {
                return this.deserializeDBIDList((CfgDescriptionAttributeReferenceLink)attributeDescription, tokenReader);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.KvList)) {
                return this.deserializeKVList(attributeDescription.getName(), tokenReader);
            }
        } else {
            if (attributeDescription.isCfgType(CfgTypeMask.Primitive) || attributeDescription.isCfgType(CfgTypeMask.Link)) {
                return this.deserializePrimitive(attributeDescription.getName(), tokenReader, isAddedObjlistElement);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
                return this.deserializePObject((CfgDescriptionAttributeReference)attributeDescription, tokenReader);
            }
        }
        throw new CodecException("Type [" + attributeDescription.getTypeMaskString() + "] is not supported.");
    }

    protected Object deserializePrimitive(String name, TokenReader tokenReader) throws CodecException {
        return this.deserializePrimitive(name, tokenReader, false);
    }

    protected Object deserializePrimitive(String name, TokenReader tokenReader, boolean isAddedObjlistElement) throws CodecException {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        String value = tokenReader.getData();
        if (value == null) {
            value = "";
        }
        if (tokenReader.getTokenType() == TokenType.STRING) {
            if (PASSWORD.equals(name) && tokenReader.getData() != null) {
                value = this.getDecrypted(value);
            }
            return value;
        }
        if (tokenReader.isDelta() && !isAddedObjlistElement) {
            int iVal = 0;
            if (!value.equals("")) {
                try {
                    iVal = Integer.parseInt(value);
                }
                catch (Exception ex) {
                    throw new CodecException("Error parsing int value '" + value + "'", (Throwable)ex);
                }
            }
            if (iVal == 0) {
                value = null;
            }
        }
        if (value != null) {
            if (tokenReader.getTokenType() == TokenType.STRING) {
                return value;
            }
            if (tokenReader.getTokenType() == TokenType.INTEGER) {
                try {
                    return Integer.parseInt(value);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    protected ConfIntegerCollection deserializeIntList(CfgDescriptionAttributeReference attributeDescription, TokenReader tokenReader) throws CodecException {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        ConfIntegerCollection result = null;
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            if (result == null) {
                result = new ConfIntegerCollection(attributeDescription);
            }
            if (tokenReader.getTokenType() != TokenType.EMPTY) {
                try {
                    result.add(Integer.parseInt(tokenReader.getData()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new CodecException("Error parsing int value", (Throwable)e);
                }
            }
            result.add(null);
        }
        return result;
    }

    protected ConfIntegerCollection deserializeDBIDList(CfgDescriptionAttributeReferenceLink attributeDescription, TokenReader tokenReader) throws CodecException {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        ConfIntegerCollection result = null;
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            if (result == null) {
                result = new ConfIntegerCollection(attributeDescription);
            }
            if (tokenReader.getTokenType() != TokenType.EMPTY) {
                try {
                    Integer value = Integer.parseInt(tokenReader.getData());
                    result.add(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new CodecException("Error parsing int value", (Throwable)e);
                }
            }
            result.add(null);
        }
        return result;
    }

    protected ConfStructureCollection deserializeObjList(CfgDescriptionAttributeReferenceClass attr, TokenReader tokenReader) throws CodecException {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        ArrayList result = null;
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            ConfStructure elem;
            if (tokenReader.getTokenType() == TokenType.EMPTY) continue;
            boolean isAdded = false;
            if (attr.getOperation() == CfgOperation.Unknown || attr.getOperation() == CfgOperation.Add) {
                isAdded = true;
            }
            if ((elem = (ConfStructure)this.deserializePObject(attr, tokenReader, isAdded)) == null) continue;
            if (result == null) {
                result = new ConfStructureCollection(attr);
            }
            result.add(elem);
        }
        return result;
    }

    protected ConfObjectBase deserializePObject(CfgDescriptionAttributeReference attr, TokenReader tokenReader) throws CodecException {
        return this.deserializePObject(attr, tokenReader, false);
    }

    protected ConfObjectBase deserializePObject(CfgDescriptionAttributeReference attr, TokenReader tokenReader, boolean isAddedObjlistElement) throws CodecException {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        CfgDescriptionClass classDescription = attr.getCfgClass();
        ConfObjectBase pobject = null;
        for (CfgDescriptionAttribute attribute : classDescription.getAttributes()) {
            Object attrValue;
            if (!tokenReader.read()) break;
            if (tokenReader.getTokenType() == TokenType.EMPTY && tokenReader.getData() == null || (attrValue = this.createElement(attribute, tokenReader, isAddedObjlistElement)) == null) continue;
            if (pobject == null) {
                pobject = classDescription.isCfgType(CfgTypeMask.Structure) ? new ConfStructure((CfgDescriptionStructure)classDescription) : new ConfObject((CfgDescriptionObject)classDescription);
            }
            pobject.setPropertyValue(attribute.getIndex(), attrValue);
        }
        tokenReader.read();
        return pobject;
    }

    protected KeyValueCollection deserializeKVList(String name, TokenReader tokenReader) throws CodecException {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            if (tokenReader.getData() == null) {
                return null;
            }
            return new KeyValueCollection();
        }
        KeyValueCollection result = null;
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            KeyValuePair pair;
            if (result == null) {
                result = new KeyValueCollection();
            }
            if ((pair = tokenReader.getTokenType() == TokenType.KVLIST ? this.deserializeKVListPair(tokenReader) : this.deserializeKVPair(tokenReader)) == null) continue;
            result.add((Object)pair);
        }
        return result;
    }

    protected ConfStringCollection deserializeStrList(CfgDescriptionAttributeReference attr, TokenReader tokenReader) {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        ArrayList result = null;
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            if (result == null) {
                result = new ConfStringCollection(attr);
            }
            result.add(tokenReader.getData());
        }
        return result;
    }

    protected abstract void serializeKVList(CfgDescriptionAttributeReference var1, KeyValueCollection var2, StringWriter var3) throws CodecException;

    protected abstract void serializeIntList(CfgDescriptionAttributeReference var1, ConfIntegerCollection var2, StringWriter var3) throws CodecException;

    protected abstract void serializeDBIdList(CfgDescriptionAttributeReference var1, ConfIntegerCollection var2, StringWriter var3) throws CodecException;

    protected abstract void serializeObjList(CfgDescriptionAttributeReference var1, ConfStructureCollection var2, StringWriter var3) throws CodecException;

    protected abstract void serializePObject(CfgDescriptionAttributeReference var1, ConfObjectBase var2, StringWriter var3) throws CodecException;

    protected abstract void serializePrimitive(CfgDescriptionAttribute var1, char var2, Object var3, StringWriter var4) throws CodecException;

    protected abstract void writeCfgString(CfgDescriptionAttribute var1, Object var2, StringWriter var3) throws CodecException;

    protected String getEncrypted(String val) throws CodecException {
        return this.aes != null ? this.aes.encrypt(val, this.stringsEncoding) : val;
    }

    protected String getDecrypted(String val) throws CodecException {
        if (val == null) {
            return null;
        }
        return this.aes != null ? this.aes.decrypt(val, this.stringsEncoding) : val;
    }

    protected String createTruncatedLogTrace(String strData) {
        if (strData != null) {
            String hex;
            String str = strData;
            int len = str.length();
            if (len >= 150) {
                String str1 = str.substring(0, 50);
                String str2 = str.substring(len - 50);
                str = str1 + " <...> " + str2;
                hex = new String(Hex.encodeHex((byte[])str1.getBytes())) + "..." + new String(Hex.encodeHex((byte[])str2.getBytes()));
            } else {
                hex = new String(Hex.encodeHex((byte[])str.getBytes()));
            }
            return "length=" + len + ": " + str + " {" + hex + "}";
        }
        return "NULL";
    }
}

