/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.ValueType;
import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObjectDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.obj.ConfIntegerCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectBase;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectDelta;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectsCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfStringCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructure;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructureCollection;
import com.genesyslab.platform.configuration.protocol.runtime.channel.AesUtil;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ConfSerializer;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReader;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReaderV7;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;
import java.io.StringWriter;

public class ConfSerializerV7
extends ConfSerializer {
    private static ILogger log = Log.getLogger(ConfSerializerV7.class);

    public ConfSerializerV7(CfgMetadata metadata, AesUtil aes) {
        super(metadata, aes);
    }

    public ConfObjectsCollection deserialize(CfgDescriptionObject typeDescription, String cfgStr) throws CodecException {
        if (log.isDebug()) {
            log.debugFormat("Serializing {0}: {1}", (Object)new Object[]{typeDescription.getName(), this.createTruncatedLogTrace(cfgStr)});
        }
        if (this.dataLogger.isDebug()) {
            this.dataLogger.debugFormat("Serializing {0}: {1}", (Object)new Object[]{typeDescription.getName(), cfgStr});
        }
        ConfObjectsCollection result = new ConfObjectsCollection(typeDescription);
        TokenReaderV7 tokenReader = new TokenReaderV7(cfgStr, typeDescription.isCfgType(CfgTypeMask.Delta));
        while (((TokenReader)tokenReader).read()) {
            ConfObject obj = null;
            if (typeDescription.isCfgType(CfgTypeMask.Delta)) {
                obj = new ConfObjectDelta((CfgDescriptionObjectDelta)typeDescription);
            } else if (typeDescription.isCfgType(CfgTypeMask.Object)) {
                obj = new ConfObject(typeDescription);
            } else {
                throw new CodecException("Unsupported object type");
            }
            for (CfgDescriptionAttribute attribute : typeDescription.getAttributes()) {
                Object value;
                if (!((TokenReader)tokenReader).read()) {
                    return result;
                }
                if (tokenReader.getTokenType() == TokenType.EMPTY && tokenReader.getData() == null || (value = this.createElement(attribute, tokenReader)) == null) continue;
                obj.setPropertyValue(attribute.getIndex(), value);
            }
            result.add(obj);
            if (!"cfglib_schema".equals(typeDescription.getName()) && ((TokenReader)tokenReader).read()) continue;
        }
        return result;
    }

    public String serialize(ConfObjectsCollection objects) throws CodecException {
        if (objects == null) {
            throw new CodecException("ConfObjectsCollection is null");
        }
        if (objects.size() != 1) {
            throw new CodecException("Only one object serialization is supported");
        }
        return this.serialize((ConfObject)objects.get(0));
    }

    public String serialize(ConfObject object) throws CodecException {
        CfgDescriptionObject typeDescription = object.getClassInfo();
        if (log.isDebug()) {
            log.debug((Object)("Encoding type '" + typeDescription.getName()));
        }
        StringWriter cfgWriter = new StringWriter();
        cfgWriter.write(23);
        cfgWriter.write(31);
        for (CfgDescriptionAttribute attribute : typeDescription.getAttributes()) {
            this.writeCfgString(attribute, object.getPropertyValue(attribute.getSchemaName()), cfgWriter);
        }
        cfgWriter.write(24);
        String s = cfgWriter.toString();
        if (log.isDebug()) {
            log.debugFormat("serialized to: {0}", (Object)this.createTruncatedLogTrace(s));
        }
        if (this.dataLogger.isDebug()) {
            this.dataLogger.debugFormat("serialized dump: {0}", (Object)s);
        }
        return s;
    }

    protected void serializeKVPair(CfgDescriptionAttributeReference attr, KeyValuePair value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(23);
        if (value != null) {
            cfgWriter.write(value.getStringKey());
            if (value.getValueType() == ValueType.STRING) {
                cfgWriter.write(27);
            } else if (value.getValueType() == ValueType.INT) {
                cfgWriter.write(25);
            } else if (value.getValueType() == ValueType.BINARY) {
                cfgWriter.write(30);
            }
            if (value.getValueType() == ValueType.BINARY) {
                char[] hex = Hex.encodeHex((byte[])value.getBinaryValue());
                cfgWriter.write(hex, 0, hex.length);
            } else if (value.getValueType() == ValueType.STRING && value.getStringKey().equals("password")) {
                String encryptedValue = this.getEncrypted(value.getStringValue());
                cfgWriter.write(encryptedValue);
            } else {
                cfgWriter.write(value.getStringValue());
            }
        }
        cfgWriter.write(24);
    }

    protected void serializeKVListPair(CfgDescriptionAttributeReference attr, KeyValuePair value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(23);
        cfgWriter.write(value.getStringKey());
        cfgWriter.write(29);
        for (Object oPair : value.getTKVValue()) {
            KeyValuePair pair = (KeyValuePair)oPair;
            if (pair.getValueType() == ValueType.TKV_LIST) {
                this.serializeKVListPair(attr, pair, cfgWriter);
                continue;
            }
            this.serializeKVPair(attr, pair, cfgWriter);
        }
        cfgWriter.write(24);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeCfgString(CfgDescriptionAttribute attributeDescription, Object value, StringWriter cfgWriter) throws CodecException {
        if (attributeDescription.isCfgType(CfgTypeMask.List)) {
            if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
                this.serializeObjList((CfgDescriptionAttributeReference)attributeDescription, (ConfStructureCollection)value, cfgWriter);
                return;
            } else if (attributeDescription.isCfgType(CfgTypeMask.Integer)) {
                this.serializeIntList((CfgDescriptionAttributeReference)attributeDescription, (ConfIntegerCollection)value, cfgWriter);
                return;
            } else if (attributeDescription.isCfgType(CfgTypeMask.String)) {
                this.serializeStrList((CfgDescriptionAttributeReference)attributeDescription, (ConfStringCollection)value, cfgWriter);
                return;
            } else if (attributeDescription.isCfgType(CfgTypeMask.Link)) {
                this.serializeDBIdList((CfgDescriptionAttributeReference)attributeDescription, (ConfIntegerCollection)value, cfgWriter);
                return;
            } else {
                if (!attributeDescription.isCfgType(CfgTypeMask.KvList)) throw new CodecException("Type [" + attributeDescription.getTypeMaskString() + "] is not supported.");
                this.serializeKVList((CfgDescriptionAttributeReference)attributeDescription, (KeyValueCollection)value, cfgWriter);
            }
            return;
        } else if (attributeDescription.isCfgType(CfgTypeMask.Integer) || attributeDescription.isCfgType(CfgTypeMask.Link) || attributeDescription.isCfgType(CfgTypeMask.Enum)) {
            this.serializePrimitive(attributeDescription, '\u0019', value, cfgWriter);
            return;
        } else if (attributeDescription.isCfgType(CfgTypeMask.String)) {
            this.serializePrimitive(attributeDescription, '\u001b', value, cfgWriter);
            return;
        } else {
            if (!attributeDescription.isCfgType(CfgTypeMask.Class)) throw new CodecException("Type [" + attributeDescription.getTypeMaskString() + "] is not supported.");
            this.serializePObject((CfgDescriptionAttributeReference)attributeDescription, (ConfObjectBase)value, cfgWriter);
        }
    }

    private boolean serializeStrList(CfgDescriptionAttributeReference attr, ConfStringCollection value, StringWriter cfgWriter) throws CodecException {
        boolean attrExists = false;
        cfgWriter.write(23);
        if (value != null) {
            if (value.size() > 0) {
                cfgWriter.write(28);
                for (String str : value) {
                    this.serializePrimitive(attr, '\u001b', str, cfgWriter);
                }
            }
            attrExists = true;
        }
        cfgWriter.write(24);
        return attrExists;
    }

    protected void serializePrimitive(CfgDescriptionAttribute attr, char delimiter, Object value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(23);
        if (value != null) {
            cfgWriter.write(delimiter);
            if (delimiter == '\u001b') {
                if ("password".equals(attr.getName())) {
                    cfgWriter.write(this.getEncrypted((String)value));
                } else {
                    cfgWriter.write((String)value);
                }
            } else if (delimiter == '\u0019') {
                cfgWriter.write(((Integer)value).toString());
            }
        } else if (delimiter != '\u001b') {
            cfgWriter.write(delimiter);
        }
        cfgWriter.write(24);
    }

    protected void serializeIntList(CfgDescriptionAttributeReference attr, ConfIntegerCollection value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(23);
        if (value != null) {
            cfgWriter.write(28);
            for (Integer val : value) {
                this.serializePrimitive(attr, '\u0019', val, cfgWriter);
            }
        }
        cfgWriter.write(24);
    }

    protected void serializeDBIdList(CfgDescriptionAttributeReference attr, ConfIntegerCollection value, StringWriter cfgWriter) throws CodecException {
        this.serializeIntList(attr, value, cfgWriter);
    }

    protected void serializeObjList(CfgDescriptionAttributeReference attr, ConfStructureCollection value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(23);
        if (value != null && value.size() > 0) {
            cfgWriter.write(28);
            for (ConfStructure val : value) {
                this.serializePObject(attr, val, cfgWriter);
            }
        }
        cfgWriter.write(24);
    }

    protected void serializePObject(CfgDescriptionAttributeReference attr, ConfObjectBase value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(23);
        CfgDescriptionClass classDescription = attr.getCfgClass();
        if (value != null) {
            cfgWriter.write(31);
            for (CfgDescriptionAttribute attribute : classDescription.getAttributes()) {
                this.writeCfgString(attribute, value.getPropertyValue(attribute.getSchemaName()), cfgWriter);
            }
        }
        cfgWriter.write(24);
    }

    protected void serializeKVList(CfgDescriptionAttributeReference attr, KeyValueCollection value, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(23);
        if (value != null) {
            cfgWriter.write(29);
            if (!value.isEmpty()) {
                for (Object oPair : value) {
                    KeyValuePair pair = (KeyValuePair)oPair;
                    if (pair.getValueType() == ValueType.TKV_LIST) {
                        this.serializeKVListPair(attr, pair, cfgWriter);
                        continue;
                    }
                    this.serializeKVPair(attr, pair, cfgWriter);
                }
            }
        }
        cfgWriter.write(24);
    }
}

