/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.io.Serializable;
import java.text.MessageFormat;

public final class Serializer
implements Serializable {
    private static final long serialVersionUID = -8917391235582759496L;
    private String type;
    private int mode;
    private String str1;
    private String str2;
    private int[] messages = new int[0];
    private int[] objectMessages;
    private int[] objects;

    Serializer(int[] messages, int[] objectMessages, int[] objects, String type, int mode, String str1, String str2) {
        this.messages = messages;
        this.objectMessages = objectMessages;
        this.objects = objects;
        this.type = type;
        this.mode = mode;
        this.str1 = str1;
        this.str2 = str2;
    }

    public void serialize1(Message message) throws ProtocolException {
        if (this.mode < 0) {
            return;
        }
        int id = message.messageId();
        for (int i = 0; i < this.messages.length; ++i) {
            int messageId = this.messages[i];
            if (messageId != id) continue;
            for (int j = 0; j < this.objectMessages.length; ++j) {
                int objectMessageId = this.objectMessages[j];
                if (id != objectMessageId) continue;
                this.serialize2(message);
                return;
            }
            return;
        }
        throw new ProtocolException(MessageFormat.format(this.serialize3(this.str1), message.messageName(), new Integer(id)));
    }

    private void serialize2(Message message) throws ProtocolException {
        if (this.type == null) {
            return;
        }
        String decType = this.serialize3(this.type);
        Object objectTypeValue = message.getMessageAttribute(decType);
        for (int i = 0; i < this.objects.length; ++i) {
            int object = this.objects[i];
            if (!objectTypeValue.equals(new Integer(object))) continue;
            return;
        }
        CfgObjectType objType = (CfgObjectType)GEnum.getValue(CfgObjectType.class, (Integer)((Integer)objectTypeValue));
        throw new ProtocolException(MessageFormat.format(this.serialize3(this.str2), new Object[]{decType, objType}));
    }

    public String serialize3(String str) {
        StringBuffer buf = new StringBuffer(str);
        for (int i = 0; i < str.length(); ++i) {
            char ch = buf.charAt(i);
            buf.setCharAt(i, (char)((short)ch ^ this.mode));
        }
        return buf.toString();
    }
}

