/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomPackager;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectsCollection;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ConfSerializer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;

public abstract class ConfObjectPack
implements CustomPackager {
    protected static final int CONF_OBJ_ATTR_ID = 9;
    protected static final int OBJ_TYPE_ATTR_ID = 10;
    protected static final String CONF_OBJ_ATTR_NAME = "ConfObject";
    protected static final String OBJECT_TYPE_ATTR_NAME = "ObjectType";
    protected static final String CONF_OBJECT_ATTR_NAME = "Object";
    protected static final String CONF_OBJECTS_ATTR_NAME = "Objects";
    protected static final String CONF_OBJECT_DELTA_ATTR_NAME = "ObjectDelta";
    protected static final String CONF_BRIEF_OBJECT_ATTR_NAME = "BriefObject";
    protected static final int DELTA_INDEX = 3;
    protected static final String CFG_DELTA = "CfgDelta";
    protected static final String BRIEF = "Brief";
    protected Message message = null;
    protected Integer confObjectsType = null;
    protected String confObjectsData = null;
    protected ConfSerializer serializer = null;

    public void setMessage(Message message) {
        this.message = message;
    }

    public void onMessageStart(Message message) {
        this.setMessage(message);
    }

    public void onAttribute(String id, Object value) throws CodecException {
        switch (this.asInt(id)) {
            case 10: {
                this.confObjectsType = (Integer)value;
                break;
            }
            case 9: {
                this.confObjectsData = (String)value;
            }
        }
    }

    protected CfgDescriptionObject getObjectDescription() throws CodecException {
        CfgDescriptionObject ret = this.getObjectDescription(this.confObjectsType);
        if (ret == null) {
            throw new CodecException("No object type parameter specified");
        }
        return ret;
    }

    protected CfgDescriptionObject getObjectDescription(Integer typeId) throws CodecException {
        if (typeId == null) {
            return null;
        }
        CfgDescriptionObject objectType = this.serializer.getMetadata().getClassById(typeId);
        if (objectType == null) {
            throw new CodecException("Object Type [" + typeId + "] does not exist in current schema");
        }
        return this.getObjectDescription(objectType);
    }

    protected CfgDescriptionObject getObjectDescription(CfgDescriptionObject objType) throws CodecException {
        return objType;
    }

    protected void ensureOutgoingObjectTypeAttr(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        Integer objType = (Integer)this.message.getMessageAttribute(OBJECT_TYPE_ATTR_NAME);
        CfgDescriptionObject descr = null;
        if (customTypeObject instanceof ConfObject) {
            descr = ((ConfObject)customTypeObject).getClassInfo();
        } else if (customTypeObject instanceof ConfObjectsCollection) {
            descr = ((ConfObjectsCollection)customTypeObject).getClassInfo();
        }
        if (descr != null) {
            if (objType == null) {
                transport.onAttribute(transportState, Integer.toString(10), descr.getCfgEnum().ordinal());
            } else if (descr.getCfgEnum().ordinal() != objType.intValue()) {
                throw new CodecException("ObjectType in the message is different than actual object(s) type");
            }
        }
    }

    public String getLogType() {
        return "bstr";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hideAllowed) throws CodecException {
        if (customTypeObject instanceof ConfObjectsCollection) {
            buf.append(((ConfObjectsCollection)customTypeObject).toString(truncate, hideAllowed));
        } else if (customTypeObject instanceof ConfObject) {
            buf.append(((ConfObject)customTypeObject).toString(truncate, hideAllowed));
        } else if (customTypeObject != null) {
            buf.append(customTypeObject.toString());
        } else {
            buf.append("NULL");
        }
    }

    public String getNS() {
        return null;
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        return null;
    }

    protected int asInt(String id) throws CodecException {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            throw new CodecException("ConfObject packager needs int attribute id", (Throwable)e);
        }
    }
}

