/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.codec;

import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ObjectSerializer;
import com.genesyslab.platform.configuration.protocol.utilities.CfgUtilities;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XmlDocumentCodec
implements CustomTypeCodec {
    protected static final int CONF_OBJ_ATTR_ID = 9;
    protected static final int OBJ_TYPE_ATTR_ID = 10;
    protected static final int SCHEMA_INFO_ATTR_ID = 27;
    protected static final int DELTA_INDEX = 3;
    protected static final String DELTA = "Delta";
    protected static final String BRIEF = "Brief";
    protected static final String XML = "xml";
    protected static final String CONF_ID = "CfgID";
    protected static final String CONF_ACL = "CfgACL";
    protected static final String CONF_LOCALE = "cfglib_schema";
    protected Integer objectType;
    protected String confObject;
    protected Message message;
    protected ObjectSerializer serializer;

    public String getLogType() {
        return "str";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) throws CodecException {
        if (customTypeObject != null) {
            DOMSource source = new DOMSource(this.asDocument(customTypeObject));
            if (truncate) {
                buf.append(CodecUtil.toTruncatedString((Source)source, (int)400));
            } else {
                buf.append(CodecUtil.toString((Source)source));
            }
        } else {
            buf.append("NULL");
        }
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        if (attributeElement instanceof DOMResult) {
            Document doc;
            Element confData;
            Node confObject = ((DOMResult)attributeElement).getNode();
            if (confObject != null && (confData = (doc = this.asDocument(customTypeObject)).getDocumentElement()) != null) {
                Node imported = confObject.getOwnerDocument().importNode(confData, true);
                confObject.appendChild(imported);
            }
        } else {
            Document doc = this.asDocument(customTypeObject);
            if (doc != null) {
                DOMSource source = new DOMSource(doc);
                CodecUtil.transform((Source)source, (Result)attributeElement);
            }
        }
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        Document document = CodecUtil.createDocument();
        if (attributeElement instanceof DOMSource) {
            Element confData;
            DOMSource source = (DOMSource)attributeElement;
            Node confObject = source.getNode();
            if (confObject != null && (confData = CfgUtilities.getFirstChildElement(confObject)) != null) {
                this.checkNoSiblings(confData);
                Node imported = document.importNode(confData, true);
                document.appendChild(imported);
            }
        } else {
            Element confData;
            DOMResult result = new DOMResult(document);
            CodecUtil.transform((Source)attributeElement, (Result)result);
            Element rootNode = document.getDocumentElement();
            if (rootNode != null && (confData = CfgUtilities.getFirstChildElement(rootNode)) != null) {
                this.checkNoSiblings(confData);
                document.replaceChild(confData, rootNode);
            }
        }
        return document;
    }

    private void checkNoSiblings(Element el) throws CodecException {
        if (CfgUtilities.getNextSiblingElement(el) != null) {
            throw new CodecException("XmlDocument type attribute contains more than one child element");
        }
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    protected int asInt(String id) throws CodecException {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            throw new CodecException("XmlDocumentCodec supports int attribute id only", (Throwable)e);
        }
    }

    protected Document asDocument(Object customTypeObject) throws CodecException {
        if (customTypeObject instanceof Document) {
            return (Document)customTypeObject;
        }
        if (customTypeObject == null) {
            return null;
        }
        throw new CodecException("Wrong object, org.w3c.Document expected");
    }
}

