/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomPackager;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventBriefInfo;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ObjectSerializerV6;
import com.genesyslab.platform.configuration.protocol.runtime.codec.XmlDocumentCodec;
import org.w3c.dom.Document;

public class XmlDocumentCodecV6
extends XmlDocumentCodec
implements CustomPackager {
    private static final ILogger log = Log.getLogger(XmlDocumentCodecV6.class);

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        String typeName;
        switch (this.message.messageId()) {
            case 24: 
            case 30: 
            case 32: 
            case 47: {
                typeName = "CfgID";
                break;
            }
            case 26: {
                typeName = "CfgACL";
                break;
            }
            default: {
                throw new PlatformException("Unexpected message");
            }
        }
        String cfgStr = this.serializer.deserialize(typeName, (Document)customTypeObject);
        return transport.onAttribute(transportState, id, cfgStr);
    }

    public String getNS() {
        return null;
    }

    public void setProtocolData(Object protocolData) {
        if (protocolData instanceof ObjectSerializerStorageV6) {
            this.serializer = ((ObjectSerializerStorageV6)protocolData).getSerializerV6();
        }
        if (this.serializer == null) {
            log.warn((Object)"Failed to get ObjectSerializer from protocol data");
        }
    }

    public void onMessageStart(Message message) {
        this.setMessage(message);
    }

    public void onAttribute(String id, Object value) throws CodecException {
        AttributeDescription attrDescr;
        int attrId = this.asInt(id);
        if (attrId == 10) {
            this.objectType = (Integer)value;
            return;
        }
        if (attrId == 9) {
            this.confObject = (String)value;
        }
        if ((attrDescr = ((DataSupport)this.message).getMetaData().getAttributeDescription((Object)id)) == null || !Document.class.isAssignableFrom(attrDescr.getValueType())) {
            return;
        }
        switch (this.message.messageId()) {
            case 25: 
            case 27: {
                ((DataSupport)this.message).attributes().put(attrDescr.getName(), this.serializer.serialize("CfgACL", (String)value));
                break;
            }
            case 31: 
            case 33: 
            case 66: {
                ((DataSupport)this.message).attributes().put(attrDescr.getName(), this.serializer.serialize("CfgID", (String)value));
                break;
            }
            case 44: 
            case 59: {
                ((DataSupport)this.message).attributes().put(attrDescr.getName(), this.serializer.serialize("cfglib_schema", (String)value));
            }
        }
    }

    public void onMessageEnd() throws CodecException {
        if (this.confObject != null && this.message.messageId() == 29) {
            CfgDescriptionObject objectTypeDescr = this.serializer.getMetadata().getClassById(this.objectType);
            if (objectTypeDescr == null) {
                throw new IllegalArgumentException("Object Type [" + this.objectType + "] does not exist in current schema");
            }
            String objectTypeName = objectTypeDescr.getName() + "Brief";
            if (log.isDebug()) {
                log.debug((Object)("Decoding type '" + objectTypeName));
            }
            Document doc = this.serializer.serialize(objectTypeName, this.confObject);
            ((EventBriefInfo)this.message).setBriefInfo(doc);
        }
    }

    public static interface ObjectSerializerStorageV6 {
        public ObjectSerializerV6 getSerializerV6();
    }
}

