/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.configuration;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.connection.configuration.AbstractConnectionConfiguration;
import java.util.Iterator;

public class KeyValueConfiguration
extends AbstractConnectionConfiguration {
    private KeyValueCollection list;

    public KeyValueConfiguration(KeyValueCollection kvList) {
        if (kvList == null) {
            throw new NullPointerException("kvList");
        }
        this.list = new KeyValueCollection();
        Iterator iterator = kvList.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object objPair = iterator.next();
                if (!(objPair instanceof KeyValuePair)) continue;
                KeyValuePair pair = (KeyValuePair)objPair;
                if (this.list.containsKey((Object)pair.getStringKey())) {
                    throw new IllegalArgumentException("Incoming KeyValueCollection should contain only unique keys");
                }
                this.list.addObject(pair.getStringKey(), pair.getValue());
            }
        }
    }

    public String getOption(String name, String defaultValue) {
        KeyValuePair pair = this.list.getPair(name);
        if (pair == null) {
            return defaultValue;
        }
        Object val = pair.getValue();
        if (val == null) {
            return defaultValue;
        }
        return val.toString();
    }

    public Integer getInteger(String name, Integer defaultValue) {
        Integer val = this.list.getInt(name);
        if (val == null) {
            val = super.getInteger(name, defaultValue);
        }
        return val;
    }

    public void setOption(String name, String value) {
        KeyValuePair pair = this.findOption(name);
        if (pair != null) {
            if (value != null) {
                pair.setStringValue(value);
            } else {
                this.list.remove(name);
            }
        } else if (value != null) {
            this.list.addString(name, value);
        }
    }

    public void setInteger(String name, Integer value) {
        KeyValuePair pair = this.findOption(name);
        if (pair != null) {
            if (value != null) {
                pair.setIntValue(value);
            } else {
                this.list.remove(name);
            }
        } else if (value != null) {
            this.list.addInt(name, value);
        }
    }

    protected KeyValuePair findOption(String name) {
        Iterator iterator = this.list.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                KeyValuePair pair;
                Object objPair = iterator.next();
                if (!(objPair instanceof KeyValuePair) || !(pair = (KeyValuePair)objPair).getStringKey().equals(name)) continue;
                return pair;
            }
        }
        return null;
    }

    public KeyValueConfiguration clone() {
        return new KeyValueConfiguration(this.list);
    }

    public String toString() {
        return this.list.toStringLine();
    }
}

