/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.impl.tls.DefaultSSLContextCreator;
import com.genesyslab.platform.commons.connection.tls.KeyManagerHelper;
import com.genesyslab.platform.commons.connection.tls.SSLContextHelper;
import com.genesyslab.platform.commons.connection.tls.SSLExtendedOptions;
import com.genesyslab.platform.commons.connection.tls.TrustManagerHelper;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextUtil {
    public static final String PSDK_DEFAULT_ENCODING_KEY = "com.genesyslab.platform.defaultcharset";
    private static final ILogger log = Log.getLogger(ContextUtil.class);
    private static final String COMPATIBILITY_MODE_BANNER = "\n***\nTLS IS WORKING IN 8.1.0 COMPATIBILITY MODE. THIS MODE PROVIDES ONLY CHANNEL ENCRYPTION; NO TLS AUTHENTICATION OR CERTIFICATE VALIDATION WILL BE PERFORMED.\n***";

    public static <V> V getTypedAttribute(ConnectionContext ctx, String key, Class<V> clazz) {
        try {
            return (V)ctx.getAttribute(key);
        }
        catch (ClassCastException e) {
            Log.getLogger(ConnectionContext.class).warnFormat("Unexpected class of value under key ''{0}''", (Object)key);
            return null;
        }
    }

    @Deprecated
    public static SSLContext sslContext(ConnectionContext context, boolean isServer) {
        SSLContext attr = ContextUtil.getTypedAttribute(context, "com.genesyslab.platform.commons.connection.SSLContext", SSLContext.class);
        if (attr == null) {
            attr = ContextUtil.createSslFromConfig(context, isServer);
        }
        return attr;
    }

    public static SSLEngine sslEngine(ConnectionContext context, String remoteHost, int remotePort, boolean clientMode) {
        SSLContext sslContext = ContextUtil.getTypedAttribute(context, "com.genesyslab.platform.commons.connection.SSLContext", SSLContext.class);
        if (null == sslContext) {
            log.warn((Object)"TLS is being used without configured SSLContext instance, will use TLS compatibility mode.");
            sslContext = ContextUtil.createCompatibilityModeContext(context, clientMode);
            context.setAttribute("com.genesyslab.platform.commons.connection.SSLContext", sslContext);
        }
        if (null == sslContext) {
            throw new PsdkConnectionException("SSLContext instance could not be found in connection context");
        }
        SSLEngine sslEngine = sslContext.createSSLEngine(remoteHost, remotePort);
        sslEngine.setUseClientMode(clientMode);
        TreeSet<String> engineCiphers = null;
        SSLExtendedOptions options = ContextUtil.getTypedAttribute(context, "com.genesyslab.platform.commons.connection.SSLExtendedOptions", SSLExtendedOptions.class);
        if (null != options) {
            if (!clientMode) {
                sslEngine.setNeedClientAuth(options.isMutualTLS());
            }
            if (null != options.getEnabledCipherSuites()) {
                engineCiphers = new TreeSet();
                engineCiphers.addAll(Arrays.asList(sslEngine.getSupportedCipherSuites()));
                log.debugFormat("SSLEngine supported ciphers: {0}", (Object)ContextUtil.stringSetToString(engineCiphers, " "));
                TreeSet<String> requestedCiphers = new TreeSet<String>();
                requestedCiphers.addAll(Arrays.asList(options.getEnabledCipherSuites()));
                log.debugFormat("Ciphers configured in cipher-list: {0}", (Object)ContextUtil.stringSetToString(requestedCiphers, " "));
                engineCiphers.retainAll(requestedCiphers);
                String[] enabledCiphers = engineCiphers.toArray(new String[engineCiphers.size()]);
                sslEngine.setEnabledCipherSuites(enabledCiphers);
            }
        }
        if (null == engineCiphers) {
            engineCiphers = new TreeSet<String>();
            engineCiphers.addAll(Arrays.asList(sslEngine.getEnabledCipherSuites()));
        }
        Log.getLogger(ContextUtil.class).debugFormat("Enabled SSLEngine cipher suites: {0}", (Object)ContextUtil.stringSetToString(engineCiphers, " "));
        return sslEngine;
    }

    private static SSLContext createCompatibilityModeContext(ConnectionContext context, boolean clientMode) {
        boolean keyStorePresent;
        ConnectionConfiguration conf = context.configuration();
        String path = null;
        String pass = null;
        if (null != conf) {
            path = conf.getOption("tls.keystorePath");
            pass = conf.getOption("tls.keystorePass");
        }
        boolean bl = keyStorePresent = null != path && null != pass;
        if (!clientMode && !keyStorePresent) {
            log.error((Object)"Compatibility mode TLS configuration for server side requires that parameters \"tls.keystorePath\" and \"tls.keystorePass\" are specified.");
            return null;
        }
        X509ExtendedKeyManager keyManager = null;
        if (keyStorePresent) {
            try {
                keyManager = KeyManagerHelper.createJKSKeyManager(path, pass.toCharArray(), pass.toCharArray());
            }
            catch (IOException e) {
                log.error((Object)("Could not create key manager (Current working folder is \"" + System.getProperty("user.dir") + "\")."), (Throwable)e);
            }
            catch (GeneralSecurityException e) {
                log.error((Object)"Could not create key manager.", (Throwable)e);
            }
        } else {
            keyManager = KeyManagerHelper.createEmptyKeyManager();
        }
        if (!clientMode && null == keyManager) {
            log.error((Object)"SSLContext for server side cannot be created without key manager.");
            return null;
        }
        SSLContext sslContext = null;
        try {
            sslContext = SSLContextHelper.createSSLContext(keyManager, TrustManagerHelper.createTrustEveryoneTrustManager());
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"Could not create SSLContext.", (Throwable)e);
        }
        if (null != sslContext) {
            log.warn((Object)COMPATIBILITY_MODE_BANNER);
        }
        return sslContext;
    }

    @Deprecated
    private static SSLContext createSslFromConfig(ConnectionContext context, boolean isServer) {
        SSLContext ctx;
        block6: {
            ctx = null;
            ConnectionConfiguration conf = context.configuration();
            if (conf != null && conf.getBoolean("tls")) {
                try {
                    if (!isServer) {
                        ctx = DefaultSSLContextCreator.createDefaultClientContext();
                        break block6;
                    }
                    String path = conf.getOption("tls.keystorePath");
                    String pass = conf.getOption("tls.keystorePass");
                    if (path != null && pass != null) {
                        ctx = DefaultSSLContextCreator.createDefaultServerSSLContext(path, pass.toCharArray());
                        break block6;
                    }
                    log.warn((Object)"Server side default tls configuration requires path and password to keystore");
                    throw new PsdkConnectionException("Not enough configuration info for TLS");
                }
                catch (GeneralSecurityException e) {
                    Log.getLogger(ContextUtil.class).warn((Object)"Problems creating default SSLContext", (Throwable)e);
                }
            }
        }
        if (null != ctx) {
            log.warn((Object)COMPATIBILITY_MODE_BANNER);
        }
        return ctx;
    }

    public static String stringSetToString(Set<String> cipherSet, String separator) {
        if (null == separator) {
            throw new IllegalArgumentException("separator must not be null");
        }
        if (null == cipherSet || cipherSet.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : cipherSet) {
            sb.append(s);
            sb.append(separator);
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - separator.length());
        }
        return sb.toString();
    }

    static String getDefaultCharsetName() {
        return ContextUtil.getDefaultCharset().name();
    }

    private static Charset getDefaultCharset() {
        Charset ret = null;
        String name = System.getProperty(PSDK_DEFAULT_ENCODING_KEY);
        if (name != null && !name.equals("")) {
            try {
                ret = Charset.forName(name);
            }
            catch (Exception ex) {
                log.warn((Object)("Exception initializing charset '" + name + "'"), (Throwable)ex);
            }
        }
        if (ret != null) {
            return ret;
        }
        return Charset.defaultCharset();
    }
}

