/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.collections.KVList;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.TKVSerializer;
import com.genesyslab.platform.commons.connection.impl.Constants;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class PackedMessage {
    private final ILogger log = Log.getLogger(PackedMessage.class);
    private static final int INITIAL_LEN = 2048;
    private int bufferLen = 2048;
    protected static final int MAX_STRING_LEN = 65535;
    private static final int MAX_BINARY_LEN = Integer.MAX_VALUE;
    private byte[] buf = new byte[2048];
    private int len = 5;
    private int numAttr;
    private String stringAttributesEncoding;

    public PackedMessage(int msg_id, String stringAttributesEncoding) {
        this.stringAttributesEncoding = stringAttributesEncoding;
        this.addInt(msg_id);
    }

    public PackedMessage(String stringAttributesEncoding) {
        this.stringAttributesEncoding = stringAttributesEncoding;
        this.len += 4;
    }

    public void setMessageId(int msgId) {
        int curLen = this.len;
        this.len = 5;
        this.addInt(msgId);
        this.len = curLen;
    }

    public void addIntAttrib(int attr_id, int attr_val) {
        this.addInt(attr_id);
        this.addTypeHeader('i');
        this.addInt(attr_val);
        ++this.numAttr;
    }

    public void addLongAttrib(int attr_id, long attr_val) {
        this.addInt(attr_id);
        this.addTypeHeader('l');
        this.addLong(attr_val);
        ++this.numAttr;
    }

    public void addStringAttrib(int attr_id, String attr_val) {
        byte[] strBytes;
        if (attr_val == null) {
            return;
        }
        this.addInt(attr_id);
        try {
            strBytes = attr_val.getBytes(this.stringAttributesEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        int alen = strBytes.length;
        if (alen > 65535) {
            this.addTypeHeader('S');
            this.addInt(alen);
        } else {
            this.addTypeHeader('s');
            this.addUnsignedShort(alen);
        }
        this.ensureBuffer(this.len + alen);
        System.arraycopy(strBytes, 0, this.buf, this.len, alen);
        this.len += alen;
        ++this.numAttr;
    }

    public void addBStringAttrib(int attr_id, byte[] bb) {
        if (bb == null) {
            return;
        }
        int alen = bb.length;
        if (alen > 65533) {
            alen = 65533;
        }
        this.addInt(attr_id);
        this.addTypeHeader('b');
        this.addUnsignedShort(alen + 2);
        this.ensureBuffer(this.len + alen);
        System.arraycopy(bb, 0, this.buf, this.len, alen);
        this.len += alen;
        ++this.numAttr;
    }

    public void addBinaryAttrib(int attr_id, byte[] bb) {
        if (bb == null) {
            return;
        }
        int alen = bb.length;
        if (alen > Integer.MAX_VALUE) {
            alen = Integer.MAX_VALUE;
        }
        this.addInt(attr_id);
        this.addTypeHeader('B');
        this.addInt(alen);
        this.ensureBuffer(this.len + alen);
        System.arraycopy(bb, 0, this.buf, this.len, alen);
        this.len += alen;
        ++this.numAttr;
    }

    public void addKeyValueCollectionAttrib(int attr_id, KeyValueCollection attr_val) {
        byte[] b;
        if (attr_val == null) {
            return;
        }
        try {
            b = TKVSerializer.getBytes((KVList)attr_val, (String)this.stringAttributesEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        int alen = b.length;
        if (alen > 65535) {
            this.addBinaryAttrib(attr_id, b);
        } else {
            this.addBStringAttrib(attr_id, b);
        }
    }

    public int getNumAttr() {
        return this.numAttr;
    }

    public void writeTo(WritePoint endpoint) throws IOException {
        if (this.len < 0) {
            return;
        }
        this.buf[4] = (byte)this.numAttr;
        if (this.len <= 16384) {
            PackedMessage.setLength(this.buf, 0, this.len - 4);
            endpoint.write(this.buf, 0, this.len);
            return;
        }
        this.writeExtHeader(endpoint);
        int donelen = this.len - 4;
        int offset = 4;
        while (donelen > 0) {
            int scraplen = donelen > 16380 ? 16380 : donelen;
            byte[] lengthData = new byte[4];
            PackedMessage.setLength(lengthData, 0, scraplen);
            endpoint.write(lengthData, 0, 4);
            endpoint.write(this.buf, offset, scraplen);
            donelen -= scraplen;
            offset += scraplen;
        }
    }

    private void addTypeHeader(char header) {
        int pos = this.len++;
        this.ensureBuffer(this.len);
        this.buf[pos] = (byte)header;
    }

    private void ensureBuffer(int size) {
        if (size < this.bufferLen) {
            return;
        }
        byte[] old = this.buf;
        int oldLen = this.bufferLen;
        do {
            this.bufferLen <<= 1;
        } while (this.bufferLen <= size);
        this.buf = new byte[this.bufferLen];
        System.arraycopy(old, 0, this.buf, 0, oldLen);
    }

    private void addUnsignedShort(int x) {
        this.ensureBuffer(this.len + 2);
        this.buf[this.len++] = (byte)(x >>> 8);
        this.buf[this.len++] = (byte)x;
    }

    private void addInt(int x) {
        this.ensureBuffer(this.len + 4);
        this.buf[this.len++] = (byte)(x >>> 24);
        this.buf[this.len++] = (byte)(x >>> 16);
        this.buf[this.len++] = (byte)(x >>> 8);
        this.buf[this.len++] = (byte)x;
    }

    private void addLong(long x) {
        this.ensureBuffer(this.len + 8);
        this.buf[this.len++] = (byte)(x >>> 56);
        this.buf[this.len++] = (byte)(x >>> 48);
        this.buf[this.len++] = (byte)(x >>> 40);
        this.buf[this.len++] = (byte)(x >>> 32);
        this.buf[this.len++] = (byte)(x >>> 24);
        this.buf[this.len++] = (byte)(x >>> 16);
        this.buf[this.len++] = (byte)(x >>> 8);
        this.buf[this.len++] = (byte)x;
    }

    private static void setLength(byte[] buffer, int offset, int length) {
        buffer[offset] = (byte)(length >>> 24);
        buffer[offset + 1] = (byte)(length >>> 16);
        buffer[offset + 2] = (byte)(length >>> 8);
        buffer[offset + 3] = (byte)length;
    }

    private void writeExtHeader(WritePoint endpoint) throws IOException {
        byte[] extHeader = new byte[Constants.EXTENDED_PACKET_TAG_LENGTH + 8];
        System.arraycopy("$PACKET EXTENSION V1.00$".getBytes(), 0, extHeader, 4, Constants.EXTENDED_PACKET_TAG_LENGTH);
        PackedMessage.setLength(extHeader, Constants.EXTENDED_PACKET_TAG_LENGTH + 4, this.len - 4);
        PackedMessage.setLength(extHeader, 0, Constants.EXTENDED_PACKET_TAG_LENGTH + 4);
        if (this.log.isDebug()) {
            this.log.debug((Object)("Writing extended header. Data len: " + (this.len - 4)));
        }
        endpoint.write(extHeader, 0, extHeader.length);
    }
}

