/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.mina;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionException;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.AbstractConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.mina.MinaManager;
import com.genesyslab.platform.commons.connection.impl.mina.MinaUtil;
import com.genesyslab.platform.commons.connection.impl.mina.MinaWritePipeImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.util.SessionLog;

public class MinaConnectionImpl
extends AbstractConnectionImpl
implements Connection,
ConnectionImpl {
    public static final String LOGGING_FILTER_ENABLED = "com.GPCC.impl.mina.logFilter";
    private static final String CLOSE_REASON = "com.GPCC.impl.mina.CloseReason";
    private static final String CONN_IMPL = "com.GPCC.impl.mina.ConnectionImpl";
    private static final Handler handler = new Handler();
    private final ILogger log = Log.getLogger(MinaConnectionImpl.class);
    private final MinaWritePipeImpl writePipe = new MinaWritePipeImpl(this);
    private IoSession session;

    public void open() {
        ConnectFuture future;
        super.open();
        this.log.debugFormat("Opening Mina connection {0}", (Object)this);
        this.setConnectionState(ConnectionState.OPENING);
        SocketConnectorConfig connectorConfig = new SocketConnectorConfig();
        int connectionTimeout = this.getConfigTimeout("connection-timeout", -1);
        if (connectionTimeout > 0) {
            connectorConfig.setConnectTimeout(connectionTimeout);
        }
        SocketSessionConfig sessionConfig = (SocketSessionConfig)connectorConfig.getSessionConfig();
        if (null != this.config) {
            Boolean keepAlive;
            Boolean reuseAddress = this.config.getBoolean("reuse-address");
            if (null != reuseAddress) {
                sessionConfig.setReuseAddress(reuseAddress.booleanValue());
            }
            if (null != (keepAlive = Boolean.valueOf(this.config.getBoolean("keep-alive")))) {
                sessionConfig.setKeepAlive(keepAlive.booleanValue());
            }
        }
        MinaUtil.configureSSL((IoServiceConfig)connectorConfig, this.context(), false);
        IoConnector connector = MinaManager.connector();
        InetSocketAddress localAddress = this.getConfigLocalEndpoint();
        try {
            future = null != localAddress ? connector.connect(this.address, (SocketAddress)localAddress, (IoHandler)handler, (IoServiceConfig)connectorConfig) : connector.connect(this.address, (IoHandler)handler, (IoServiceConfig)connectorConfig);
        }
        catch (Exception e) {
            this.doClose(e);
            return;
        }
        future.addListener(new IoFutureListener(){

            public void operationComplete(IoFuture future) {
                IoSession session;
                try {
                    session = future.getSession();
                }
                catch (Exception e) {
                    MinaConnectionImpl.this.doClose(e);
                    return;
                }
                MinaConnectionImpl.this.log.debug((Object)"Connection is established");
                session.setAttribute(MinaConnectionImpl.CONN_IMPL, (Object)MinaConnectionImpl.this);
                MinaConnectionImpl.this.session = session;
                MinaConnectionImpl.this.setConnectionState(ConnectionState.OPENED);
                MinaConnectionImpl.this.notifyEstablishedHandler();
                MinaConnectionImpl.this.writePipe.writePendingData();
            }
        });
        this.log.debug((Object)"Connection sequence initiated");
    }

    public WritePipe getWritePipe() {
        return this.writePipe;
    }

    protected void attach(IoSession session) {
        session.setAttribute(CONN_IMPL, (Object)this);
        this.setConnectionState(ConnectionState.OPENING);
        if (this.log.isDebug()) {
            this.log.debugFormat("Attaching to io session : {0} on connection ''{1}''", (Object)new Object[]{session, this});
        }
        this.session = session;
        this.address = session.getRemoteAddress();
        if (this.address instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)this.address;
            this.host = socketAddress.getHostName();
            this.port = socketAddress.getPort();
        }
        this.setConnectionState(ConnectionState.OPENED);
    }

    protected void startClose(Throwable closeReason) {
        this.log.debugFormat("Closing Mina connection {0}", (Object)this);
        Object reason = closeReason;
        if (reason == null) {
            reason = new Object();
        }
        if (this.session != null) {
            this.session.setAttribute(CLOSE_REASON, reason);
            this.session.close();
        }
    }

    protected void doClose(Throwable closeReason) {
        super.doClose(closeReason);
        this.session = null;
        this.log.debugFormat("Closed Mina connection {0}", (Object)this);
    }

    protected IoSession getSession() {
        return this.session;
    }

    private static MinaConnectionImpl retrieveConnImpl(IoSession session) {
        Object attribute = session.getAttribute(CONN_IMPL);
        if (attribute == null) {
            throw new PsdkConnectionException("No connection in session, unexpected close?");
        }
        return (MinaConnectionImpl)attribute;
    }

    public InetSocketAddress getRemoteEndPoint() {
        SocketAddress sa = null;
        if (this.session != null) {
            sa = this.session.getRemoteAddress();
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    public InetSocketAddress getLocalEndPoint() {
        SocketAddress sa = null;
        if (this.session != null) {
            sa = this.session.getLocalAddress();
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    protected static class Handler
    implements IoHandler {
        private ILogger log = Log.getLogger(Handler.class);
        private final ILogger dataLog = Log.getLogger((String)"com.genesyslab.platform.internal.con.data");
        private final ILogger traceLog = Log.getLogger((String)"com.genesyslab.platform.internal.con.data.trace");

        protected Handler() {
        }

        public void sessionCreated(IoSession session) throws Exception {
            ConnectionConfiguration conf = null;
            ConnectionImpl impl = (ConnectionImpl)session.getAttribute(MinaConnectionImpl.CONN_IMPL);
            if (impl != null) {
                conf = impl.context().configuration();
            }
            if (conf == null || !conf.getBoolean(MinaConnectionImpl.LOGGING_FILTER_ENABLED)) {
                session.setAttribute(SessionLog.LOGGER, (Object)new MinaUtil.SilentLogger());
            }
        }

        public void sessionOpened(IoSession session) throws Exception {
        }

        public void sessionClosed(IoSession session) throws Exception {
            this.log.debugFormat("Session closed: {0}", (Object)session);
            Object closeReason = session.removeAttribute(MinaConnectionImpl.CLOSE_REASON);
            MinaConnectionImpl conn = MinaConnectionImpl.retrieveConnImpl(session);
            if (closeReason == null) {
                conn.doClose((Throwable)((Object)new ConnectionException("Connection is closed unexpectedly")));
            } else if (closeReason instanceof Throwable) {
                conn.doClose((Throwable)closeReason);
            } else {
                conn.doClose(null);
            }
        }

        public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            this.log.debugFormat("Session exception: {0} ! {1}", (Object)new Object[]{session, cause});
            MinaConnectionImpl connection = MinaConnectionImpl.retrieveConnImpl(session);
            connection.close(cause);
        }

        public void messageReceived(IoSession session, Object message) {
            if (message instanceof ByteBuffer) {
                ByteBuffer buf = (ByteBuffer)message;
                this.traceLog.debugFormat("Session {0} received {1} bytes: {2}", (Object)new Object[]{session, buf.remaining(), buf});
                int cnt = buf.remaining();
                byte[] bytes = new byte[cnt];
                buf.get(bytes, 0, cnt);
                try {
                    MinaConnectionImpl.retrieveConnImpl(session).getMessageTransport().processData(bytes, 0, cnt);
                }
                catch (InvalidPacketException e) {
                    String hexDump = MinaConnectionImpl.bytesToHexDump(bytes);
                    this.log.debug((Object)("Invalid packet encountered on \"" + this + "\": " + hexDump), (Throwable)((Object)e));
                }
            } else {
                throw new RuntimeException("Unsupported message type");
            }
        }

        public void messageSent(IoSession session, Object message) throws Exception {
            if (this.dataLog.isDebug()) {
                if (message instanceof ByteBuffer) {
                    this.dataLog.debugFormat("Session {0} Bytes written: {1}", (Object)new Object[]{session, ((ByteBuffer)message).remaining()});
                }
                this.traceLog.debugFormat("Bytes: {0}", message);
            }
        }
    }
}

