/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.netty;

import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.impl.ContextUtil;
import com.genesyslab.platform.commons.connection.impl.netty.NettyConnectionImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyUtil {
    private static volatile ChannelFactory defaultClientFactory;
    private static volatile int defaultClientFactoryUsers;
    private static volatile TimerActionTicket releaseDefaultClientFactoryTicket;
    private static ChannelFactory defaultServerFactory;
    private static int defaultServerFactoryUsers;
    private static final NettyTransportType transport;
    private static final int maxServerBossThreads;
    private static final int minServerBossThreads;
    private static final int maxServerWorkerThreads;
    private static final int minServerWorkerThreads;
    private static final ILogger log;

    private static int getIntOption(String optName, int defaultValue) {
        int ret = defaultValue;
        String strValue = System.getProperty(optName);
        if (strValue != null) {
            try {
                ret = Integer.parseInt(strValue);
            }
            catch (Exception ex) {
                log.errorFormat("Exception initializing '{0}' to '{1}': {2}", (Object)new Object[]{optName, strValue, ex});
            }
        }
        return ret;
    }

    public static ChannelFactory clientChannelFactory(ConnectionContext<?> ctx) {
        ChannelFactory factory = ContextUtil.getTypedAttribute(ctx, "com.genesyslab.platform.commons.connection.impl.netty.ChannelFactory", ChannelFactory.class);
        if (factory == null) {
            factory = NettyUtil.defaultClientChannelFactory();
        }
        return factory;
    }

    public static ChannelFactory serverChannelFactory(ConnectionContext<?> ctx) {
        ChannelFactory factory = ContextUtil.getTypedAttribute(ctx, "com.genesyslab.platform.commons.connection.impl.netty.ChannelFactory", ChannelFactory.class);
        if (factory == null) {
            factory = NettyUtil.defaultServerChannelFactory();
        }
        return factory;
    }

    private static Executor createBossExecutor(boolean isServerChannel) {
        int corePoolSize = 0;
        int maxPoolSize = Integer.MAX_VALUE;
        if (isServerChannel) {
            corePoolSize = minServerBossThreads;
            maxPoolSize = maxServerBossThreads;
        }
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    private static Executor createWorkerExecutor(boolean isServerChannel) {
        int corePoolSize = 0;
        int maxPoolSize = Integer.MAX_VALUE;
        if (isServerChannel) {
            corePoolSize = minServerWorkerThreads;
            maxPoolSize = maxServerWorkerThreads;
        }
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    private static synchronized ChannelFactory defaultClientChannelFactory() {
        if (defaultClientFactory == null) {
            Log.getLogger(NettyUtil.class).debug((Object)"Creating default client channel factory");
            switch (transport) {
                case OioTransport: {
                    defaultClientFactory = new OioClientSocketChannelFactory(NettyUtil.createWorkerExecutor(false));
                    break;
                }
                default: {
                    defaultClientFactory = new NioClientSocketChannelFactory(NettyUtil.createBossExecutor(false), NettyUtil.createWorkerExecutor(false));
                }
            }
            defaultClientFactoryUsers = 0;
        } else if (releaseDefaultClientFactoryTicket != null) {
            releaseDefaultClientFactoryTicket.cancel();
            releaseDefaultClientFactoryTicket = null;
            --defaultClientFactoryUsers;
        }
        if (defaultClientFactory != null) {
            ++defaultClientFactoryUsers;
        }
        return defaultClientFactory;
    }

    private static synchronized ChannelFactory defaultServerChannelFactory() {
        if (defaultServerFactory == null) {
            Log.getLogger(NettyUtil.class).debug((Object)"Creating default server channel factory");
            switch (transport) {
                case OioTransport: {
                    defaultServerFactory = new OioServerSocketChannelFactory(NettyUtil.createBossExecutor(true), NettyUtil.createWorkerExecutor(true));
                    break;
                }
                default: {
                    defaultServerFactory = new NioServerSocketChannelFactory(NettyUtil.createBossExecutor(true), NettyUtil.createWorkerExecutor(true));
                }
            }
        }
        ++defaultServerFactoryUsers;
        return defaultServerFactory;
    }

    static synchronized ChannelFactory useServerChannelFactory(ChannelFactory factory) {
        if (defaultServerFactory != null && factory == defaultServerFactory) {
            ++defaultServerFactoryUsers;
        }
        return factory;
    }

    public static synchronized void releaseClientChannelFactory(ChannelFactory factory) {
        if (factory != null && factory == defaultClientFactory) {
            if (defaultClientFactoryUsers > 1) {
                --defaultClientFactoryUsers;
            } else if (releaseDefaultClientFactoryTicket == null) {
                releaseDefaultClientFactoryTicket = TimerFactory.getTimer().schedule(500L, (TimerAction)new ReleaseDefaultClientFactoryTask());
            }
        }
    }

    private static synchronized void doReleaseDefaultClientChannelFactory() {
        if (releaseDefaultClientFactoryTicket != null) {
            releaseDefaultClientFactoryTicket.cancel();
            releaseDefaultClientFactoryTicket = null;
            if (--defaultClientFactoryUsers <= 0) {
                Log.getLogger(NettyUtil.class).debug((Object)"Shutting default client channel factory down");
                defaultClientFactory.releaseExternalResources();
                defaultClientFactory = null;
                defaultClientFactoryUsers = 0;
            }
        }
    }

    public static synchronized void releaseServerChannelFactory(ChannelFactory factory) {
        if (factory != null && factory == defaultServerFactory && --defaultServerFactoryUsers <= 0) {
            final ChannelFactory releasedFactory = defaultServerFactory;
            defaultServerFactory = null;
            defaultServerFactoryUsers = 0;
            Log.getLogger(NettyUtil.class).debug((Object)"Shutting default server channel factory down");
            Thread terminator = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                    }
                    releasedFactory.releaseExternalResources();
                }
            });
            terminator.setName("NettyServerTerminator");
            terminator.setDaemon(true);
            terminator.start();
        }
    }

    static {
        defaultClientFactoryUsers = 0;
        releaseDefaultClientFactoryTicket = null;
        defaultServerFactoryUsers = 0;
        log = Log.getLogger(NettyConnectionImpl.class);
        String sType = System.getProperty("com.genesyslab.platform.commons.connection.impl.netty.transport");
        if ("OIO".equalsIgnoreCase(sType)) {
            transport = NettyTransportType.OioTransport;
        } else if ("NIO".equalsIgnoreCase(sType)) {
            transport = NettyTransportType.NioTransport;
        } else {
            if (sType != null && !sType.equals("")) {
                log.warnFormat("Invalid Netty transport type specified (''{0}''). Possible values are ''nio'' or ''oio''.", (Object)sType);
            }
            transport = NettyTransportType.NioTransport;
        }
        log.infoFormat("Using Netty with ''{0}''.", (Object)transport);
        minServerBossThreads = NettyUtil.getIntOption("com.genesyslab.platform.commons.connection.impl.netty.min-boss-threads", 0);
        maxServerBossThreads = NettyUtil.getIntOption("com.genesyslab.platform.commons.connection.impl.netty.max-boss-threads", Integer.MAX_VALUE);
        minServerWorkerThreads = NettyUtil.getIntOption("com.genesyslab.platform.commons.connection.impl.netty.min-worker-threads", 0);
        maxServerWorkerThreads = NettyUtil.getIntOption("com.genesyslab.platform.commons.connection.impl.netty.max-worker-threads", Integer.MAX_VALUE);
    }

    private static class ReleaseDefaultClientFactoryTask
    implements TimerAction {
        private ReleaseDefaultClientFactoryTask() {
        }

        public void onTimer() {
            NettyUtil.doReleaseDefaultClientChannelFactory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NettyTransportType {
        NioTransport,
        OioTransport;

    }
}

