/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.netty;

import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.connection.impl.netty.NettyConnectionImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.Channels;

public class NettyWritePipeImpl
implements WritePipe {
    private ILogger log = Log.getLogger(NettyWritePipeImpl.class);
    private NettyConnectionImpl connection;
    private final List<ChannelBuffer> pendingWrites = Collections.synchronizedList(new ArrayList());

    public NettyWritePipeImpl(NettyConnectionImpl connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(WritePoint writePoint) {
        if (!(writePoint instanceof WritePointImpl)) {
            throw new IllegalArgumentException("Incompatible WritePoint, mixing connection implementation?");
        }
        Channel channel = this.connection.getChannel();
        if (channel == null) {
            this.log.debug((Object)"Attempt to write while connection is closed, request is queued");
            List<ChannelBuffer> list = this.pendingWrites;
            synchronized (list) {
                this.pendingWrites.add(((WritePointImpl)writePoint).getBuffer());
            }
        } else {
            if (!this.pendingWrites.isEmpty()) {
                this.writePendingData();
            }
            Channels.write((Channel)channel, (Object)((WritePointImpl)writePoint).getBuffer());
        }
    }

    public WritePoint createWritePoint() {
        return new WritePointImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePendingData() {
        Channel channel = this.connection.getChannel();
        List<ChannelBuffer> list = this.pendingWrites;
        synchronized (list) {
            if (this.pendingWrites.isEmpty()) {
                return;
            }
            if (channel == null) {
                this.log.debug((Object)"Can't write pending data to channel - its not open...");
                return;
            }
            this.log.debug((Object)"Writing queued requests...");
            for (ChannelBuffer bb : this.pendingWrites) {
                Channels.write((Channel)channel, (Object)bb);
            }
            this.pendingWrites.clear();
        }
    }

    public void close(Throwable closeReason) {
    }

    static class WritePointImpl
    implements WritePoint {
        private ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((int)1024);

        WritePointImpl() {
        }

        public void write(byte[] bytes) {
            this.buffer.writeBytes(bytes);
        }

        public void write(byte[] bytes, int offset, int len) {
            this.buffer.writeBytes(bytes, offset, len);
        }

        public ChannelBuffer getBuffer() {
            return this.buffer;
        }
    }
}

