/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.messageserver.requests;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecAttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecLazyParser;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.ToStringHelper;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableProtocolId;
import com.genesyslab.platform.management.protocol.messageserver.AttributeList;
import com.genesyslab.platform.management.protocol.messageserver.LogCategory;
import com.genesyslab.platform.management.protocol.messageserver.LogLevel;
import com.genesyslab.platform.management.protocol.messageserver.MessageKey;
import com.genesyslab.platform.management.protocol.messageserver.MessageServerProtocolFactory;
import com.genesyslab.platform.management.protocol.messageserver.MessageTypes;
import com.genesyslab.platform.management.protocol.messageserver.runtime.codec.AttributeListCodec;
import com.genesyslab.platform.management.protocol.messageserver.runtime.codec.UnixTimeCodec;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class RequestLogMessage
extends Message {
    public static final int ID = 1101;
    public static final String NAME = "RequestLogMessage";

    private RequestLogMessage() {
        super(1101, NAME, MessageServerProtocolFactory.PROTOCOL_DESCRIPTION);
    }

    public static RequestLogMessage create() {
        return new Data();
    }

    public static RequestLogMessage create(Integer entryId, String entryText, LogLevel level, LogCategory entryCategory, Date time, String clientHost) {
        Data res = new Data();
        res.setEntryId(entryId);
        res.setEntryText(entryText);
        res.setLevel(level);
        res.setEntryCategory(entryCategory);
        res.setTime(time);
        res.setClientHost(clientHost);
        return res;
    }

    public static RequestLogMessage create(Integer entryId, String entryText, LogLevel level) {
        Data res = new Data();
        res.setEntryId(entryId);
        res.setEntryText(entryText);
        res.setLevel(level);
        return res;
    }

    public static RequestLogMessage create(Integer entryId, String entryText, LogLevel level, LogCategory entryCategory, Date time, String clientHost, AttributeList attributes) {
        Data res = new Data();
        res.setEntryId(entryId);
        res.setEntryText(entryText);
        res.setLevel(level);
        res.setEntryCategory(entryCategory);
        res.setTime(time);
        res.setClientHost(clientHost);
        res.setAttributes(attributes);
        return res;
    }

    public abstract Integer getEntryId();

    public abstract void setEntryId(Integer var1);

    public abstract void setEntryId(int var1);

    public abstract String getEntryText();

    public abstract void setEntryText(String var1);

    public abstract LogLevel getLevel();

    public abstract void setLevel(LogLevel var1);

    public abstract LogCategory getEntryCategory();

    public abstract void setEntryCategory(LogCategory var1);

    public abstract Date getTime();

    public abstract void setTime(Date var1);

    public abstract String getClientHost();

    public abstract void setClientHost(String var1);

    public abstract AttributeList getAttributes();

    public abstract void setAttributes(AttributeList var1);

    private static class Data
    extends RequestLogMessage
    implements DataSupport,
    EndpointSupport,
    UpdatableProtocolId {
        private static Map compoundData = null;
        private static Map attrDescriptions = null;
        private static Map tagMapping = null;
        private static MetaData metaData;
        private Map attributes = new HashMap();
        private Map compounds = new HashMap();
        private final CodecLazyParser lazyParser = new CodecLazyParser((DataSupport)this);
        private Endpoint endpoint;
        private int protocolId = 0;
        private List packagers = null;

        private Data() {
            this.setMessageType((MessageTypes)GEnum.getValue(MessageTypes.class, (int)1101));
            this.setLogMessageLength(11268);
            this.setLevel((LogLevel)GEnum.getValue(LogLevel.class, (int)0));
            this.setEntryCategory((LogCategory)GEnum.getValue(LogCategory.class, (int)0));
            this.setEntryOrigin(0);
            this.setTimeWritten(0);
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void setProtocolId(int id) {
            this.protocolId = id;
        }

        public int getProtocolId() {
            return this.protocolId;
        }

        public Object getMessageAttribute(String index) {
            Object res;
            if (this.attributes.get(index) == null && this.lazyParser.hasAttribute(index)) {
                this.lazyParser.parse(index);
            }
            if ((res = this.attributes.get(index)) == null) {
                res = this.compounds.get(index);
            }
            return res;
        }

        public MetaData getMetaData() {
            return metaData;
        }

        public Map attributes() {
            return this.attributes;
        }

        public Map getCompounds() {
            return this.compounds;
        }

        public DataSupport createClone(DataSupport sample) {
            Data clone = new Data();
            for (String sAttr : this.lazyParser.getNotParsed()) {
                this.lazyParser.parse(sAttr);
            }
            clone.attributes = new HashMap(this.attributes);
            clone.compounds = new HashMap(this.compounds);
            return clone;
        }

        public List getCustomPackagers() {
            if (this.packagers == null) {
                this.packagers = new LinkedList();
                this.packagers.add(new UnixTimeCodec());
                this.packagers.add(new AttributeListCodec());
            }
            return this.packagers;
        }

        public CodecLazyParser getLazyParser() {
            return this.lazyParser;
        }

        public void setMessageType(MessageTypes messageType) {
            this.attributes.put("MessageType", messageType);
        }

        public void setLogMessageLength(Integer logMessageLength) {
            this.attributes.put("LogMessageLength", logMessageLength);
        }

        public void setLogMessageLength(int logMessageLength) {
            this.attributes.put("LogMessageLength", new Integer(logMessageLength));
        }

        public Integer getEntryId() {
            return (Integer)this.attributes.get("EntryId");
        }

        public void setEntryId(Integer entryId) {
            this.attributes.put("EntryId", entryId);
        }

        public void setEntryId(int entryId) {
            this.attributes.put("EntryId", new Integer(entryId));
        }

        public String getEntryText() {
            return (String)this.attributes.get("EntryText");
        }

        public void setEntryText(String entryText) {
            this.attributes.put("EntryText", entryText);
        }

        public LogLevel getLevel() {
            return (LogLevel)((Object)this.attributes.get("Level"));
        }

        public void setLevel(LogLevel level) {
            this.attributes.put("Level", level);
        }

        public LogCategory getEntryCategory() {
            return (LogCategory)((Object)this.attributes.get("EntryCategory"));
        }

        public void setEntryCategory(LogCategory entryCategory) {
            this.attributes.put("EntryCategory", entryCategory);
        }

        public void setEntryOrigin(Integer entryOrigin) {
            this.attributes.put("EntryOrigin", entryOrigin);
        }

        public void setEntryOrigin(int entryOrigin) {
            this.attributes.put("EntryOrigin", new Integer(entryOrigin));
        }

        public Date getTime() {
            return (Date)this.attributes.get("Time");
        }

        public void setTime(Date time) {
            this.attributes.put("Time", time);
        }

        public void setTimeWritten(Integer timeWritten) {
            this.attributes.put("TimeWritten", timeWritten);
        }

        public void setTimeWritten(int timeWritten) {
            this.attributes.put("TimeWritten", new Integer(timeWritten));
        }

        public String getClientHost() {
            return (String)this.attributes.get("ClientHost");
        }

        public void setClientHost(String clientHost) {
            this.attributes.put("ClientHost", clientHost);
        }

        public AttributeList getAttributes() {
            return (AttributeList)this.attributes.get("Attributes");
        }

        public void setAttributes(AttributeList attributes) {
            this.attributes.put("Attributes", attributes);
        }

        public String toString(boolean hideAllowed, boolean truncateLargeData) {
            return ToStringHelper.toString((Message)this, (boolean)hideAllowed, (boolean)truncateLargeData);
        }

        static {
            compoundData = new HashMap();
            compoundData.put("MessageKey", MessageKey.class);
            AttributeDescription propKey = null;
            attrDescriptions = new HashMap();
            propKey = new AttributeDescription("4", "MessageType", MessageTypes.class, MessageTypes.class, "attr_message_type", false, true);
            propKey.setHidden(true);
            attrDescriptions.put("4", propKey);
            attrDescriptions.put("MessageType", propKey);
            propKey = new AttributeDescription("inner.0", "LogMessageLength", Integer.class, null, "x_log_msg_length", false, true);
            propKey.setHidden(true);
            attrDescriptions.put("inner.0", propKey);
            attrDescriptions.put("LogMessageLength", propKey);
            propKey = new AttributeDescription("inner.5", "EntryId", Integer.class, null, "x_log_entry_id", false, false);
            attrDescriptions.put("inner.5", propKey);
            attrDescriptions.put("EntryId", propKey);
            propKey = new AttributeDescription("inner.9", "EntryText", String.class, null, "x_entry_text", false, false);
            attrDescriptions.put("inner.9", propKey);
            attrDescriptions.put("EntryText", propKey);
            propKey = new AttributeDescription("inner.3", "Level", LogLevel.class, LogLevel.class, "x_log_priority", false, false);
            attrDescriptions.put("inner.3", propKey);
            attrDescriptions.put("Level", propKey);
            propKey = new AttributeDescription("inner.6", "EntryCategory", LogCategory.class, LogCategory.class, "x_log_category", false, false);
            attrDescriptions.put("inner.6", propKey);
            attrDescriptions.put("EntryCategory", propKey);
            propKey = new AttributeDescription("inner.4", "EntryOrigin", Integer.class, null, "x_log_origin", false, true);
            propKey.setHidden(true);
            attrDescriptions.put("inner.4", propKey);
            attrDescriptions.put("EntryOrigin", propKey);
            propKey = new CodecAttributeDescription(UnixTimeCodec.class, "inner.1", "Time", Date.class, null, "x_log_time_generated", false, false, false);
            attrDescriptions.put("inner.1", propKey);
            attrDescriptions.put("Time", propKey);
            propKey = new AttributeDescription("inner.2", "TimeWritten", Integer.class, null, "x_log_time_written", false, true);
            propKey.setHidden(true);
            attrDescriptions.put("inner.2", propKey);
            attrDescriptions.put("TimeWritten", propKey);
            propKey = new AttributeDescription("inner.7", "ClientHost", String.class, null, "x_log_hostname", false, false);
            attrDescriptions.put("inner.7", propKey);
            attrDescriptions.put("ClientHost", propKey);
            propKey = new CodecAttributeDescription(AttributeListCodec.class, "virtual1", "Attributes", AttributeList.class, null, "AttributeList", false, false, false);
            attrDescriptions.put("virtual1", propKey);
            attrDescriptions.put("Attributes", propKey);
            metaData = new MetaData("1101", RequestLogMessage.NAME, compoundData, attrDescriptions, tagMapping);
        }
    }
}

