/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com;

import com.genesyslab.platform.applicationblocks.com.CfgBase;
import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.applicationblocks.com.ConfigRuntimeException;
import com.genesyslab.platform.applicationblocks.com.ICfgDelta;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.applicationblocks.com.PermissionDescriptor;
import com.genesyslab.platform.applicationblocks.com.runtime.GlobalConfService;
import com.genesyslab.platform.applicationblocks.com.runtime.XmlObjectUpdateHelper;
import com.genesyslab.platform.applicationblocks.com.runtime.XmlPermissionsHelper;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.protocol.Protocol;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectCreated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectDeleted;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import com.genesyslab.platform.configuration.protocol.utilities.CfgUtilities;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CfgObject
extends CfgBase
implements ICfgObject {
    private Node oldXmlData;
    private KeyValueCollection parameters;
    private String objectPath;

    protected CfgObject(IConfService confService, Node xmlData, Object[] additionalParameters, String dataClassName) {
        super(confService, xmlData, false, null, dataClassName);
        this.setIsSaved(true);
        this.updateChildrenSavedState();
        this.parameters = null;
        if (additionalParameters != null) {
            if (additionalParameters[0] != null && additionalParameters[0] instanceof KeyValueCollection) {
                this.parameters = (KeyValueCollection)additionalParameters[0];
            }
            if (additionalParameters[1] != null) {
                this.objectPath = additionalParameters[1].toString();
            }
        }
    }

    protected CfgObject(IConfService confService, String className, String dataClassName) {
        super(confService, className, false, null, dataClassName);
        this.setIsSaved(false);
        this.updateChildrenSavedState();
    }

    @Override
    public CfgObjectType getObjectType() {
        return ((CfgDescriptionObject)this.getMetaData()).getCfgEnum();
    }

    @Override
    public int getObjectDbid() {
        Integer dbid = (Integer)this.getProperty("DBID");
        if (dbid != null) {
            return dbid;
        }
        return 0;
    }

    public final String getObjectPath() {
        return this.objectPath;
    }

    public final Integer getFolderId() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.getInt("folder_dbid");
    }

    public final void setFolderId(Integer dbid) {
        if (this.isSaved()) {
            throw new ConfigRuntimeException("Can't change this property because object has been saved.");
        }
        if (this.parameters == null) {
            this.parameters = new KeyValueCollection();
        }
        if (this.parameters.containsKey((Object)"folder_dbid")) {
            this.parameters.remove("folder_dbid");
        }
        if (dbid != null) {
            this.parameters.addInt("folder_dbid", dbid);
        }
    }

    @Override
    public void save() throws ConfigException {
        this.save(this.getConfigurationService().getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Protocol protocol) throws ConfigException {
        this.lockObject().writeLock().lock();
        try {
            this.refreshXmlImpl();
            if (this.getLogger().isInfo()) {
                this.getLogger().infoFormat("Saving object... [{0}], Dbid: [{1}]", (Object)new Object[]{this.getObjectType(), this.getObjectDbid()});
            }
            if (this.isSaved()) {
                this.updateSavedObject(protocol);
            } else {
                this.createNewObject(protocol);
            }
            if (this.getLogger().isInfo()) {
                this.getLogger().infoFormat("Save operation successful. [{0}], Dbid: [{1}]", (Object)new Object[]{this.getObjectType(), this.getObjectDbid()});
            }
            if (this.getConfigurationService().getPolicy().getCacheOnSave(this)) {
                this.updateCacheOnSave();
            }
        }
        finally {
            this.lockObject().writeLock().unlock();
        }
    }

    private void createNewObject(Protocol protocol) throws ConfigException {
        EventObjectCreated evCrt;
        Document deltaDoc = XmlObjectUpdateHelper.createDeltaForNewObject(this);
        if (this.getLogger().isDebug()) {
            this.getLogger().debugFormat("This is a new object and it will be created using the following XML:\r\n {0}", (Object)deltaDoc);
        }
        try {
            evCrt = GlobalConfService.createObject(protocol, this.getObjectType(), deltaDoc, this.parameters);
        }
        catch (Exception ex) {
            if (this.getLogger().isInfo()) {
                this.getLogger().infoFormat("Unable to create object! [{0}], Dbid: [{1}]\r\n {2}", (Object)new Object[]{this.getObjectType(), this.getObjectDbid(), ex});
            }
            if (ex instanceof ConfigException) {
                throw (ConfigException)ex;
            }
            throw new ConfigException("Unable to create object!", ex);
        }
        Node newObjectXml = evCrt.getConfObject().getDocumentElement().getFirstChild();
        if (newObjectXml != null) {
            this.reloadObjectWithNewXml(newObjectXml);
            this.setIsSaved(true);
            this.oldXmlData = null;
        }
    }

    private void updateSavedObject(Protocol protocol) throws ConfigException {
        Document deltaDoc;
        CfgUtilities utils = new CfgUtilities(this.getConfigurationService().getMetaData());
        Document oldDoc = this.getDocumentBuilder().newDocument();
        Element oldDocRoot = oldDoc.createElementNS(CFG_NS, "ConfData");
        oldDoc.appendChild(oldDocRoot);
        oldDocRoot.appendChild(oldDoc.importNode(XmlObjectUpdateHelper.sortObjectAttributes(this.oldXmlData, this.getMetaData()), true));
        Document newDoc = this.getDocumentBuilder().newDocument();
        Element newDocRoot = newDoc.createElementNS(CFG_NS, "ConfData");
        newDoc.appendChild(newDocRoot);
        newDocRoot.appendChild(newDoc.importNode(XmlObjectUpdateHelper.sortObjectAttributes(this.getData(), this.getMetaData()), true));
        try {
            deltaDoc = utils.createDelta(oldDoc, newDoc);
        }
        catch (Exception ex) {
            this.getLogger().debug((Object)"Unable to create delta", (Throwable)ex);
            throw new ConfigException("Unable to update object!", ex);
        }
        if (this.getLogger().isDebug()) {
            this.getLogger().debugFormat("This is an update of an existing object and it will be updated using the following delta:\r\n {0}", (Object)deltaDoc);
        }
        try {
            GlobalConfService.updateObject(protocol, this.getObjectType(), deltaDoc, this.parameters);
        }
        catch (Exception ex) {
            if (this.getLogger().isInfo()) {
                this.getLogger().infoFormat("Unable to update object! [{0}], Dbid: [{1}]\r\n {2}", (Object)new Object[]{this.getObjectType(), this.getObjectDbid(), ex});
            }
            if (ex instanceof ConfigException) {
                throw (ConfigException)ex;
            }
            throw new ConfigException("Unable to update object!", ex);
        }
        this.oldXmlData = null;
    }

    private void updateCacheOnSave() throws ConfigException {
        block6: {
            if (this.getLogger().isInfo()) {
                this.getLogger().infoFormat("Adding to cache. [{0}], Dbid: [{1}]", (Object)new Object[]{this.getObjectType(), this.getObjectDbid()});
            }
            if (this.getConfigurationService().getCache() == null) {
                throw new NullPointerException("Cache is not initialized");
            }
            try {
                if (this.getConfigurationService().getCache().contains(this)) {
                    this.getConfigurationService().getCache().update(this);
                } else {
                    this.getConfigurationService().getCache().add(this);
                }
            }
            catch (Exception ex) {
                if (!this.getLogger().isInfo()) break block6;
                this.getLogger().infoFormat("Unable to add/update to cache! [{0}], Dbid [{1}]\r\n {2}", (Object)new Object[]{this.getObjectType(), this.getObjectDbid(), ex});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws ConfigException {
        this.lockObject().writeLock().lock();
        try {
            try {
                this.delete(this.getConfigurationService().getProtocol());
            }
            catch (Exception ex) {
                if (ex instanceof ConfigException) {
                    throw (ConfigException)ex;
                }
                throw new ConfigException("Exception on object delete operation", ex);
            }
            this.setIsSaved(false);
            this.updateChildrenSavedState();
            super.setProperty("DBID", new Integer(0));
        }
        finally {
            this.lockObject().writeLock().unlock();
        }
    }

    private void delete(Protocol protocol) throws ConfigException {
        int idObj = this.getObjectDbid();
        if (!this.isSaved()) {
            throw new ConfigException("This object has not been saved.");
        }
        if (idObj == 0) {
            throw new ConfigException("No DBID set");
        }
        EventObjectDeleted evDel = GlobalConfService.deleteObject(protocol, this.getObjectType(), idObj);
        if (evDel != null) {
            this.oldXmlData = null;
            if (this.getLogger().isInfo()) {
                this.getLogger().infoFormat("Deleted object [{0}], Dbid: [{1}] from Configuration Server.", (Object)new Object[]{this.getObjectType(), this.getObjectDbid()});
            }
            if (this.getConfigurationService().getCache() != null && this.getConfigurationService().getCache().getPolicy().getRemoveOnDelete(this)) {
                this.getConfigurationService().getCache().remove(this);
                if (this.getLogger().isInfo()) {
                    this.getLogger().infoFormat("Deleted object [{0}], Dbid: [{1}] from cache.", (Object)new Object[]{this.getObjectType(), this.getObjectDbid()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws ConfigException {
        this.lockObject().writeLock().lock();
        try {
            this.getConfigurationService().refreshObject(this);
            this.oldXmlData = null;
            if (this.getLogger().isInfo()) {
                this.getLogger().infoFormat("Refreshed object [{0}], Dbid: {1}.", (Object)new Object[]{this.getObjectType(), this.getObjectDbid()});
            }
        }
        finally {
            this.lockObject().writeLock().unlock();
        }
    }

    @Override
    public void update(ICfgDelta deltaObject) {
        if (deltaObject == null) {
            throw new NullPointerException("deltaObject");
        }
        CfgUtilities util = new CfgUtilities(this.getConfigurationService().getMetaData());
        Document docData = this.getDocumentBuilder().newDocument();
        Element dataRoot = docData.createElementNS(CFG_NS, "ConfData");
        docData.appendChild(dataRoot);
        Document docDelta = this.getDocumentBuilder().newDocument();
        Element deltaRoot = docDelta.createElementNS(CFG_NS, "ConfData");
        docDelta.appendChild(deltaRoot);
        dataRoot.appendChild(docData.importNode(this.getData(), true));
        deltaRoot.appendChild(docDelta.adoptNode(deltaObject.toXml()));
        util.applyDelta(docData, docDelta);
        this.reloadObjectWithNewXml(docData.getDocumentElement().getFirstChild());
        this.oldXmlData = null;
    }

    public int retrieveAccountPermissions(CfgObject accountObject) throws ConfigException {
        if (accountObject == null) {
            throw new NullPointerException("accountObject can't be null");
        }
        return GlobalConfService.readObjectPermissions(this.getConfigurationService().getProtocol(), (Integer)this.getProperty("DBID"), this.getObjectType(), (Integer)accountObject.getProperty("DBID"), accountObject.getObjectType());
    }

    public List<PermissionDescriptor> retrievePermissions() throws ConfigException {
        Document permissions = GlobalConfService.readPermissions(this.getConfigurationService().getProtocol(), this.getObjectDbid(), this.getObjectType());
        return XmlPermissionsHelper.extractPermissionsList(permissions);
    }

    public void removeAccount(CfgObject accountObject, boolean recursive) throws ConfigException {
        if (accountObject == null) {
            throw new NullPointerException("accountObject");
        }
        int recurs = 0;
        if (recursive) {
            recurs = 1;
        }
        GlobalConfService.removeAccount(this.getConfigurationService().getProtocol(), this.getObjectDbid(), this.getObjectType(), accountObject.getObjectDbid(), accountObject.getObjectType(), recurs);
    }

    public void setAccountPermissions(CfgObject accountObject, int newPermissionsMask) throws ConfigException {
        this.setAccountPermissions(accountObject, newPermissionsMask, true);
    }

    public void setAccountPermissions(CfgObject accountObject, int newPermissionsMask, boolean recursive) throws ConfigException {
        if (accountObject == null) {
            throw new NullPointerException("accountObject can't be null");
        }
        int dbidObj = this.getObjectDbid();
        if (dbidObj == 0) {
            throw new ConfigRuntimeException("Config object has not been saved");
        }
        int dbidPers = accountObject.getObjectDbid();
        if (dbidPers == 0) {
            throw new ConfigRuntimeException("Account object has not been saved");
        }
        int rec = 0;
        if (recursive) {
            rec = 1;
        }
        GlobalConfService.updatePermissions(this.getConfigurationService().getProtocol(), dbidObj, this.getObjectType(), dbidPers, accountObject.getObjectType(), newPermissionsMask, rec);
    }

    @Override
    protected final void ensureDataBackup() {
        if (this.oldXmlData == null && this.isSaved()) {
            Document newDoc = this.getDocumentBuilder().newDocument();
            this.oldXmlData = newDoc.importNode(this.getData(), true);
            newDoc.appendChild(this.oldXmlData);
        }
    }

    @Override
    boolean refreshXmlImpl() {
        this.ensureDataBackup();
        return super.refreshXmlImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CfgObject clone() throws CloneNotSupportedException {
        this.lockObject().writeLock().lock();
        try {
            CfgObject ret = (CfgObject)super.clone();
            if (this.oldXmlData != null) {
                Document newDoc = this.getDocumentBuilder().newDocument();
                ret.oldXmlData = newDoc.importNode(this.oldXmlData, true);
                newDoc.appendChild(ret.oldXmlData);
            }
            if (this.parameters != null) {
                ret.parameters = (KeyValueCollection)this.parameters.clone();
            }
            CfgObject cfgObject = ret;
            return cfgObject;
        }
        finally {
            this.lockObject().writeLock().unlock();
        }
    }
}

