/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.cache;

import com.genesyslab.platform.applicationblocks.com.ICfgFilterBasedQuery;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.ICfgQuery;
import com.genesyslab.platform.applicationblocks.com.cache.CacheKey;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCacheQueryEngine;
import com.genesyslab.platform.applicationblocks.com.cache.IConfCacheStorage;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultConfCacheQueryEngine
implements IConfCacheQueryEngine {
    private IConfCacheStorage storage;

    public DefaultConfCacheQueryEngine(IConfCacheStorage storage) {
        if (storage == null) {
            throw new NullPointerException("storage");
        }
        this.storage = storage;
    }

    @Override
    public boolean canExecute(ICfgQuery query) {
        ICfgFilterBasedQuery fbQuery = null;
        if (query instanceof ICfgFilterBasedQuery) {
            fbQuery = (ICfgFilterBasedQuery)query;
        }
        return fbQuery != null && fbQuery.getProperty("dbid") != null;
    }

    @Override
    public <T extends ICfgObject> T retrieveObject(Class<T> cls, ICfgQuery query) {
        if (!this.canExecute(query)) {
            throw new IllegalArgumentException("Query not supported");
        }
        ICfgFilterBasedQuery fbQuery = null;
        if (query instanceof ICfgFilterBasedQuery) {
            fbQuery = (ICfgFilterBasedQuery)query;
        }
        return this.retrieveObject(cls, fbQuery.getCfgObjectType(), fbQuery.getInt("dbid"));
    }

    @Override
    public <T extends ICfgObject> T retrieveObject(Class<T> cls, CfgObjectType type, int dbid) {
        for (ICfgObject obj : this.storage.retrieve(cls, new CacheKey(type, dbid))) {
            if (obj.getObjectType() != type || obj.getObjectDbid() != dbid) continue;
            return (T)obj;
        }
        return null;
    }

    @Override
    public <T extends ICfgObject> Collection<T> retrieveMultipleObjects(Class<T> cls, ICfgQuery query) {
        throw new RuntimeException("Not implemented");
    }
}

