/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRElemExpr;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDir;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBody;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CRAndExprBlock
extends CapacityRuleAbstractElement {
    private CRRuleBody parent;
    private ArrayList<CRElemExpr> list = new ArrayList();

    public CRAndExprBlock(CRRuleBody parent) {
        this.parent = parent;
    }

    public CRAndExprBlock(CRRuleBody parent, ByteBuffer buf) throws CapacityRuleException {
        this(parent);
        this.read(buf);
    }

    @Override
    public CRRuleBody getParent() {
        return this.parent;
    }

    @Override
    public void write(ICapacityRuleWriter writer) {
        if (this.list == null) {
            return;
        }
        int count = this.list.size();
        writer.addByte((byte)count);
        for (int i = 0; i < count; ++i) {
            CRElemExpr elem = this.list.get(i);
            if (elem == null) continue;
            elem.write(writer);
        }
    }

    private void read(ByteBuffer buf) throws CapacityRuleException {
        int count = buf.get() & 0xFF;
        for (int i = 0; i < count; ++i) {
            CRElemExpr expr = new CRElemExpr(this, buf);
            this.add(expr);
        }
    }

    public void add(CRElemExpr expr) {
        this.list.add(expr);
    }

    public int hashCode() {
        int hashCode = CRMediaDir.class.hashCode();
        for (CRElemExpr entry : this.list) {
            hashCode = hashCode * 31 + entry.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRAndExprBlock)) {
            return false;
        }
        CRAndExprBlock o = (CRAndExprBlock)obj;
        if (this.list.size() != o.list.size()) {
            return false;
        }
        ArrayList tmp = (ArrayList)o.list.clone();
        block0: for (CRElemExpr entry : this.list) {
            int size = tmp.size();
            for (int j = 0; j < size; ++j) {
                CRElemExpr entry2 = (CRElemExpr)tmp.get(j);
                if (!entry.equals(entry2)) continue;
                tmp.remove(j);
                continue block0;
            }
            return false;
        }
        return true;
    }

    public CRMediaMap getMap() {
        return this.parent == null ? null : this.parent.getMap();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND");
        sb.append('(');
        for (CRElemExpr expr : this.list) {
            sb.append(expr);
            sb.append(',');
        }
        if (!this.list.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    public ArrayList<CRElemExpr> getList() {
        return this.list;
    }
}

