/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDir;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRXmlUtils;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.EnterElementArgs;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleProcessElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleReader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import com.genesyslab.platform.applicationblocks.com.capacityrules.LeaveElementArgs;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CRHeader
extends CapacityRuleAbstractElement
implements ICapacityRuleProcessElement {
    static final String TAG_NAME = "CapacityRule";
    static final int MAGIC_NUMBER = 5450453;
    private CRMediaMap mediaMap;
    private CRMediaDir mediaDir;
    private CapacityRule parent;

    CRHeader(ICapacityRuleReader reader, CapacityRule parent) {
        this.parent = parent;
        reader.registerProcessElement(this);
    }

    public CRHeader(byte[] binary) throws CapacityRuleException {
        ByteBuffer buf = ByteBuffer.wrap(binary);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.read(buf);
    }

    public HashMap<String, Integer> getSimpleMediaMap() {
        return this.mediaMap == null ? null : this.mediaMap.getSimpleMediaMap();
    }

    @Override
    public CapacityRule getParent() {
        return this.parent;
    }

    public CRMediaDir getMediaDir() {
        return this.mediaDir;
    }

    public CRMediaMap getMediaMap() {
        return this.mediaMap;
    }

    @Override
    public void onProcessElement(Object sender, Object args) throws CapacityRuleException {
        String localName;
        Element element;
        if (args instanceof EnterElementArgs && (element = ((EnterElementArgs)args).getElement()) != null) {
            localName = CRXmlUtils.getLocalName(element);
            if (localName.equalsIgnoreCase("MediaTypes") && this.mediaMap == null) {
                this.mediaMap = new CRMediaMap(this, (ICapacityRuleReader)sender);
            }
            if (localName.equalsIgnoreCase("MediaRule")) {
                if (this.mediaDir == null) {
                    this.mediaDir = new CRMediaDir(this);
                }
                this.mediaDir.add(element, (ICapacityRuleReader)sender);
            }
        }
        if (args instanceof LeaveElementArgs && (element = ((LeaveElementArgs)args).getElement()) != null && (localName = element.getLocalName()).equalsIgnoreCase(TAG_NAME)) {
            ICapacityRuleReader reader = (ICapacityRuleReader)sender;
            if (reader != null) {
                reader.registerProcessElement(this);
            }
            this.process();
        }
    }

    void process() throws CapacityRuleException {
        if (this.mediaDir != null) {
            this.mediaDir.process(this.mediaMap);
        }
    }

    @Override
    public void write(ICapacityRuleWriter writer) {
        writer.addInt(5450453);
        writer.addInt(-1);
        writer.addInt(-1);
        writer.addInt(-1);
        writer.addInt(0);
        if (this.mediaDir != null) {
            writer.setInt(8, writer.size());
            this.mediaDir.write(writer);
        }
        if (this.mediaMap != null) {
            writer.setInt(12, writer.size());
            this.mediaMap.write(writer);
        }
        writer.setInt(4, writer.size());
    }

    public void read(ByteBuffer buf) throws CapacityRuleException {
        int positionBase = buf.position();
        int mn = buf.getInt();
        if (mn != 5450453) {
            throw new CapacityRuleException("invalid magic number: " + Integer.toHexString(mn));
        }
        int size = buf.getInt();
        if (size < 16) {
            throw new CapacityRuleException("invalid size: " + size);
        }
        int oMediaDir = buf.getInt();
        int oMediaMap = buf.getInt();
        if (oMediaMap > 0) {
            buf.position(positionBase + oMediaMap);
            this.mediaMap = new CRMediaMap(this, buf, positionBase);
        }
        if (oMediaDir > 0) {
            buf.position(positionBase + oMediaDir);
            this.mediaDir = new CRMediaDir(this, buf, positionBase);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mediaMap != null) {
            sb.append(this.mediaMap);
        }
        if (this.mediaDir != null) {
            sb.append(this.mediaDir);
        }
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = CRHeader.class.hashCode();
        if (this.mediaMap != null) {
            hashCode = 31 * hashCode + this.mediaMap.hashCode();
        }
        if (this.mediaDir != null) {
            hashCode = 31 * hashCode + this.mediaDir.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRHeader)) {
            return false;
        }
        CRHeader o = (CRHeader)obj;
        if (this.mediaMap != null ? !this.mediaMap.equals(o.mediaMap) : o.mediaMap != null) {
            return false;
        }
        return !(this.mediaDir != null ? !this.mediaDir.equals(o.mediaDir) : o.mediaDir != null);
    }

    public boolean match(CRHeader h2) {
        if (this.mediaMap != null ? !this.mediaMap.equals(h2.mediaMap) : h2.mediaMap != null) {
            return false;
        }
        return this.mediaDir != null ? this.mediaDir.match(h2.mediaDir) : h2.mediaDir == null;
    }
}

