/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRHeader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDirEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleReader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CRMediaDir
extends CapacityRuleAbstractElement {
    static final String TAG_NAME = "MediaRule";
    private CRHeader parent;
    private final ArrayList<CRMediaDirEntry> entries = new ArrayList();

    public CRMediaDir(CRHeader parent) {
        this.parent = parent;
    }

    public CRMediaDir(CRHeader parent, ByteBuffer buf, int positionBase) throws CapacityRuleException {
        this(parent);
        this.read(buf, positionBase);
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public List<CRMediaDirEntry> getEntries() {
        return this.entries;
    }

    public void add(Element element, ICapacityRuleReader reader) {
        String attrNValue = element.getAttribute("media");
        if (attrNValue == null) {
            return;
        }
        CRMediaDirEntry dirEntry = null;
        for (CRMediaDirEntry entry : this.entries) {
            if (!entry.getMediaName().equalsIgnoreCase(attrNValue)) continue;
            dirEntry = entry;
            break;
        }
        if (dirEntry == null) {
            CRMediaDirEntry item = CRMediaDirEntry.create(this, reader, element);
            if (item != null) {
                this.entries.add(item);
            }
            return;
        }
        dirEntry.addNewRuleBlock(reader, element);
    }

    void process(CRMediaMap map) throws CapacityRuleException {
        if (this.entries == null) {
            return;
        }
        for (CRMediaDirEntry entry : this.entries) {
            entry.updateMediaMapType(map);
        }
        for (CRMediaDirEntry entry : this.entries) {
            entry.process(map);
        }
    }

    @Override
    public void write(ICapacityRuleWriter writer) {
        CRMediaDirEntry item;
        int i;
        if (this.entries == null) {
            return;
        }
        int count = this.entries.size();
        writer.addByte((byte)count);
        int offsetsTable = writer.size();
        for (i = 0; i < count; ++i) {
            item = this.entries.get(i);
            writer.addByte((byte)item.getMediaType());
            writer.addInt(-1);
        }
        for (i = 0; i < count; ++i) {
            item = this.entries.get(i);
            if (item == null) continue;
            writer.setInt(offsetsTable + i * 5 + 1, writer.size());
            item.write(writer);
        }
    }

    private void read(ByteBuffer buf, int positionBase) throws CapacityRuleException {
        int count = buf.get() & 0xFF;
        for (int index = 0; index < count; ++index) {
            int mediaType = buf.get() & 0xFF;
            int itemOffset = buf.getInt();
            int posBackup = buf.position();
            try {
                buf.position(positionBase + itemOffset);
            }
            catch (IllegalArgumentException E) {
                throw new CapacityRuleException("invalid media dir entry offset: " + itemOffset + " ( index:" + index + " )");
            }
            this.add(new CRMediaDirEntry(this, mediaType, buf, positionBase));
            buf.position(posBackup);
        }
    }

    private void add(CRMediaDirEntry item) {
        this.entries.add(item);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.entries != null) {
            for (CRMediaDirEntry entry : this.entries) {
                sb.append(entry);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = CRMediaDir.class.hashCode();
        for (CRMediaDirEntry entry : this.entries) {
            hashCode = hashCode * 31 + entry.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRMediaDir)) {
            return false;
        }
        CRMediaDir o = (CRMediaDir)obj;
        if (this.entries.size() != o.entries.size()) {
            return false;
        }
        ArrayList tmp = (ArrayList)o.entries.clone();
        block0: for (CRMediaDirEntry entry : this.entries) {
            int size = tmp.size();
            for (int j = 0; j < size; ++j) {
                CRMediaDirEntry entry2 = (CRMediaDirEntry)tmp.get(j);
                if (!entry.equals(entry2)) continue;
                tmp.remove(j);
                continue block0;
            }
            return false;
        }
        return true;
    }

    public CRMediaMap getMap() {
        return this.parent == null ? null : this.parent.getMediaMap();
    }

    public boolean match(CRMediaDir mediaDir) {
        if (mediaDir == null) {
            return false;
        }
        if (this.entries.size() != mediaDir.entries.size()) {
            return false;
        }
        ArrayList tmp = (ArrayList)mediaDir.entries.clone();
        block0: for (CRMediaDirEntry entry : this.entries) {
            int size = tmp.size();
            for (int j = 0; j < size; ++j) {
                CRMediaDirEntry entry2 = (CRMediaDirEntry)tmp.get(j);
                if (!entry.match(entry2)) continue;
                tmp.remove(j);
                continue block0;
            }
            return false;
        }
        return true;
    }
}

