/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDir;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlock;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleAbstractElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleReader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleWriter;
import java.nio.ByteBuffer;
import org.w3c.dom.Element;

class CRMediaDirEntry
extends CapacityRuleAbstractElement {
    static final String TAG_ATTRIBUTE_NAME = "media";
    static final String TAG_ATTRIBUTE_PRIORITY = "priority";
    private int mediaType = -1;
    private CRRuleBlock ruleBlock;
    private CRMediaDir parent;
    private String mediaName;

    public CRMediaDirEntry(CRMediaDir parent) {
        this.parent = parent;
    }

    public CRMediaDirEntry(CRMediaDir parent, ICapacityRuleReader reader, Element element) {
        String attrNValue = element.getAttribute(TAG_ATTRIBUTE_NAME);
        this.parent = parent;
        this.mediaName = attrNValue != null ? attrNValue : "";
        this.ruleBlock = new CRRuleBlock(this, reader, element);
    }

    public CRMediaDirEntry(CRMediaDir parent, int mediaType, ByteBuffer buf, int positionBase) throws CapacityRuleException {
        this(parent);
        this.setMediType(mediaType);
        this.read(buf, positionBase);
    }

    public Object getParent() {
        return this.parent;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public void addNewRuleBlock(ICapacityRuleReader reader, Element element) {
        if (this.ruleBlock != null) {
            this.ruleBlock.addNewRule(reader, element);
        }
    }

    public void updateMediaMapType(CRMediaMap map) throws CapacityRuleException {
        if (this.mediaName != null) {
            this.mediaType = map.getMediaType(this.mediaName);
        } else {
            if (this.mediaType == -1) {
                throw new CapacityRuleException("undefined media dir entry media type");
            }
            try {
                this.mediaName = map.getEntries().get(this.mediaType).getMediaName();
            }
            catch (Throwable e) {
                throw new CapacityRuleException("invalid media dir entry media type: " + this.mediaType);
            }
        }
    }

    public void process(CRMediaMap map) throws CapacityRuleException {
        if (map == null) {
            return;
        }
        if (this.ruleBlock != null) {
            this.ruleBlock.process(map);
        }
    }

    public void write(ICapacityRuleWriter writer) {
        if (this.ruleBlock == null) {
            return;
        }
        this.ruleBlock.write(writer);
    }

    private void read(ByteBuffer buf, int positionBase) throws CapacityRuleException {
        this.ruleBlock = new CRRuleBlock(this, buf, positionBase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[MediaDir:");
        sb.append(this.mediaName);
        sb.append("]\n");
        if (this.ruleBlock != null) {
            sb.append(this.ruleBlock).append("\n");
        }
        return sb.toString();
    }

    public static CRMediaDirEntry create(CRMediaDir parent, ICapacityRuleReader reader, Element element) {
        String attrNValue = element.getAttribute(TAG_ATTRIBUTE_NAME);
        if (attrNValue == null) {
            return null;
        }
        return new CRMediaDirEntry(parent, reader, element);
    }

    void setMediType(int mediaType) {
        this.mediaType = mediaType;
    }

    public CRRuleBlock getRuleBlock() {
        return this.ruleBlock;
    }

    public int hashCode() {
        int hashCode = CRMediaDirEntry.class.hashCode();
        hashCode = hashCode * 31 + this.mediaType;
        if (this.ruleBlock != null) {
            hashCode = hashCode * 31 + this.ruleBlock.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRMediaDirEntry)) {
            return false;
        }
        CRMediaDirEntry o = (CRMediaDirEntry)obj;
        CRMediaMap map = this.getMap();
        CRMediaMap map2 = o.getMap();
        if (map != null && map2 != null && map != map2) {
            String mediaName1 = map.getEntries().get(this.mediaType).getMediaName();
            String mediaName2 = map2.getEntries().get(o.mediaType).getMediaName();
            if (mediaName1 == null || mediaName2 == null) {
                return false;
            }
            if (!mediaName1.equals(mediaName2)) {
                return false;
            }
        } else if (this.mediaType != o.mediaType) {
            return false;
        }
        return this.ruleBlock == null ? o.ruleBlock == null : this.ruleBlock.equals(o.ruleBlock);
    }

    public CRMediaMap getMap() {
        return this.parent == null ? null : this.parent.getMap();
    }

    public boolean match(CRMediaDirEntry entry) {
        if (entry == null) {
            return false;
        }
        CRMediaMap map = this.getMap();
        CRMediaMap map2 = entry.getMap();
        if (map != null && map2 != null && map != map2) {
            String mediaName1 = map.getEntries().get(this.mediaType).getMediaName();
            String mediaName2 = map2.getEntries().get(entry.mediaType).getMediaName();
            if (mediaName1 == null || mediaName2 == null) {
                return false;
            }
            if (!mediaName1.equals(mediaName2)) {
                return false;
            }
        } else if (this.mediaType != entry.mediaType) {
            return false;
        }
        return this.ruleBlock == null ? entry.ruleBlock == null : this.ruleBlock.match(entry.ruleBlock);
    }
}

