/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.capacityrules;

import com.genesyslab.platform.applicationblocks.com.capacityrules.AbstractRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRAndExprBlock;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRHeader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDir;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaDirEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMap;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRMediaMapEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBlockEntry;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRRuleBody;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CRXmlUtils;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.CapacityRuleException;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ComplexCondition;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ElementaryRule;
import com.genesyslab.platform.applicationblocks.com.capacityrules.EnterElementArgs;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleProcessElement;
import com.genesyslab.platform.applicationblocks.com.capacityrules.ICapacityRuleReader;
import com.genesyslab.platform.applicationblocks.com.capacityrules.LeaveElementArgs;
import com.genesyslab.platform.applicationblocks.com.capacityrules.OnExpandAnyHandler;
import com.genesyslab.platform.applicationblocks.com.capacityrules.OnMediaRuleChanged;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MediaRule<it>
implements ICapacityRuleProcessElement {
    private static final ILogger log = Log.getLogger(CapacityRule.class);
    private static final boolean DEBUG = false;
    static final String ELEMENTARY_RULE_NAME = "ElementaryRule";
    static final String COMPLEX_CONDITION_NMAE = "ComplexCondition";
    private OnMediaRuleChanged OnRuleChanged;
    private ICapacityRuleReader reader;
    private AbstractRule Rule;
    private AbstractRule OriginalRule;
    private AbstractRule CurrentRule;
    private CRRuleBlockEntry parent;

    public MediaRule(ICapacityRuleReader reader, CRRuleBlockEntry parent) {
        this.parent = parent;
        this.reader = reader;
        reader.registerProcessElement(this);
    }

    public MediaRule(CRRuleBlockEntry parent, CRRuleBody ruleBody) throws CapacityRuleException {
        this.parent = parent;
        this.read(ruleBody);
    }

    private void read(CRRuleBody ruleBody) throws CapacityRuleException {
        ComplexCondition rule = new ComplexCondition(null, ComplexCondition.ConditionType.OR);
        for (CRAndExprBlock expr : ruleBody.getList()) {
            rule.add(expr);
        }
        this.Rule = this.OriginalRule = rule;
        this.createRuleBody();
    }

    @Override
    public void onProcessElement(Object sender, Object args) throws CapacityRuleException {
        LeaveElementArgs eArgs;
        Element elem;
        if (args instanceof EnterElementArgs) {
            EnterElementArgs eArgs2 = (EnterElementArgs)args;
            Element elem2 = eArgs2.getElement();
            if (elem2 != null) {
                AbstractRule rule;
                String localName = CRXmlUtils.getLocalName(elem2);
                if (localName.equalsIgnoreCase(ELEMENTARY_RULE_NAME)) {
                    if (this.Rule == null) {
                        this.Rule = this.CurrentRule = new ComplexCondition(null, ComplexCondition.ConditionType.OR);
                    }
                    rule = new ElementaryRule(this.CurrentRule, elem2);
                    if (this.CurrentRule instanceof ComplexCondition) {
                        rule.registerOnExpandAny(new OnExpandAnyHandler(){

                            public void onExpandAnyHandler(AbstractRule source, CRMediaMap map, int capacity) throws CapacityRuleException {
                                ComplexCondition newRule = (ComplexCondition)source.getParent();
                                CRHeader mapParent = map.getParent();
                                if (!(mapParent instanceof CRHeader)) {
                                    return;
                                }
                                CRHeader header = mapParent;
                                CRMediaDir mediaDir = header.getMediaDir();
                                if (mediaDir == null) {
                                    return;
                                }
                                List<CRMediaDirEntry> entries = mediaDir.getEntries();
                                if (entries == null) {
                                    return;
                                }
                                if (newRule.getCondition() == ComplexCondition.ConditionType.OR) {
                                    for (CRMediaDirEntry entry : entries) {
                                        newRule.addRule(new ElementaryRule(newRule, entry.getMediaName(), entry.getMediaType(), capacity));
                                    }
                                    newRule.removeRule(source);
                                } else if (newRule.getCondition() == ComplexCondition.ConditionType.AND) {
                                    ComplexCondition addRule = new ComplexCondition((AbstractRule)newRule, ComplexCondition.ConditionType.OR);
                                    for (CRMediaDirEntry entry : entries) {
                                        addRule.addRule(new ElementaryRule(newRule, entry.getMediaName(), entry.getMediaType(), capacity));
                                    }
                                    newRule.removeRule(source);
                                    newRule.addRule(addRule);
                                }
                            }
                        });
                        ((ComplexCondition)this.CurrentRule).addRule(rule);
                    }
                }
                if (localName.equalsIgnoreCase(COMPLEX_CONDITION_NMAE)) {
                    rule = new ComplexCondition(this.CurrentRule, elem2);
                    if (this.Rule == null) {
                        this.Rule = this.CurrentRule = rule;
                    } else if (this.CurrentRule instanceof ComplexCondition) {
                        ((ComplexCondition)this.CurrentRule).addRule(rule);
                        this.CurrentRule = rule;
                    }
                }
            }
        } else if (args instanceof LeaveElementArgs && (elem = (eArgs = (LeaveElementArgs)args).getElement()) != null) {
            String localName = CRXmlUtils.getLocalName(elem);
            if (localName.equalsIgnoreCase(COMPLEX_CONDITION_NMAE)) {
                if (this.CurrentRule == null) {
                    throw new CapacityRuleException("Capacity rule contains wrong MediaRule");
                }
                this.CurrentRule = this.CurrentRule.getParent();
            }
            if (localName.equalsIgnoreCase("MediaRule") && sender instanceof ICapacityRuleReader) {
                ((ICapacityRuleReader)sender).unregisterProcessElement(this);
            }
        }
    }

    public void setOnRuleChanged(OnMediaRuleChanged onChanged) {
        this.OnRuleChanged = onChanged;
    }

    public CRRuleBody process(CRMediaMap map) throws CapacityRuleException {
        if (this.Rule == null) {
            return null;
        }
        this.Rule.assignMediaTypes(map);
        this.OriginalRule = this.Rule;
        this.Rule.expandAny(map);
        if (this.Rule instanceof ComplexCondition) {
            this.Rule = this.transformRule();
        }
        return this.createRuleBody();
    }

    private CRRuleBody createRuleBody() throws CapacityRuleException {
        if (this.Rule == null) {
            return null;
        }
        this.convertStructure();
        return this.Rule.createBinaryStructure(this.parent);
    }

    private void convertStructure() {
        if (!this.isRuleMappedToDNF(this.Rule, 0)) {
            return;
        }
        ComplexCondition crule = ComplexCondition.castOrNull(this.Rule);
        if (crule == null || crule.getCondition() != ComplexCondition.ConditionType.OR) {
            this.Rule = new ComplexCondition(null, ComplexCondition.ConditionType.OR).addRule(this.Rule);
        }
    }

    private boolean isRuleMappedToDNF(AbstractRule rule) {
        return this.isRuleMappedToDNF(rule, 0);
    }

    private boolean isRuleMappedToDNF(AbstractRule rule, int level) {
        switch (level) {
            case 0: {
                if (rule instanceof ComplexCondition) {
                    ComplexCondition cRule = (ComplexCondition)rule;
                    for (AbstractRule childRule : cRule.getChildRules()) {
                        if (this.isRuleMappedToDNF(childRule, level + 1)) continue;
                        return false;
                    }
                }
                return true;
            }
            case 1: {
                if (rule instanceof ComplexCondition) {
                    ComplexCondition cRule = (ComplexCondition)rule;
                    AbstractRule cParent = cRule.getParent();
                    if (cParent == null) {
                        return false;
                    }
                    if (((ComplexCondition)cParent).getCondition() != ComplexCondition.ConditionType.OR) {
                        return false;
                    }
                    if (cRule.getCondition() != ComplexCondition.ConditionType.AND) {
                        return false;
                    }
                    for (AbstractRule childRule : cRule.getChildRules()) {
                        if (this.isRuleMappedToDNF(childRule, level + 1)) continue;
                        return false;
                    }
                }
                return true;
            }
            case 2: {
                return !(rule instanceof ComplexCondition);
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.Rule != null) {
            sb.append(this.Rule);
        }
        if (this.OriginalRule != null) {
            sb.append("   <=   ");
            sb.append(this.OriginalRule);
        }
        return sb.toString();
    }

    private void invokeEvent(String header, AbstractRule rule) {
        if (this.OnRuleChanged == null) {
            return;
        }
        this.OnRuleChanged.onRuleChanged(header, rule);
    }

    private void invokeEvent(String header, AbstractRule rule, String sourceRuleInfo) {
        if (this.OnRuleChanged == null) {
            return;
        }
        this.OnRuleChanged.onRuleChanged(header, rule);
    }

    private void prepareStructure() {
        if (this.Rule instanceof ElementaryRule) {
            ComplexCondition newRule = new ComplexCondition(null, ComplexCondition.ConditionType.OR);
            newRule.addRule(this.Rule);
            this.Rule = newRule;
        }
    }

    private AbstractRule transformRule() {
        AbstractRule newRule;
        this.invokeEvent("Source rule", this.Rule);
        this.prepareStructure();
        try {
            newRule = (AbstractRule)this.Rule.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        this.invokeEvent("Clone rule", this.Rule);
        boolean ruleChanged = false;
        AbstractRule modifiedRule = this.reduceRule(newRule);
        if (modifiedRule != null) {
            ruleChanged = true;
            newRule = modifiedRule;
        }
        if (!this.isRuleMappedToDNF(newRule)) {
            boolean needTransform = true;
            while (needTransform) {
                boolean result = false;
                modifiedRule = this.distributeRule(newRule);
                if (modifiedRule != null) {
                    result = true;
                    newRule = modifiedRule;
                }
                if ((modifiedRule = this.reduceRule(newRule)) != null) {
                    result = true;
                    newRule = modifiedRule;
                }
                needTransform = result && !this.isRuleMappedToDNF(newRule);
                ruleChanged |= result;
            }
        }
        if (ruleChanged) {
            this.Rule = newRule;
        }
        this.invokeEvent("Out rule", this.Rule);
        this.invokeEvent(null, null);
        return this.Rule;
    }

    private AbstractRule distributeRule(AbstractRule rule) {
        AbstractRule modifiedRule;
        boolean result = this.transformByDistributeRule(rule);
        if (result && (modifiedRule = this.simplifyRule(rule)) != null) {
            rule = modifiedRule;
        }
        return result ? rule : null;
    }

    private boolean transformByDistributeRule(AbstractRule rule) {
        int i;
        if (!(rule instanceof ComplexCondition)) {
            return false;
        }
        ComplexCondition baseRule = (ComplexCondition)rule;
        ComplexCondition.ConditionType baseRuleContrCondition = baseRule.getContrCondition();
        if (baseRuleContrCondition == null) {
            return false;
        }
        ComplexCondition.ConditionType baseRuleCondition = baseRule.getCondition();
        ArrayList<AbstractRule> baseChildRules = baseRule.getChildRules();
        if (baseChildRules == null) {
            return false;
        }
        String sourceRuleInfo = null;
        int baseChildCount = baseChildRules.size();
        int contrChildRulesCount = 0;
        int contrChildRule1st = -1;
        int[] contrChildRulesIndexes = null;
        for (int i2 = 0; i2 < baseChildCount; ++i2) {
            AbstractRule childRule = baseChildRules.get(i2);
            if (!(childRule instanceof ComplexCondition) || ((ComplexCondition)childRule).getContrCondition() != baseRuleCondition) continue;
            if (contrChildRulesIndexes == null) {
                if (contrChildRule1st == -1) {
                    contrChildRule1st = i2;
                    ++contrChildRulesCount;
                    continue;
                }
                contrChildRulesIndexes = new int[baseChildCount - i2 + 1];
                contrChildRulesIndexes[0] = contrChildRule1st;
                contrChildRulesIndexes[contrChildRulesCount++] = i2;
                continue;
            }
            contrChildRulesIndexes[contrChildRulesCount++] = i2;
        }
        if (contrChildRulesCount == 0) {
            return false;
        }
        if (contrChildRulesCount == 1) {
            int i3;
            ComplexCondition child = (ComplexCondition)baseChildRules.get(contrChildRule1st);
            ArrayList<AbstractRule> childRules = child.getChildRules();
            int childRulesCount = childRules.size();
            if (childRules == null || childRulesCount == 0) {
                return false;
            }
            baseRule.setCondition(baseRuleContrCondition);
            AbstractRule[] tmpBaseChildRules = new AbstractRule[childRulesCount];
            for (i3 = 0; i3 < childRulesCount; ++i3) {
                AbstractRule childRule = childRules.get(i3);
                ComplexCondition tRule = new ComplexCondition((AbstractRule)baseRule, baseRuleCondition);
                tRule.addRule(childRule);
                for (int j = 0; j < baseChildCount; ++j) {
                    AbstractRule elemRule = baseChildRules.get(j);
                    ComplexCondition crule = ComplexCondition.castOrNull(elemRule);
                    if (crule != null && crule.getCondition() != baseRuleCondition) continue;
                    tRule.addRule(elemRule);
                }
                tmpBaseChildRules[i3] = tRule;
            }
            baseChildRules.clear();
            for (i3 = 0; i3 < childRulesCount; ++i3) {
                baseChildRules.add(tmpBaseChildRules[i3]);
            }
            this.invokeEvent("Distribution rule", rule, sourceRuleInfo);
            return true;
        }
        int elemRulesCount = 0;
        int[] elemRulesIndexes = null;
        for (int i4 = 0; i4 < baseChildCount; ++i4) {
            AbstractRule childRule = baseChildRules.get(i4);
            if (childRule instanceof ElementaryRule) {
                if (elemRulesIndexes == null) {
                    elemRulesIndexes = new int[baseChildCount - i4];
                }
                elemRulesIndexes[elemRulesCount++] = i4;
                continue;
            }
            if (!(childRule instanceof ComplexCondition) || ((ComplexCondition)childRule).getCondition() != baseRuleCondition) continue;
            if (elemRulesIndexes == null) {
                elemRulesIndexes = new int[baseChildCount - i4];
            }
            elemRulesIndexes[elemRulesCount++] = i4;
        }
        baseRule.setCondition(baseRuleContrCondition);
        ArrayList<ComplexCondition> tmpNewBaseChildRules = new ArrayList<ComplexCondition>(1024);
        for (i = 0; i < contrChildRulesCount - 1; ++i) {
            for (int j = i + 1; j < contrChildRulesCount; ++j) {
                ComplexCondition child1 = (ComplexCondition)baseChildRules.get(contrChildRulesIndexes[i]);
                ComplexCondition child2 = (ComplexCondition)baseChildRules.get(contrChildRulesIndexes[j]);
                ArrayList<AbstractRule> childRules1 = child1.getChildRules();
                ArrayList<AbstractRule> childRules2 = child2.getChildRules();
                if (childRules1 == null || childRules2 == null) continue;
                int childRules1Count = childRules1.size();
                int childRules2Count = childRules2.size();
                for (int i1 = 0; i1 < childRules1Count; ++i1) {
                    AbstractRule rule1 = childRules1.get(i1);
                    for (int i2 = 0; i2 < childRules2Count; ++i2) {
                        int k;
                        AbstractRule rule2 = childRules2.get(i2);
                        ComplexCondition tcRule = new ComplexCondition((AbstractRule)baseRule, baseRuleCondition);
                        tcRule.addRule(rule1);
                        tcRule.addRule(rule2);
                        for (k = 0; k < elemRulesCount; ++k) {
                            AbstractRule elemRule = baseChildRules.get(elemRulesIndexes[k]);
                            tcRule.addRule(elemRule);
                        }
                        for (k = 0; k < baseChildCount; ++k) {
                            if (k == contrChildRulesIndexes[i] || k == contrChildRulesIndexes[j]) continue;
                            tcRule.addRule(baseChildRules.get(k));
                        }
                        AbstractRule tmpRule = tcRule;
                        AbstractRule modifiedRule = this.reduceRule(tmpRule);
                        if (modifiedRule != null) {
                            tmpRule = modifiedRule;
                        }
                        this.transformByDistributeRule(tmpRule);
                        modifiedRule = this.reduceRule(tmpRule);
                        if (modifiedRule != null) {
                            tmpRule = modifiedRule;
                        }
                        tmpNewBaseChildRules.add((ComplexCondition)tmpRule);
                    }
                }
            }
        }
        baseChildRules.clear();
        for (i = 0; i < tmpNewBaseChildRules.size(); ++i) {
            baseChildRules.add((AbstractRule)tmpNewBaseChildRules.get(i));
        }
        this.invokeEvent("Distribution rule", rule, sourceRuleInfo);
        return true;
    }

    private AbstractRule simplifyRule(AbstractRule rule) {
        if (!(rule instanceof ComplexCondition)) {
            return null;
        }
        String sourceRuleInfo = null;
        ComplexCondition complexRule = (ComplexCondition)rule;
        ArrayList<AbstractRule> childRules = complexRule.getChildRules();
        if (childRules == null) {
            return null;
        }
        if (childRules.size() == 1) {
            AbstractRule childRule = childRules.get(0);
            AbstractRule simplifiedChildRule = this.simplifyRule(childRule);
            if (simplifiedChildRule != null) {
                childRule = simplifiedChildRule;
            }
            this.invokeEvent("Simplify rule", childRule, sourceRuleInfo);
            return childRule;
        }
        boolean simplified = false;
        int childCount = childRules.size();
        for (int i = 0; i < childCount; ++i) {
            AbstractRule childRule = childRules.get(i);
            AbstractRule simplifiedChildRule = this.simplifyRule(childRule);
            if (simplifiedChildRule == null) continue;
            if (!simplified) {
                simplified = true;
            }
            childRules.set(i, simplifiedChildRule);
        }
        if (simplified) {
            this.invokeEvent("Simplify rule", rule, sourceRuleInfo);
        }
        return simplified ? rule : null;
    }

    private AbstractRule reduceRule(AbstractRule rule) {
        boolean needTransform = true;
        boolean ruleChanged = false;
        while (needTransform) {
            boolean result = false;
            AbstractRule modifiedRule = this.simplifyRule(rule);
            if (modifiedRule != null) {
                result = true;
                rule = modifiedRule;
            }
            if ((modifiedRule = this.transformByAssociativeRule(rule)) != null) {
                result = true;
                rule = modifiedRule;
            }
            if ((modifiedRule = this.transformByIdempotencyRule(rule)) != null) {
                result = true;
                rule = modifiedRule;
            }
            if ((modifiedRule = this.simplifyRule(rule)) != null) {
                result = true;
                rule = modifiedRule;
            }
            if ((modifiedRule = this.transformByAbsorbtionRule(rule)) != null) {
                result = true;
                rule = modifiedRule;
            }
            if ((modifiedRule = this.simplifyRule(rule)) != null) {
                result = true;
                rule = modifiedRule;
            }
            needTransform = result;
            ruleChanged |= result;
        }
        return ruleChanged ? rule : null;
    }

    private AbstractRule transformByIdempotencyRule(AbstractRule rule) {
        int index;
        ComplexCondition complexRule = ComplexCondition.castOrNull(rule);
        if (complexRule == null) {
            return null;
        }
        boolean result = false;
        ArrayList<AbstractRule> childRules = complexRule.getChildRules();
        if (childRules == null) {
            return null;
        }
        String sourceRuleInfo = null;
        int count = childRules.size();
        for (int i = 0; i < count; ++i) {
            AbstractRule childRule = childRules.get(i);
            AbstractRule modifiedRule = this.transformByIdempotencyRule(childRule);
            if (null == modifiedRule) continue;
            result = true;
            childRule = modifiedRule;
            if ((modifiedRule = this.simplifyRule(childRule)) != null) {
                childRule = modifiedRule;
            }
            childRules.set(i, childRule);
        }
        ComplexCondition.ConditionType condition = complexRule.getCondition();
        while ((index = this.findImpodency(childRules, condition)) >= 0) {
            result = true;
            complexRule.removeRule(index);
        }
        if (result) {
            this.invokeEvent("Impodency rule", rule, sourceRuleInfo);
        }
        return result ? rule : null;
    }

    private int findImpodency(List<AbstractRule> childs, ComplexCondition.ConditionType condition) {
        int childCount = childs.size();
        for (int i = 0; i < childCount - 1; ++i) {
            ElementaryRule rule1 = ElementaryRule.castOrNull(childs.get(i));
            if (rule1 == null) continue;
            for (int j = i + 1; j < childCount; ++j) {
                ElementaryRule rule2 = ElementaryRule.castOrNull(childs.get(j));
                if (rule2 == null || rule1.getMediaType() != rule2.getMediaType()) continue;
                int capacity2 = rule2.getCapacity();
                int capacity1 = rule1.getCapacity();
                if (condition == ComplexCondition.ConditionType.OR) {
                    return capacity2 > capacity1 ? j : i;
                }
                if (condition != ComplexCondition.ConditionType.AND) continue;
                return capacity2 < capacity1 ? j : i;
            }
        }
        return -1;
    }

    private AbstractRule transformByAssociativeRule(AbstractRule rule) {
        ComplexCondition baseRule = ComplexCondition.castOrNull(rule);
        if (baseRule == null) {
            return null;
        }
        String sourceRuleInfo = null;
        boolean result = false;
        ComplexCondition.ConditionType baseCondition = baseRule.getCondition();
        ArrayList<AbstractRule> baseChildRules = baseRule.getChildRules();
        int baseChildCount = baseChildRules.size();
        for (int i = baseChildCount - 1; i >= 0; --i) {
            AbstractRule baseChild = baseChildRules.get(i);
            ComplexCondition complexChild = ComplexCondition.castOrNull(baseChild);
            if (complexChild == null) continue;
            AbstractRule modifiedRule = this.transformByAssociativeRule(complexChild);
            if (modifiedRule != null) {
                result = true;
            }
            if (complexChild.getCondition() != baseCondition) continue;
            baseRule.removeRule(i);
            ArrayList<AbstractRule> childRules2 = complexChild.getChildRules();
            int childRules2Count = childRules2.size();
            for (int j = 0; j < childRules2Count; ++j) {
                AbstractRule child2 = childRules2.get(j);
                baseRule.addRule(child2);
            }
            result = true;
        }
        if (result) {
            this.invokeEvent("Associavive rule", rule, sourceRuleInfo);
        }
        return result ? rule : null;
    }

    private AbstractRule transformByAbsorbtionRule(AbstractRule rule) {
        ComplexCondition baseRule = ComplexCondition.castOrNull(rule);
        if (baseRule == null) {
            return null;
        }
        String sourceRuleInfo = null;
        boolean result = false;
        ArrayList<AbstractRule> baseChildRules = baseRule.getChildRules();
        int baseChildRulesCount = baseChildRules.size();
        for (int i = 0; i < baseChildRulesCount; ++i) {
            AbstractRule baseChild = baseChildRules.get(i);
            AbstractRule modifiedRule = this.transformByAbsorbtionRule(baseChild);
            if (modifiedRule == null) continue;
            result = true;
            baseChild = modifiedRule;
            if ((modifiedRule = this.simplifyRule(baseChild)) != null) {
                baseChild = modifiedRule;
            }
            baseChildRules.set(i, baseChild);
        }
        while (true) {
            boolean lResult = false;
            ComplexCondition.ConditionType baseCondition = baseRule.getCondition();
            int index = this.findAbsorbtion(baseChildRules, baseCondition);
            if (index >= 0) {
                lResult = true;
                baseRule.removeRule(index);
            }
            if ((index = this.findAbsorbtion2(baseChildRules, baseCondition)) >= 0) {
                lResult = true;
                baseRule.removeRule(index);
            }
            if (!lResult) break;
            result = true;
        }
        if (result) {
            this.invokeEvent("Absorbtion rule", rule, sourceRuleInfo);
        }
        return result ? rule : null;
    }

    private int findAbsorbtion(ArrayList<AbstractRule> childs, ComplexCondition.ConditionType condition) {
        int childCount = childs.size();
        for (int i = childCount - 1; i >= 0; --i) {
            ElementaryRule rule1 = ElementaryRule.castOrNull(childs.get(i));
            if (rule1 == null) continue;
            int mediaType1 = rule1.getMediaType();
            int capacity1 = rule1.getCapacity();
            for (int j = childCount - 1; j >= 0; --j) {
                ComplexCondition complexRule;
                if (i == j || (complexRule = ComplexCondition.castOrNull(childs.get(j))) == null) continue;
                ArrayList<AbstractRule> complexChildRules = complexRule.getChildRules();
                int complexChildRulesCount = complexChildRules.size();
                for (int k = 0; k < complexChildRulesCount; ++k) {
                    ElementaryRule rule2 = ElementaryRule.castOrNull(complexChildRules.get(k));
                    if (rule2 == null || mediaType1 != rule2.getMediaType()) continue;
                    int capacity2 = rule2.getCapacity();
                    if (condition == ComplexCondition.ConditionType.OR && capacity1 <= capacity2) {
                        return j;
                    }
                    if (condition != ComplexCondition.ConditionType.AND || capacity1 < capacity2) continue;
                    return j;
                }
            }
        }
        return -1;
    }

    private int findAbsorbtion2(ArrayList<AbstractRule> childs, ComplexCondition.ConditionType condition) {
        if (condition == ComplexCondition.ConditionType.OR) {
            return this.findAbsorbtion2Or(childs);
        }
        return -1;
    }

    private int findAbsorbtion2Or(ArrayList<AbstractRule> childs) {
        int childCount = childs.size();
        for (int i = 0; i < childCount; ++i) {
            ComplexCondition cRule1 = ComplexCondition.castOrNull(childs.get(i));
            if (cRule1 == null || cRule1.getChildRules().size() == 0) continue;
            ArrayList<AbstractRule> cChildRules1 = cRule1.getChildRules();
            int cChildRulesCount1 = cChildRules1.size();
            for (int j = 0; j < childCount; ++j) {
                ArrayList<AbstractRule> cChildRules2;
                int cChildRulesCount2;
                ComplexCondition cRule2;
                if (i == j || (cRule2 = ComplexCondition.castOrNull(childs.get(j))) == null || (cChildRulesCount2 = (cChildRules2 = cRule2.getChildRules()).size()) == 0) continue;
                ArrayList cChildRules1Clone = (ArrayList)cChildRules1.clone();
                for (int i1 = cChildRulesCount1 - 1; i1 >= 0; --i1) {
                    ElementaryRule rule1 = ElementaryRule.castOrNull(cChildRules1.get(i1));
                    if (rule1 == null) continue;
                    int mediaType1 = rule1.getMediaType();
                    int capacity1 = rule1.getCapacity();
                    for (int i2 = cChildRulesCount2 - 1; i2 >= 0; --i2) {
                        ElementaryRule rule2 = ElementaryRule.castOrNull(cChildRules2.get(i2));
                        if (rule2 == null || mediaType1 != rule2.getMediaType() || capacity1 > rule2.getCapacity()) continue;
                        cChildRules1Clone.remove(rule1);
                    }
                }
                if (cChildRules1Clone.size() != 0) continue;
                return j;
            }
        }
        return -1;
    }

    boolean validateRule(CRMediaMap map) {
        int index;
        List<CRMediaMapEntry> entries = map.getEntries();
        int entriesCount = entries.size();
        if (entriesCount == 0) {
            return false;
        }
        byte[] values = new byte[entriesCount];
        block0: do {
            boolean cValue;
            boolean oValue;
            if ((oValue = this.OriginalRule.calculate(values)) != (cValue = this.Rule.calculate(values))) {
                if (log.isError()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Error in rule optimization. ");
                    for (int j = 0; j < entriesCount; ++j) {
                        sb.append(MessageFormat.format("'{0}'={1} ", entries.get(j).getMediaName(), values[j]));
                    }
                    sb.append(MessageFormat.format(" |  Original value = {0}, New value = {1}\n", oValue, cValue));
                    log.error((Object)sb);
                }
                return false;
            }
            for (index = entriesCount - 1; index >= 0; --index) {
                int v = values[index] & 0xFF;
                int maxCapacity = entries.get((int)index).MaxCapacity;
                if (v < maxCapacity) {
                    int n = index;
                    values[n] = (byte)(values[n] + 1);
                    continue block0;
                }
                values[index] = 0;
            }
        } while (index >= 0);
        return true;
    }

    public boolean match(MediaRule mediaRule) {
        int index;
        CRMediaMap map1 = this.parent.getMap();
        CRMediaMap map2 = mediaRule.parent.getMap();
        List<CRMediaMapEntry> entries1 = map1.getEntries();
        int entriesCount = entries1.size();
        if (entriesCount == 0) {
            return true;
        }
        List<CRMediaMapEntry> entries2 = map2.getEntries();
        HashMap<String, Integer> smap2 = map2.getSimpleMediaMap();
        byte[] values1 = new byte[entriesCount];
        byte[] values2 = new byte[entriesCount];
        int[] v2table = new int[entriesCount];
        for (int i1 = 0; i1 < entriesCount; ++i1) {
            v2table[i1] = smap2.get(map1.getEntries().get(i1).getMediaName());
        }
        block1: do {
            boolean oValue1 = this.OriginalRule.calculate(values1);
            for (int i1 = 0; i1 < entriesCount; ++i1) {
                values2[v2table[i1]] = values1[i1];
            }
            boolean oValue2 = mediaRule.OriginalRule.calculate(values2);
            if (oValue1 != oValue2) {
                if (log.isDebug()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Mismatch between rules");
                    for (int j = 0; j < entriesCount; ++j) {
                        sb.append(MessageFormat.format("'{0}'={1} ", entries1.get(j).getMediaName(), values1[j]));
                    }
                    sb.append(MessageFormat.format(" |  value = {0}, other value = {1}\n", oValue1, oValue2));
                    log.debug((Object)sb);
                }
                return false;
            }
            for (index = entriesCount - 1; index >= 0; --index) {
                int v = values1[index] & 0xFF;
                CRMediaMapEntry media = entries1.get(index);
                int maxCapacity = Math.max(media.MaxCapacity, entries2.get((int)smap2.get((Object)media.getMediaName()).intValue()).MaxCapacity);
                if (v < maxCapacity) {
                    int n = index;
                    values1[n] = (byte)(values1[n] + 1);
                    continue block1;
                }
                values1[index] = 0;
            }
        } while (index >= 0);
        return true;
    }
}

