/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.runtime;

import com.genesyslab.platform.applicationblocks.com.AsyncRequestResult;
import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.applicationblocks.com.ConfigRuntimeException;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.ICfgQuery;
import com.genesyslab.platform.applicationblocks.com.runtime.EventService;
import com.genesyslab.platform.applicationblocks.commons.Action;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.timer.Scheduler;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsyncRequestResultImpl<T extends ICfgObject>
implements AsyncRequestResult<T> {
    private ICfgQuery query;
    private Message requestMessage;
    private Class<T> objClass;
    private Action<Collection<T>> dataCallback;
    private Action<AsyncRequestResult<T>> finishCallback;
    private AsyncInvoker callbackAsyncInvoker;
    private TimerAction timeoutTask = null;
    private long timeout;
    private TimerActionTicket timeoutTicket = null;
    private List<Message> incomings = new ArrayList<Message>();
    private Collection<T> resultSet = null;
    private Exception exception = null;
    private boolean isDone = false;
    private boolean isCanceled = false;
    private boolean isCompletedSync = false;
    private final Object lockObject = new Object();
    private final ILogger log = Log.getLogger(EventService.class);

    public AsyncRequestResultImpl(Class<T> clazz, ICfgQuery origQuery, Message rqMessage, Action<Collection<T>> dataCallback, Action<AsyncRequestResult<T>> finishCallback, AsyncInvoker callbackInvoker, long timeout) {
        this.objClass = clazz;
        this.query = origQuery;
        this.requestMessage = rqMessage;
        this.dataCallback = dataCallback;
        this.finishCallback = finishCallback;
        this.callbackAsyncInvoker = callbackInvoker;
        this.timeout = timeout;
        if (callbackInvoker == null && (dataCallback != null || finishCallback != null)) {
            throw new NullPointerException("callbackAsyncInvoker");
        }
    }

    public AsyncRequestResultImpl(Class<T> clazz, ICfgQuery origQuery, Collection<T> objects, Action<Collection<T>> dataCallback, Action<AsyncRequestResult<T>> finishCallback, AsyncInvoker callbackInvoker) {
        this(clazz, origQuery, null, dataCallback, finishCallback, callbackInvoker, 0L);
        this.isCompletedSync = true;
        this.addToResultSet(objects);
        this.finishResultSet();
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public boolean isFailed() {
        return this.isDone() && this.exception != null || this.isCancelled();
    }

    @Override
    public boolean isCompletedSynchronously() {
        return this.isCompletedSync;
    }

    public void setCompletedSynchronously(boolean val) {
        this.isCompletedSync = val;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.isDone()) {
                return false;
            }
            this.isCanceled = true;
            this.setException(new CancellationException("Request has been canceled"));
            return true;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> partialGet() {
        ArrayList<T> data = null;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.resultSet != null) {
                data = new ArrayList<T>();
                if (this.resultSet.size() != 0) {
                    data.addAll(this.resultSet);
                }
            }
        }
        return data;
    }

    @Override
    public Collection<T> get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException tex) {
            throw new ExecutionException(tex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object object = this.lockObject;
        synchronized (object) {
            long tmt = timeout;
            if (unit != null) {
                tmt = unit.toMillis(timeout);
            }
            if (tmt > 0L) {
                long timeoutMark = System.currentTimeMillis() + tmt;
                long waitTime = tmt;
                while (!this.isDone()) {
                    this.lockObject.wait(waitTime);
                    waitTime = timeoutMark - System.currentTimeMillis();
                    if (waitTime > 0L) continue;
                    break;
                }
            } else {
                while (!this.isDone()) {
                    this.lockObject.wait();
                }
            }
            if (!this.isDone()) {
                throw new TimeoutException("No response got in given timeframe");
            }
        }
        if (this.isFailed()) {
            if (this.exception != null) {
                if (this.exception instanceof CancellationException) {
                    throw (CancellationException)this.exception;
                }
                throw new ExecutionException(this.exception);
            }
            throw new ExecutionException(new ConfigException("Configuration reading is failed"));
        }
        return this.resultSet;
    }

    Class<T> getObjectClass() {
        return this.objClass;
    }

    ICfgQuery getQuery() {
        return this.query;
    }

    Message getRequestMessage() {
        return this.requestMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeoutAction(TimerAction action) {
        Object object = this.lockObject;
        synchronized (object) {
            this.timeoutTask = action;
            this.resetTimeoutTask(true);
        }
    }

    List<Message> getResponses() {
        return this.incomings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToResultSet(Collection<T> value) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.isDone()) {
                throw new ConfigRuntimeException("AsyncRequestResult is already finished");
            }
            if (this.resultSet == null) {
                this.resultSet = value;
            } else {
                this.resultSet.addAll(value);
            }
            this.resetTimeoutTask(true);
            if (this.dataCallback != null) {
                this.callbackAsyncInvoker.invoke(new AsyncNotifier<Collection<T>>(this.dataCallback, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishResultSet() {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.isDone()) {
                throw new ConfigRuntimeException("AsyncRequestResult is already finished");
            }
            this.isDone = true;
            this.resetTimeoutTask(false);
            if (this.finishCallback != null) {
                this.callbackAsyncInvoker.invoke(new AsyncNotifier<AsyncRequestResultImpl>(this.finishCallback, this));
            }
            this.lockObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(Exception except) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.isDone()) {
                throw new ConfigRuntimeException("AsyncRequestResult is already finished");
            }
            this.exception = except;
            this.isDone = true;
            this.resetTimeoutTask(false);
            if (this.finishCallback != null) {
                this.callbackAsyncInvoker.invoke(new AsyncNotifier<AsyncRequestResultImpl>(this.finishCallback, this));
            }
            this.lockObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout() {
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.isDone()) {
                this.setException(new ConfigRuntimeException("Timeout waiting for server response message"));
            }
        }
    }

    private void resetTimeoutTask(boolean scheduleNext) {
        if (this.timeoutTicket != null) {
            this.timeoutTicket.cancel();
            this.timeoutTicket = null;
        }
        if (scheduleNext && this.timeoutTask != null && this.timeout > 0L) {
            Scheduler scheduler = TimerFactory.getTimer();
            this.timeoutTicket = scheduler.schedule(this.timeout, this.timeoutTask);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncNotifier<O>
    implements Runnable {
        private Action<O> notifAction;
        private O notifArg;

        AsyncNotifier(Action<O> action, O argument) {
            this.notifAction = action;
            this.notifArg = argument;
        }

        @Override
        public void run() {
            try {
                this.notifAction.handle(this.notifArg);
            }
            catch (Exception ex) {
                AsyncRequestResultImpl.this.log.error((Object)"Exception in notification callback", (Throwable)ex);
            }
        }
    }
}

