/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.com.runtime;

import com.genesyslab.platform.applicationblocks.com.CfgDelta;
import com.genesyslab.platform.applicationblocks.com.ConfEvent;
import com.genesyslab.platform.applicationblocks.com.ConfService;
import com.genesyslab.platform.applicationblocks.com.ConfigException;
import com.genesyslab.platform.applicationblocks.com.ConfigRuntimeException;
import com.genesyslab.platform.applicationblocks.com.ICfgObject;
import com.genesyslab.platform.applicationblocks.com.IConfService;
import com.genesyslab.platform.applicationblocks.com.NotificationQuery;
import com.genesyslab.platform.applicationblocks.com.Subscription;
import com.genesyslab.platform.applicationblocks.com.runtime.AsyncRequestResultImpl;
import com.genesyslab.platform.applicationblocks.com.runtime.CfgObjectActivator;
import com.genesyslab.platform.applicationblocks.com.runtime.ConfEventImpl;
import com.genesyslab.platform.applicationblocks.com.runtime.GlobalConfService;
import com.genesyslab.platform.applicationblocks.commons.Action;
import com.genesyslab.platform.applicationblocks.commons.Predicate;
import com.genesyslab.platform.applicationblocks.commons.broker.BrokerService;
import com.genesyslab.platform.applicationblocks.commons.broker.MessageFilter;
import com.genesyslab.platform.applicationblocks.commons.broker.Subscriber;
import com.genesyslab.platform.applicationblocks.commons.broker.SubscriptionService;
import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.AsyncInvokerSupport;
import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;
import com.genesyslab.platform.commons.protocol.ChannelErrorEvent;
import com.genesyslab.platform.commons.protocol.ChannelListener;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.Protocol;
import com.genesyslab.platform.commons.protocol.Referenceable;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventBriefInfo;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventError;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectCreated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectDeleted;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectUpdated;
import com.genesyslab.platform.configuration.protocol.confserver.events.EventObjectsRead;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventService
implements SubscriptionService<ConfEvent>,
Subscriber<Message>,
ChannelListener,
AsyncInvokerSupport {
    private BrokerService<ConfEvent> myBrokerService;
    private ConfService confService;
    private Protocol confProtocol;
    private AsyncInvoker invoker = null;
    private MessageFilter filter;
    private final Map<Object, AsyncRequestResultImpl<? extends ICfgObject>> wmAsyncRequests = new HashMap<Object, AsyncRequestResultImpl<? extends ICfgObject>>();
    private final ILogger log = Log.getLogger(EventService.class);

    public EventService(ConfService cfgService) {
        this.myBrokerService = new BrokerService();
        this.confService = cfgService;
        this.confProtocol = cfgService.getProtocol();
        this.filter = new MessageFilter(this.confProtocol.getProtocolId());
        this.confProtocol.addChannelListener((ChannelListener)this);
    }

    public void register(Subscriber<ConfEvent> subscriber) {
        this.myBrokerService.register(subscriber);
    }

    public void register(Action<ConfEvent> handler, Predicate<ConfEvent> actionFilter) {
        this.myBrokerService.register(handler, actionFilter);
    }

    public void unregister(Subscriber<ConfEvent> subscriber) {
        this.myBrokerService.unregister(subscriber);
    }

    public void unregister(Action<ConfEvent> handler) {
        this.myBrokerService.unregister(handler);
    }

    public MessageFilter getFilter() {
        return this.filter;
    }

    public Subscription subscribe(NotificationQuery query) throws ConfigException {
        return GlobalConfService.subscribe(this.confProtocol, query);
    }

    public Subscription subscribe(ICfgObject obj) throws ConfigException {
        return GlobalConfService.subscribe(this.confProtocol, obj);
    }

    public void unsubscribe(Subscription subscription) throws ConfigException {
        GlobalConfService.unsubscribe(this.confProtocol, subscription);
    }

    public void handle(Message obj) {
        if (obj == null) {
            return;
        }
        if (this.log.isDebug()) {
            this.log.debug((Object)("Received message " + obj));
        }
        switch (obj.messageId()) {
            case 2: 
            case 20: 
            case 29: 
            case 73: {
                this.updateAsyncReadRequest(obj);
                break;
            }
            case 75: {
                EventObjectUpdated objUpdMessage = (EventObjectUpdated)obj;
                Document confObj = objUpdMessage.getConfObject();
                ConfEventImpl newEvent = confObj != null ? new ConfEventImpl(GlobalConfService.getDBIDFromDeltaDoc(confObj), (CfgObjectType)GEnum.getValue(CfgObjectType.class, (Integer)objUpdMessage.getObjectType()), ConfEvent.EventType.ObjectUpdated, this.createDelta(confObj, objUpdMessage.getEndpoint())) : new ConfEventImpl(-1, (CfgObjectType)GEnum.getValue(CfgObjectType.class, (Integer)objUpdMessage.getObjectType()), ConfEvent.EventType.ObjectUpdated, null);
                newEvent.setUnsolicited(objUpdMessage.getReferenceId() == 0);
                this.publish(newEvent);
                break;
            }
            case 74: {
                EventObjectCreated upMessage = (EventObjectCreated)obj;
                Document confObj = upMessage.getConfObject();
                Integer folderDbid = upMessage.getFolderDbid();
                try {
                    int fldDbid = 0;
                    if (folderDbid != null) {
                        fldDbid = folderDbid;
                    }
                    ICfgObject cfgObj = this.confService.createObjectFromXML(confObj.getDocumentElement().getFirstChild(), null, fldDbid, true);
                    ConfEventImpl newEvent = new ConfEventImpl(GlobalConfService.getDBIDFromObjectDoc(confObj), GlobalConfService.getObjectTypeFromDoc(confObj), ConfEvent.EventType.ObjectCreated, cfgObj);
                    newEvent.setUnsolicited(upMessage.getReferenceId() == 0);
                    this.publish(newEvent);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error instantiating configuration object", (Throwable)e);
                    this.log.debug((Object)confObj);
                }
                break;
            }
            case 16: {
                EventObjectDeleted objDelMessage = (EventObjectDeleted)obj;
                ConfEventImpl newEvent = new ConfEventImpl(objDelMessage.getDbid(), (CfgObjectType)GEnum.getValue(CfgObjectType.class, (Integer)objDelMessage.getObjectType()), ConfEvent.EventType.ObjectDeleted, null);
                newEvent.setUnsolicited(objDelMessage.getReferenceId() == 0);
                this.publish(newEvent);
                break;
            }
        }
    }

    private void publish(ConfEvent newEvent) {
        if (this.invoker != null) {
            this.invoker.invoke((Runnable)new AsyncConfEventPublisher(newEvent));
        } else {
            this.myBrokerService.publish((Object)newEvent);
        }
    }

    public void setInvoker(AsyncInvoker invoker) {
        this.invoker = invoker;
    }

    public void dispose() {
        this.closeWaitingRequests(null);
        this.confProtocol.removeChannelListener((ChannelListener)this);
        this.confProtocol = null;
        this.myBrokerService = null;
        this.confService = null;
        this.invoker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsyncRequest(Object ref, AsyncRequestResultImpl<? extends ICfgObject> asyncReq) {
        Map<Object, AsyncRequestResultImpl<? extends ICfgObject>> map = this.wmAsyncRequests;
        synchronized (map) {
            this.wmAsyncRequests.put(ref, asyncReq);
            asyncReq.setTimeoutAction(new TimeoutTask(ref));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAsyncReadRequest(Message incoming) {
        Object msgRef = ((Referenceable)incoming).retreiveReference();
        if (msgRef != null) {
            AsyncRequestResultImpl<? extends ICfgObject> rqI;
            Map<Object, AsyncRequestResultImpl<? extends ICfgObject>> map = this.wmAsyncRequests;
            synchronized (map) {
                rqI = this.wmAsyncRequests.get(msgRef);
                if (rqI != null && rqI.isCancelled()) {
                    this.wmAsyncRequests.remove(msgRef);
                    rqI = null;
                    if (this.log.isDebug()) {
                        this.log.debug((Object)("Got incoming message on canceled request: " + msgRef));
                    }
                }
                if (rqI != null) {
                    if (incoming.messageId() != 73 && incoming.messageId() != 29) {
                        this.wmAsyncRequests.remove(msgRef);
                    } else if (this.log.isDebug()) {
                        this.log.debug((Object)("Got incoming message with partial data for " + msgRef));
                    }
                }
            }
            if (rqI != null && !rqI.isCancelled()) {
                if (incoming.messageId() == 20) {
                    rqI.finishResultSet();
                } else if (incoming.messageId() == 73) {
                    this.createObjectsFromReceivedMessages(rqI, (EventObjectsRead)incoming);
                } else if (incoming.messageId() == 29) {
                    this.createObjectsFromReceivedMessages(rqI, (EventBriefInfo)incoming);
                } else if (incoming.messageId() == 2) {
                    this.log.error((Object)("Error objects reading: " + incoming.toString()));
                    rqI.setException(GlobalConfService.createConfigServerException((EventError)incoming));
                }
            }
        }
    }

    private CfgDelta createDelta(Document confObj, Endpoint ep) {
        if (confObj == null || confObj.getDocumentElement() == null || confObj.getDocumentElement().getFirstChild() == null) {
            throw new IllegalArgumentException("confObj");
        }
        String deltaTypeName = confObj.getDocumentElement().getFirstChild().getLocalName();
        return (CfgDelta)CfgObjectActivator.createInstance(deltaTypeName, this.confService, confObj.getDocumentElement().getFirstChild(), null);
    }

    protected void createObjectsFromReceivedMessages(AsyncRequestResultImpl requestImpl, EventObjectsRead dataReadMsg) {
        Collection resultCollection = null;
        Exception exception = null;
        try {
            resultCollection = GlobalConfService.activateMultipleObjects(requestImpl.getObjectClass(), (IConfService)this.confService, dataReadMsg);
        }
        catch (Throwable throwable) {
            this.log.error((Object)"Error objects activation", throwable);
            exception = throwable instanceof ConfigException || throwable instanceof ConfigRuntimeException ? (Exception)throwable : new ConfigRuntimeException("Unexpected exception", throwable);
        }
        if (resultCollection != null) {
            requestImpl.addToResultSet(resultCollection);
        } else {
            requestImpl.setException(exception);
        }
    }

    protected void createObjectsFromReceivedMessages(AsyncRequestResultImpl requestImpl, EventBriefInfo dataReadMsg) {
        Collection resultCollection = null;
        Exception exception = null;
        try {
            resultCollection = GlobalConfService.activateMultipleObjects(requestImpl.getObjectClass(), (IConfService)this.confService, dataReadMsg);
        }
        catch (Throwable throwable) {
            this.log.error((Object)"Error objects activation", throwable);
            exception = throwable instanceof ConfigException || throwable instanceof ConfigRuntimeException ? (Exception)throwable : new ConfigRuntimeException("Unexpected exception", throwable);
        }
        if (resultCollection != null) {
            requestImpl.addToResultSet(resultCollection);
        } else {
            requestImpl.setException(exception);
        }
    }

    public void onChannelOpened(EventObject event) {
    }

    public void onChannelClosed(ChannelClosedEvent event) {
        Throwable cause = null;
        if (event != null) {
            cause = event.getCause();
        }
        this.closeWaitingRequests(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWaitingRequests(Throwable cause) {
        Map<Object, AsyncRequestResultImpl<? extends ICfgObject>> map = this.wmAsyncRequests;
        synchronized (map) {
            if (!this.wmAsyncRequests.isEmpty()) {
                this.log.info((Object)"There are waiting async reading clients while channel get closed");
                Exception exception = null;
                if (cause != null) {
                    exception = cause instanceof Exception ? (Exception)cause : new ConfigRuntimeException("Unexpected channel error", cause);
                }
                if (exception == null) {
                    exception = new ConfigRuntimeException("Connection channel has been closed");
                }
                for (AsyncRequestResultImpl<? extends ICfgObject> elem : this.wmAsyncRequests.values()) {
                    elem.setException(exception);
                }
                this.wmAsyncRequests.clear();
            }
        }
    }

    public void onChannelError(ChannelErrorEvent event) {
        this.log.warn((Object)("onChannelError - " + event));
    }

    private class TimeoutTask
    implements TimerAction {
        private final Object msgRef;

        TimeoutTask(Object msgRef) {
            this.msgRef = msgRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimer() {
            AsyncRequestResultImpl asyncFuture = null;
            Map map = EventService.this.wmAsyncRequests;
            synchronized (map) {
                asyncFuture = (AsyncRequestResultImpl)EventService.this.wmAsyncRequests.remove(this.msgRef);
            }
            if (asyncFuture != null) {
                asyncFuture.timeout();
            }
        }
    }

    private class AsyncConfEventPublisher
    implements Runnable {
        private ConfEvent theEvent;

        AsyncConfEventPublisher(ConfEvent event) {
            this.theEvent = event;
        }

        public void run() {
            EventService.this.myBrokerService.publish((Object)this.theEvent);
        }
    }
}

