/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ChannelNotOpenedException;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.ClientChannelManager;
import com.genesyslab.platform.commons.protocol.DuplexChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.MessageCorrelator;
import com.genesyslab.platform.commons.protocol.Protocol;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Referenceable;
import com.genesyslab.platform.commons.protocol.RegistrationException;
import com.genesyslab.platform.commons.protocol.RequestFuture;
import com.genesyslab.platform.commons.protocol.RequestUnReferenceableException;
import com.genesyslab.platform.commons.threading.CompletionHandler;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientChannel
extends DuplexChannel
implements Protocol {
    private static final ILogger log = Log.getLogger(ClientChannel.class);
    private final ReferenceBuilder refBuilder;
    private MessageCorrelator correlator;
    private boolean copyResponse = false;
    private RegistrationHandler regHandler;
    private final AtomicBoolean registering = new AtomicBoolean(false);
    private final LinkedBlockingQueue<Object> regUnsolicitedEventsIn = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Message> regUnsolicitedEventsOut = new LinkedBlockingQueue();
    private int regUnsolicitedEventsPassLimit = 0;

    public ClientChannel(Endpoint endpoint, ProtocolFactory protocolFactory, ReferenceBuilder refBuilder, long timeout) {
        super(endpoint, protocolFactory, timeout);
        this.refBuilder = refBuilder;
        this.manager = ClientChannelManager.createManager(this);
        this.manager.initialize();
    }

    public ClientChannel(Endpoint endpoint, ProtocolFactory protocolFactory, ReferenceBuilder refBuilder) {
        this(endpoint, protocolFactory, refBuilder, 30000L);
    }

    @Override
    public Message request(Message message) throws ProtocolException, IllegalStateException {
        return this.request(message, this.getTimeout());
    }

    @Override
    public Message request(Message message, long timeout) throws ProtocolException {
        this.throwNull(message, "message");
        this.throwNotOpenedOnSend();
        return this.doRequest(message, timeout);
    }

    @Override
    public RequestFuture beginRequest(Message message) throws ProtocolException {
        this.throwNotOpenedOnSend();
        this.throwOnUnReferenceableRequest(message);
        return (RequestFuture)((Object)this.doBeginRequest(message, null, null, this.getTimeout()));
    }

    @Override
    public <A> void requestAsync(Message message, A attachment, CompletionHandler<Message, ? super A> handler) throws ProtocolException {
        this.requestAsync(message, attachment, handler, this.getTimeout());
    }

    @Override
    public <A> void requestAsync(Message request, A attachment, CompletionHandler<Message, ? super A> handler, long timeout) throws ProtocolException, IllegalStateException {
        this.throwNotOpenedOnSend();
        this.throwOnUnReferenceableRequest(request);
        this.doBeginRequest(request, attachment, handler, timeout);
    }

    @Override
    public Message endRequest(RequestFuture future) throws ProtocolException {
        return this.endRequest(future, 30000L);
    }

    @Override
    public Message endRequest(RequestFuture future, long timeout) throws ProtocolException {
        if (future == null) {
            return null;
        }
        if (future instanceof MessageCorrelator.MessageEntry) {
            return this.doEndRequest((MessageCorrelator.MessageEntry)((Object)future), timeout);
        }
        throw new IllegalArgumentException("Wrong future argument, only futures from beginRequest are supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeOpening(ConnectionClosedEvent event) {
        super.closeOpening(event);
        if (this.registering.get()) {
            if (this.correlator != null) {
                this.correlator.releaseWaiters(event);
                this.correlator = null;
            }
            LinkedBlockingQueue<Object> linkedBlockingQueue = this.regUnsolicitedEventsIn;
            synchronized (linkedBlockingQueue) {
                if (this.registering.get()) {
                    this.regUnsolicitedEventsIn.add(event);
                }
            }
        }
    }

    @Override
    protected void setState(ChannelState state, ConnectionClosedEvent closedEvent) {
        super.setState(state, closedEvent);
        if (state == ChannelState.Opened) {
            if (!this.manager.isRegistered()) {
                this.manager.register();
            }
        } else if (state == ChannelState.Closed) {
            MessageCorrelator correlator = this.correlator;
            if (correlator != null) {
                correlator.releaseWaiters(closedEvent);
            }
            this.manager.unregister();
        }
    }

    @Deprecated
    protected final MessageCorrelator.MessageEntry doBeginRequest(Message message) throws ProtocolException {
        return this.doBeginRequest(message, null, null, -1L);
    }

    protected final <A> MessageCorrelator.MessageEntry doBeginRequest(Message message, A attachment, CompletionHandler<Message, ? super A> handler, long timeout) throws ProtocolException {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.correlator == null) {
            throw new ChannelNotOpenedException("Connection is not opened (no correlator initialized)");
        }
        if (handler != null && timeout <= 0L) {
            throw new IllegalArgumentException("Request completion handler requires positive timeout value");
        }
        if (!this.isMessageAllowed(message)) {
            return null;
        }
        this.ensureReference(message);
        MessageCorrelator.MessageEntry entry = this.correlator.registerMessage(message, attachment, handler, this.getInvoker(), timeout);
        this.doSend(message);
        return entry;
    }

    protected Message doRequest(Message message, long timeout) throws ProtocolException {
        if (log.isDebug()) {
            log.debug((Object)("Requesting with " + message.messageName()));
        }
        MessageCorrelator.MessageEntry entry = this.doBeginRequest(message, null, null, -1L);
        return this.doEndRequest(entry, timeout);
    }

    private Message doEndRequest(MessageCorrelator.MessageEntry entry, long timeout) {
        if (entry == null) {
            return null;
        }
        if (log.isDebug()) {
            log.debug((Object)("Waiting for response. " + entry.toString()));
        }
        Message response = this.correlator.waitResponse(entry, timeout);
        if (log.isDebug()) {
            if (response == null) {
                log.debug((Object)"Response is null, channel is closing?");
            } else {
                log.debug((Object)("Got response, id: " + response.messageId()));
            }
        }
        return response;
    }

    @Override
    public boolean getCopyResponse() {
        return this.copyResponse;
    }

    @Override
    public void setCopyResponse(boolean copyResponse) {
        this.copyResponse = copyResponse;
    }

    public void setHandshakeUnsolicitedEventsPassLimit(int maxNum) {
        this.regUnsolicitedEventsPassLimit = maxNum;
    }

    protected void onUnexpectedHandshakeMessage(Message request, Message response, Queue<Message> msgsBuffer) throws ProtocolException {
        if (msgsBuffer.size() >= this.regUnsolicitedEventsPassLimit) {
            log.debug((Object)"Protocol has got too many unaccepted unsolicited messages during handshake procedure");
            throw new RegistrationException("Too many unaccepted unsolicited messages");
        }
        msgsBuffer.add(response);
    }

    @Override
    public ReferenceBuilder getReferenceBuilder() {
        return this.refBuilder;
    }

    protected void throwOnUnReferenceableRequest(Message request) {
        if (request == null) {
            throw new IllegalArgumentException("Request message is null");
        }
        if (!(request instanceof Referenceable)) {
            throw new RequestUnReferenceableException("Request message is not Referenceable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onOpen() throws ProtocolException {
        LinkedBlockingQueue<Object> linkedBlockingQueue;
        this.correlator = new MessageCorrelator(this.refBuilder);
        try {
            this.processRegistration();
            linkedBlockingQueue = this.regUnsolicitedEventsIn;
            synchronized (linkedBlockingQueue) {
                try {
                    super.onOpen();
                }
                finally {
                    this.finalyzeRegistration();
                }
            }
        }
        finally {
            if (this.registering.get()) {
                linkedBlockingQueue = this.regUnsolicitedEventsIn;
                synchronized (linkedBlockingQueue) {
                    this.finalyzeRegistration();
                }
            }
        }
    }

    @Override
    protected void onClose(ConnectionClosedEvent event) {
        if (this.correlator != null) {
            this.correlator.releaseWaiters(event);
            this.correlator = null;
        }
        super.onClose(event);
    }

    @Override
    protected void onSend(Message message) throws ProtocolException {
        this.ensureReference(message);
        super.onSend(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onReceiveMessage(Message msg) {
        boolean awaited = false;
        if (this.correlator != null) {
            awaited = this.correlator.correlate(msg) != null;
        }
        boolean registrationPending = this.registering.get();
        if (!awaited && registrationPending) {
            LinkedBlockingQueue<Object> linkedBlockingQueue = this.regUnsolicitedEventsIn;
            synchronized (linkedBlockingQueue) {
                registrationPending = this.registering.get();
                if (registrationPending) {
                    this.regUnsolicitedEventsIn.add(msg);
                }
            }
        }
        if (!(registrationPending || awaited && !this.copyResponse)) {
            super.onReceiveMessage(msg);
        }
    }

    protected void setRegistrationHandler(RegistrationHandler handler) {
        this.regHandler = handler;
        this.registering.set(this.regHandler != null);
    }

    private void ensureReference(Message message) {
        if (!(message instanceof Referenceable)) {
            return;
        }
        if (this.refBuilder.retreiveReference(message) == null) {
            Object reference = this.refBuilder.updateReference(message);
            log.debugFormat("Message got new reference: {0}", reference);
        }
    }

    private void processRegistration() throws ProtocolException {
        if (this.regHandler != null) {
            log.debug((Object)"Starting registration...");
            try {
                this.regUnsolicitedEventsIn.clear();
                this.regUnsolicitedEventsOut.clear();
                Message regMessage = this.regHandler.getRegistrationMessage();
                Message response = this.submitRegMessage(regMessage);
                while (true) {
                    if (!this.regHandler.handleResponse(response)) {
                        if (response != null) {
                            boolean isRequestReferenced = false;
                            if (regMessage instanceof Referenceable && response instanceof Referenceable) {
                                Object refReq = ((Referenceable)((Object)regMessage)).retreiveReference();
                                Object refResp = ((Referenceable)((Object)response)).retreiveReference();
                                boolean bl = isRequestReferenced = refReq != null && refReq.equals(refResp);
                            }
                            if (isRequestReferenced) {
                                log.debug((Object)"Response is not accepted, registration failed, closing channel");
                                throw new RegistrationException("Client registration failed", response);
                            }
                            this.onUnexpectedHandshakeMessage(regMessage, response, this.regUnsolicitedEventsOut);
                            response = this.submitRegMessage(null);
                            continue;
                        }
                    } else if (!this.regHandler.isRegistrationComplete()) {
                        regMessage = this.regHandler.getRegistrationMessage();
                        response = this.submitRegMessage(regMessage);
                        continue;
                    }
                    break;
                }
            }
            catch (ProtocolException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProtocolException("Exception while registering", e);
            }
        }
    }

    private void finalyzeRegistration() throws ProtocolException {
        if (this.regHandler != null && this.registering.get()) {
            log.debug((Object)"Finalizing registration...");
            try {
                while (!this.regUnsolicitedEventsOut.isEmpty()) {
                    super.onReceiveMessage(this.regUnsolicitedEventsOut.poll());
                }
                while (!this.regUnsolicitedEventsIn.isEmpty()) {
                    Object ev = this.regUnsolicitedEventsIn.poll();
                    if (ev instanceof Message) {
                        super.onReceiveMessage((Message)ev);
                        continue;
                    }
                    if (ev instanceof ConnectionClosedEvent) {
                        throw new ProtocolException("Problems during registration", ((ConnectionClosedEvent)ev).getCause());
                    }
                    if (ev == null) continue;
                    log.warnFormat("Unexpected event during handshake procedure: {0}", ev);
                }
            }
            catch (ProtocolException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProtocolException("Exception while registering", e);
            }
            finally {
                this.registering.set(false);
            }
        }
    }

    protected Message submitRegMessage(Message regMessage) throws ProtocolException, InterruptedException {
        Message response;
        long timeout = this.getTimeout();
        if (regMessage instanceof Referenceable) {
            response = this.doRequest(regMessage, timeout);
        } else {
            Object obj;
            if (regMessage != null) {
                this.doSend(regMessage);
            }
            if ((obj = timeout < 0L ? this.regUnsolicitedEventsIn.take() : this.regUnsolicitedEventsIn.poll(timeout, TimeUnit.MILLISECONDS)) == null) {
                throw this.getTimeoutException("register client", timeout);
            }
            if (obj instanceof ConnectionClosedEvent) {
                throw new ProtocolException("Problems during registration", ((ConnectionClosedEvent)obj).getCause());
            }
            response = (Message)obj;
        }
        return response;
    }

    protected abstract class SimpleRegistrationHandler
    implements RegistrationHandler {
        private boolean regComplete = false;

        protected SimpleRegistrationHandler() {
        }

        protected abstract boolean isResponseAccepted(Message var1) throws RegistrationException;

        public abstract Message getRegistrationMessage();

        public boolean handleResponse(Message response) throws ProtocolException {
            this.regComplete = false;
            boolean accepted = this.isResponseAccepted(response);
            if (accepted) {
                this.regComplete = true;
                return true;
            }
            if (response == null) {
                this.regComplete = true;
                throw new ProtocolException("Registration stopped (server response lost)");
            }
            return false;
        }

        public boolean isRegistrationComplete() {
            return this.regComplete;
        }
    }

    protected static interface RegistrationHandler {
        public Message getRegistrationMessage();

        public boolean handleResponse(Message var1) throws ProtocolException;

        public boolean isRegistrationComplete();
    }
}

