/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ManagedConfiguration;
import com.genesyslab.platform.commons.connection.configuration.PropertyConfiguration;
import com.genesyslab.platform.commons.connection.tls.SSLExtendedOptions;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;

public class Endpoint
implements Cloneable {
    protected String name;
    protected String host;
    protected int port;
    protected SSLContext sslContext;
    protected SSLExtendedOptions sslOptions;
    protected String spn;
    protected ManagedConfiguration connConfig;
    protected String tostringPrefix;
    protected final String defaultPrefix = "psdkendpoint";
    private URI uri;

    public Endpoint(String host, int port) {
        this(null, host, port);
    }

    public Endpoint(String name, String host, int port) {
        this.setEndpointName(name, host, port);
        if (host == null || "".equals(host)) {
            throw new NullPointerException("host is null or empty");
        }
        this.validatePort(port);
        this.host = host;
        this.port = port;
        this.createUri(name, host, port);
        this.initConnConfig(null);
    }

    public Endpoint(String host, int port, ConnectionConfiguration connConf) {
        this(null, host, port, connConf);
    }

    public Endpoint(String name, String host, int port, ConnectionConfiguration connConf) {
        this(name, host, port);
        this.initConnConfig(connConf);
    }

    public Endpoint(String host, int port, ConnectionConfiguration connConf, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(null, host, port, connConf, tlsEnabled, sslContext, sslOptions);
    }

    public Endpoint(String name, String host, int port, ConnectionConfiguration connConf, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(name, host, port, connConf);
        this.initConnConfig(connConf);
        this.connConfig.setBoolean("tls", tlsEnabled);
        this.sslContext = sslContext;
        this.sslOptions = sslOptions;
    }

    public Endpoint(URI uri) {
        this(null, uri);
    }

    public Endpoint(URI uri, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(null, uri, tlsEnabled, sslContext, sslOptions);
    }

    public Endpoint(String name, URI uri) {
        URI normal = uri.normalize();
        if (name == null) {
            this.setEndpointName(normal.getUserInfo(), normal.getHost(), normal.getPort());
        } else {
            this.setEndpointName(name, normal.getHost(), normal.getPort());
        }
        this.host = normal.getHost();
        if (this.host == null || this.host.equals("")) {
            throw new IllegalArgumentException("can't extract valid host address");
        }
        this.port = normal.getPort();
        this.validatePort(this.port);
        String query = normal.getQuery();
        if (null != query) {
            this.initConnConfig((ConnectionConfiguration)new PropertyConfiguration(query));
        } else {
            this.initConnConfig(null);
        }
        this.createUri(this.name, this.host, this.port);
    }

    public Endpoint(String name, URI uri, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(name, uri);
        this.initConnConfig(null);
        this.connConfig.setBoolean("tls", tlsEnabled);
        this.sslContext = sslContext;
        this.sslOptions = sslOptions;
    }

    protected Endpoint(String name) {
        this.name = name == null ? "" : name;
        this.initConnConfig(null);
    }

    private void initConnConfig(ConnectionConfiguration connConf) {
        this.connConfig = connConf != null ? new ManagedConfiguration(connConf) : new ManagedConfiguration((ConnectionConfiguration)new PropertyConfiguration());
    }

    protected void validatePort(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port specified (" + port + "), allowed range is 1..65535");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.tostringPrefix != null && !this.tostringPrefix.equals("")) {
            buf.append(this.tostringPrefix).append(" - ");
        }
        buf.append("tcp://").append(this.host).append(':').append(this.port);
        if (this.spn != null) {
            buf.append(" spn:").append(this.spn);
        }
        return buf.toString();
    }

    public ConnectionConfiguration getConfiguration() {
        return this.connConfig;
    }

    void setConfiguration(ConnectionConfiguration connConf) {
        ManagedConfiguration cfg = this.connConfig;
        if (cfg != null) {
            cfg.setConfiguration(connConf);
        } else {
            this.connConfig = new ManagedConfiguration(connConf);
        }
    }

    public SSLExtendedOptions getSSLOptions() {
        return this.sslOptions;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    private void createUri(String name, String host, int port) {
        try {
            String userInfo = name;
            if (name != null && name.equals("")) {
                userInfo = null;
            }
            this.uri = new URI("tcp", userInfo, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            try {
                this.uri = new URI("tcp://" + host + ":" + port);
                if (this.uri.getHost() == null || this.uri.getHost().equals("")) {
                    throw new IllegalArgumentException("Can't build proper URI");
                }
            }
            catch (URISyntaxException e1) {
                throw new IllegalArgumentException("Can't build proper URI", e);
            }
        }
    }

    protected void setEndpointName(String name, String host, int port) {
        if (name != null && !name.equals("")) {
            this.name = this.tostringPrefix = name;
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("psdkendpoint").append("@");
            if (host != null && !host.equals("")) {
                buf.append(host);
            } else {
                buf.append("[anylocal]");
            }
            buf.append(":").append(port);
            this.name = buf.toString();
            this.tostringPrefix = "psdkendpoint";
        }
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        if (this.name != null) {
            hash ^= this.name.hashCode();
        }
        if (this.host != null) {
            hash ^= this.host.hashCode();
        }
        return hash ^= this.port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.port == other.port;
    }

    public Object clone() throws CloneNotSupportedException {
        Endpoint result = (Endpoint)super.clone();
        try {
            ManagedConfiguration cfg = this.connConfig;
            result.connConfig = cfg == null ? null : (ManagedConfiguration)cfg.clone();
        }
        catch (CloneNotSupportedException e) {
            result.connConfig = this.connConfig;
        }
        return result;
    }

    public Endpoint setSPN(String SPN) {
        this.spn = SPN;
        return this;
    }

    public String getSPN() {
        return this.spn;
    }
}

