/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.collections.util.Base64;
import com.genesyslab.platform.commons.connection.impl.xml.XmlStructureHandler;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecLazyParser;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.EnumCodec;
import com.genesyslab.platform.commons.xml.XmlUtil;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlMessageSerializer {
    private ProtocolFactory factory;
    private Transformer transformer;
    private static final String NS_ATTR_NAME = "xmlns";

    public XmlMessageSerializer(ProtocolFactory factory) {
        this.factory = factory;
    }

    public void serialize(Message message, Result result) throws ParserConfigurationException, CodecException {
        String[] lazyProps;
        Document doc = XmlMessageSerializer.createDocument();
        DataSupport support = XmlMessageSerializer.asDataSupport(message);
        CodecLazyParser lazyParser = support.getLazyParser();
        if (lazyParser != null && (lazyProps = lazyParser.getNotParsed()) != null) {
            for (String sName : lazyProps) {
                lazyParser.parse(sName);
            }
        }
        Element rootElement = this.appendRootElement(doc, support);
        Element msgElement = this.appendMessageElement(message, rootElement);
        this.appendProperties(support, doc, msgElement, message);
        this.domToResult(result, doc);
    }

    public Message deserialize(Source doc) throws CodecException {
        Element elem = CodecUtil.asElement(doc);
        return this.deserialize(elem.getOwnerDocument());
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    private void domToResult(Result result, Document doc) throws CodecException {
        if (result instanceof DOMResult) {
            DOMResult dr = (DOMResult)result;
            Node resNode = dr.getNode();
            if (resNode != null) {
                if (resNode.getNodeType() == 9) {
                    Document document = (Document)resNode;
                    Node node = document.importNode(doc.getDocumentElement(), true);
                    Node docChild = document.getFirstChild();
                    if (docChild != null) {
                        document.replaceChild(node, docChild);
                    } else {
                        document.appendChild(node);
                    }
                } else {
                    Document document = resNode.getOwnerDocument();
                    Node node = document.importNode(doc.getDocumentElement(), true);
                    dr.getNode().appendChild(node);
                }
            } else {
                dr.setNode(doc);
            }
        } else {
            try {
                this.getTransformer().transform(new DOMSource(doc), result);
            }
            catch (TransformerException e) {
                throw new CodecException("Transformer problems", e);
            }
        }
    }

    private Transformer getTransformer() throws TransformerConfigurationException {
        if (this.transformer == null) {
            this.transformer = XmlFactories.newTransformer();
        }
        return this.transformer;
    }

    private Message deserialize(Document doc) throws CodecException {
        Element rootElem = this.getRootElement(doc);
        Element msgElem = this.getMessageElement(rootElem);
        Message msg = this.createMessage(msgElem);
        DataSupport support = XmlMessageSerializer.asDataSupport(msg);
        this.deserializeAttributes(msgElem, support, msg);
        return msg;
    }

    private void deserializeAttributes(Element msgElem, DataSupport support, Message message) throws CodecException {
        MetaData meta = support.getMetaData();
        Element elem = XmlUtil.getFirstChild((Element)msgElem);
        while (elem != null) {
            String name = elem.getLocalName();
            AttributeDescription key = meta.getAttributeDescription(name);
            if (key != null) {
                Object value = this.deserializeValue(support, message, elem, key);
                support.attributes().put(key.getName(), value);
            } else {
                Class clazz;
                Map compsMeta;
                Map compounds = support.getCompounds();
                Object compoundByName = compounds.get(name);
                DataSupport compound = null;
                if (compoundByName != null) {
                    compound = XmlMessageSerializer.asDataSupport(compoundByName);
                }
                if (compound == null && (compsMeta = meta.getCompoundProperties()) != null && (clazz = (Class)compsMeta.get(name)) != null) {
                    compound = (DataSupport)MetaData.addCompound(clazz, compounds, name);
                }
                if (compound != null) {
                    this.deserializeAttributes(elem, compound, message);
                }
            }
            elem = XmlUtil.getNextSibling((Element)elem);
        }
    }

    private Object deserializeValue(DataSupport owner, Message message, Element attrElem, AttributeDescription key) throws CodecException {
        Class valueType = key.getValueType();
        if (valueType == String.class) {
            return XmlUtil.getElementText((Element)attrElem);
        }
        if (valueType == Integer.TYPE || valueType == Integer.class) {
            return new Integer(XmlUtil.getElementText((Element)attrElem));
        }
        if (valueType == byte[].class) {
            String binData = XmlUtil.getElementText((Element)attrElem);
            return Base64.decodeBase64((byte[])binData.getBytes());
        }
        if (valueType == Long.TYPE || valueType == Long.class) {
            return new Long(XmlUtil.getElementText((Element)attrElem));
        }
        CustomTypeCodec codec = key.createCodec(message, this.factory.getProtocolData());
        if (codec != null) {
            Object ret = codec.decodeFromXml(new DOMSource(attrElem), key);
            owner.attributes().put(key.getName(), ret);
            if (codec instanceof XmlStructureHandler) {
                XmlStructureHandler cdcs = (XmlStructureHandler)codec;
                for (Element childItem = (Element)attrElem.getFirstChild(); childItem != null; childItem = (Element)childItem.getNextSibling()) {
                    if (!cdcs.needsProcessing((Object)owner, childItem.getLocalName(), childItem)) continue;
                    try {
                        Object val = cdcs.onComplexAttribute((Object)owner, childItem.getLocalName(), childItem);
                        this.deserializeAttributes(childItem, (DataSupport)val, message);
                        cdcs.onComplexEnd((Object)owner, childItem.getLocalName());
                        continue;
                    }
                    catch (PlatformException e) {
                        throw new CodecException("Error message deserialization", e);
                    }
                }
            }
            return ret;
        }
        if (key.isEnumProperty()) {
            return new EnumCodec().decodeFromXml(new DOMSource(attrElem), key);
        }
        throw new IllegalArgumentException("Message contains invalid attribute. Name:" + key.getName());
    }

    private Element getMessageElement(Element rootElem) {
        if (rootElem == null || rootElem.getAttribute("Id") == null) {
            throw new IllegalArgumentException("Message element not found or invalid");
        }
        return rootElem;
    }

    private Message createMessage(Element msgElem) {
        Message msg;
        try {
            int msgId = Integer.parseInt(msgElem.getAttribute("Id"));
            String messageName = msgElem.getLocalName();
            msg = this.factory.createMessage(msgId, messageName);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Message element is invalid. Wrong id attribute");
        }
        return msg;
    }

    private Element getRootElement(Document doc) {
        Element rootElem = doc.getDocumentElement();
        String ns = rootElem.getNamespaceURI();
        if (ns == null || !ns.equals(this.factory.getProtocolDescription().getNS())) {
            throw new IllegalArgumentException("Unexpected message protocol");
        }
        return rootElem;
    }

    private void appendProperties(DataSupport support, Document doc, Element msgElement, Message message) throws CodecException {
        DataSupport value;
        String key;
        String ns = this.factory.getProtocolDescription().getNS();
        for (Map.Entry entry : support.attributes().entrySet()) {
            key = (String)entry.getKey();
            AttributeDescription attrDesc = support.getMetaData().getAttributeDescription(key);
            if (attrDesc == null || key.equals(attrDesc.getId()) && !key.equals(attrDesc.getName()) || attrDesc.isHidden() || attrDesc.isSerializationHidden() || (value = entry.getValue()) == null) continue;
            String currentNS = null;
            CustomTypeCodec codec = attrDesc.createCodec(message, null);
            if (codec != null) {
                currentNS = codec.getNS();
            }
            if (currentNS == null) {
                currentNS = ns;
            }
            Element attrElement = doc.createElementNS(currentNS, attrDesc.getName());
            this.appendValue(attrDesc, value, doc, attrElement, message);
            msgElement.appendChild(attrElement);
        }
        for (Map.Entry entry : support.getCompounds().entrySet()) {
            key = (String)entry.getKey();
            Object val = entry.getValue();
            if (val == null) continue;
            value = XmlMessageSerializer.asDataSupport(val);
            Element attrElement = doc.createElementNS(ns, key);
            if (!value.attributes().isEmpty() || !value.getCompounds().isEmpty()) {
                this.appendProperties(value, doc, attrElement, message);
            }
            msgElement.appendChild(attrElement);
        }
    }

    private void appendValue(AttributeDescription key, Object value, Document doc, Element attrElement, Message message) throws CodecException {
        Class valueType = key.getValueType();
        String ns = this.factory.getProtocolDescription().getNS();
        if (valueType == String.class) {
            attrElement.appendChild(doc.createTextNode((String)value));
        } else if (valueType == Integer.TYPE || valueType == Long.TYPE || valueType == Integer.class || valueType == Long.class) {
            attrElement.appendChild(doc.createTextNode(value.toString()));
        } else if (valueType == byte[].class) {
            byte[] bytes = (byte[])value;
            String binData = new String(Base64.encodeBase64Chunked((byte[])bytes));
            attrElement.appendChild(doc.createTextNode("\n" + binData));
        } else {
            CustomTypeCodec codec = key.createCodec(message, null);
            if (codec != null) {
                codec.setMessage(message);
                codec.encodeToXml(value, new DOMResult(attrElement));
                if (codec instanceof XmlStructureHandler && value instanceof List) {
                    List lst = (List)value;
                    for (int i = 0; i < lst.size(); ++i) {
                        DataSupport ds = (DataSupport)lst.get(i);
                        Element chldElement = doc.createElementNS(ns, ds.getMetaData().getName());
                        this.appendProperties(ds, doc, chldElement, message);
                        attrElement.appendChild(chldElement);
                    }
                }
            } else if (key.isEnumProperty()) {
                new EnumCodec().encodeToXml(value, new DOMResult(attrElement));
            } else {
                throw new IllegalArgumentException("Message contains invalid attribute. Name:" + key.getName());
            }
        }
    }

    private Element appendMessageElement(Message message, Element rootElement) {
        rootElement.setAttribute("Protocol", message.getProtocolDescription().getProtocolName());
        rootElement.setAttribute("Id", String.valueOf(message.messageId()));
        return rootElement;
    }

    private static DataSupport asDataSupport(Object message) {
        if (!(message instanceof DataSupport)) {
            throw new IllegalArgumentException("Message is not valid (Not a DataSupport element inside)");
        }
        return (DataSupport)message;
    }

    private Element appendRootElement(Document doc, DataSupport message) {
        String rootNodeName = message.getMetaData().getName();
        String ns = this.factory.getProtocolDescription().getNS();
        Element root = doc.createElementNS(ns, rootNodeName);
        root.setAttribute(NS_ATTR_NAME, ns);
        doc.appendChild(root);
        return root;
    }

    private static Document createDocument() throws ParserConfigurationException {
        return XmlFactories.newDocumentBuilder().newDocument();
    }
}

