/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth;

import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.protocol.auth.AuthTicket;
import java.util.Date;

public class AuthTicketData
implements AuthTicket {
    private byte[] ticketBytes;
    private String servicePrincipalName;
    private String userPrincipalName;
    private Date authTime;
    private Date startTime;
    private Date endTime;
    private Date renewTill;
    private boolean useGSS;

    public AuthTicketData(byte[] ticketBytes, boolean useGss) {
        this.ticketBytes = this.cloneBytes(ticketBytes);
        this.useGSS = useGss;
    }

    public AuthTicketData(byte[] ticketBytes, String servicePrincipalName, boolean useGss) {
        this.ticketBytes = this.cloneBytes(ticketBytes);
        this.servicePrincipalName = servicePrincipalName;
        this.useGSS = useGss;
    }

    public AuthTicketData(byte[] ticketBytes, String servicePrincipalName, String userPrincipalName, boolean useGss) {
        this.ticketBytes = this.cloneBytes(ticketBytes);
        this.servicePrincipalName = servicePrincipalName;
        this.userPrincipalName = userPrincipalName;
        this.useGSS = useGss;
    }

    public AuthTicketData(byte[] ticketBytes, String servicePrincipalName, String userPrincipalName, Date authTime, Date startTime, Date endTime, Date renewTill, boolean useGss) {
        this.ticketBytes = this.cloneBytes(ticketBytes);
        this.servicePrincipalName = servicePrincipalName;
        this.userPrincipalName = userPrincipalName;
        this.authTime = this.cloneDate(authTime);
        this.startTime = this.cloneDate(startTime);
        this.endTime = this.cloneDate(endTime);
        this.renewTill = this.cloneDate(renewTill);
        this.useGSS = useGss;
    }

    Date cloneDate(Date d) {
        return null == d ? null : (Date)d.clone();
    }

    byte[] cloneBytes(byte[] bytes) {
        return null == bytes ? null : (byte[])bytes.clone();
    }

    public String getUserPrincipalName() {
        return this.userPrincipalName;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public byte[] getTicketBytes() {
        return this.cloneBytes(this.ticketBytes);
    }

    public String getTicketHex() {
        return new String(Hex.encodeHex((byte[])this.ticketBytes)).toUpperCase();
    }

    public Date getAuthTime() {
        return this.cloneDate(this.authTime);
    }

    public Date getStartTime() {
        return this.cloneDate(this.startTime);
    }

    public Date getEndTime() {
        return this.cloneDate(this.endTime);
    }

    public Date getRenewTill() {
        return this.cloneDate(this.renewTill);
    }

    public boolean getUseGSS() {
        return this.useGSS;
    }
}

