/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AbstractCodecAttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.LazyParsingPossible;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodecAttributeDescription<T extends CustomTypeCodec>
extends AbstractCodecAttributeDescription
implements LazyParsingPossible {
    private boolean lazyPossible = false;
    private Class<T> codecClass;
    private Constructor<T> codecConstructor = null;

    public CodecAttributeDescription(Class<T> codecClass, String id, String name, Class valueType, Class enumClass, String logName, boolean logHidden) {
        this(codecClass, id, name, valueType, enumClass, logName, false, logHidden, false);
    }

    public CodecAttributeDescription(Class<T> codecClass, String id, String name, Class valueType, Class enumClass, String logName, boolean srlzHidden, boolean logHidden, boolean lazyPossible) {
        super(id, name, valueType, enumClass, logName, srlzHidden, logHidden);
        this.codecClass = codecClass;
        try {
            this.codecConstructor = codecClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.lazyPossible = lazyPossible;
    }

    @Override
    public boolean hasCodec() {
        return this.codecConstructor != null;
    }

    @Override
    public CustomTypeCodec createCodec(Message message, Object protocolData) {
        CustomTypeCodec codec = null;
        if (this.codecConstructor != null) {
            try {
                codec = (CustomTypeCodec)this.codecConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (codec != null) {
            if (message != null) {
                codec.setMessage(message);
            }
            if (protocolData != null) {
                codec.setProtocolData(protocolData);
            }
        }
        return codec;
    }

    @Override
    public boolean isSameCodec(Object o) {
        if (o == null) {
            return false;
        }
        return this.codecClass == o.getClass();
    }

    @Override
    public boolean isLazyParsingPossible() {
        return this.lazyPossible;
    }

    @Override
    public String getLogSignature() {
        if (this.logSignature == null) {
            this.logSignature = this.createCodec(null, null).getLogType();
        }
        return this.logSignature;
    }
}

