/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.NoDataCodec;
import com.genesyslab.platform.commons.util.DateTimeConverter;
import com.genesyslab.platform.commons.xml.XmlUtil;
import java.text.ParseException;
import java.util.Date;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.w3c.dom.Element;

public class DateCodec
extends NoDataCodec
implements AttributeTypeCodec {
    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        Date d = DateCodec.asDate(customTypeObject);
        return transport.onAttribute(transportState, id, DateTimeConverter.toString((Date)d));
    }

    public Object decodeFromConnection(Object value, AttributeDescription attributeDescription) throws PlatformException {
        if (value instanceof String) {
            String dateStr = (String)value;
            return this.parseDate(dateStr);
        }
        throw new CodecException("Date string expected. Found: " + value.getClass());
    }

    private Object parseDate(String dateStr) throws CodecException {
        try {
            return DateTimeConverter.parse((String)dateStr);
        }
        catch (ParseException e) {
            throw new CodecException("Invalid date value: '" + dateStr + "'", e);
        }
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        CodecUtil.appendText(DateTimeConverter.toString((Date)DateCodec.asDate(customTypeObject)), attributeElement);
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        return this.decodeFromXml(CodecUtil.asElement(attributeElement));
    }

    private Object decodeFromXml(Element attributeElement) throws CodecException {
        String dateStr = XmlUtil.getElementText((Element)attributeElement);
        return this.parseDate(dateStr);
    }

    public String getLogType() {
        return "str";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) throws CodecException {
        Date d = DateCodec.asDate(customTypeObject);
        buf.append('\"').append(DateTimeConverter.toString((Date)d)).append('\"');
    }

    private static Date asDate(Object customTypeObject) throws CodecException {
        try {
            return (Date)customTypeObject;
        }
        catch (ClassCastException e) {
            throw new CodecException("Date expected", e);
        }
    }
}

