/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.collections.DataFormatException;
import com.genesyslab.platform.commons.collections.KVList;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.TKVSerializer;
import com.genesyslab.platform.commons.collections.TKVXmlSerializer;
import com.genesyslab.platform.commons.collections.processor.KeyValuePrinter;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.protocol.ConfigurationSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.xml.XmlUtil;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TKVCodec
implements AttributeTypeCodec,
ConfigurationSupport,
EncodingSupport {
    public static final String UTF_STRING_KEY = "UTF_STRING";
    private static final int MAX_TKVLIST_PACKED_SIZE = 65535;
    private KeyValuePrinter printer;
    private ConnectionConfiguration config = null;
    private String stringAttributesEncoding = DEFAULT_ENCODING;
    private boolean useUTFStrings = false;

    public ConnectionConfiguration getConfiguration() {
        return this.config;
    }

    public void configure(ConnectionConfiguration config) {
        this.config = config;
        if (config != null) {
            this.setStringAttributesEncoding(config.getOption("string-attributes-encoding"));
            this.useUTFStrings = config.getBoolean(UTF_STRING_KEY, false);
        } else {
            this.setStringAttributesEncoding(null);
            this.useUTFStrings = false;
        }
    }

    public void setStringAttributesEncoding(String strEncoding) {
        this.stringAttributesEncoding = strEncoding != null && !strEncoding.equals("") ? strEncoding : DEFAULT_ENCODING;
    }

    protected String getStringAttributesEncoding() {
        return this.stringAttributesEncoding;
    }

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        byte[] bytes;
        KeyValueCollection list = (KeyValueCollection)customTypeObject;
        try {
            bytes = TKVSerializer.getBytes((KVList)list, (boolean)this.useUTFStrings, (String)this.stringAttributesEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new CodecException("Exception serializing kvlist", ex);
        }
        if (bytes.length <= 65535) {
            return transport.onAttribute(transportState, id, bytes);
        }
        byte[] newBytes = new byte[bytes.length + 2];
        System.arraycopy(bytes, 0, newBytes, 2, bytes.length);
        return transport.onAttribute(transportState, id, newBytes);
    }

    public String getNS() {
        return null;
    }

    public Object decodeFromConnection(Object value, AttributeDescription attributeDescription) throws CodecException {
        if (value instanceof byte[]) {
            try {
                byte[] bytes = (byte[])value;
                if (bytes.length <= 65535) {
                    return TKVSerializer.deserialize((byte[])bytes, (String)this.stringAttributesEncoding);
                }
                return TKVSerializer.deserialize((byte[])bytes, (String)this.stringAttributesEncoding, (int)2, (int)(bytes.length - 2), (boolean)false);
            }
            catch (DataFormatException e) {
                throw new CodecException("Invalid KeyValueCollection", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new CodecException("Invalid KeyValueCollection", e);
            }
        }
        throw new CodecException("Binary data expected. Found: " + value.getClass());
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        if (customTypeObject instanceof KeyValueCollection) {
            KeyValueCollection list = (KeyValueCollection)customTypeObject;
            Document doc = attributeElement instanceof DOMResult ? ((DOMResult)attributeElement).getNode().getOwnerDocument() : CodecUtil.createDocument();
            Element listElement = TKVXmlSerializer.serialize((KeyValueCollection)list, (Document)doc);
            CodecUtil.appendElement(listElement, attributeElement);
        }
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        return this.decodeFromXml(CodecUtil.asElement(attributeElement));
    }

    private Object decodeFromXml(Element attributeElement) throws CodecException {
        Element listElement = XmlUtil.getFirstChild((Element)attributeElement);
        if (listElement == null) {
            throw new CodecException("TKV element expected but not found");
        }
        try {
            return TKVXmlSerializer.deserialize((Element)listElement);
        }
        catch (DataFormatException e) {
            throw new CodecException(e.getMessage(), e);
        }
    }

    public void setProtocolData(Object protocolData) {
        if (protocolData instanceof PrinterStorage) {
            this.printer = ((PrinterStorage)protocolData).getPrinter();
        }
    }

    public void setMessage(Message message) {
    }

    public String getLogType() {
        return "bstr";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) {
        KeyValuePrinter tkvPrinter = this.printer;
        KeyValueCollection list = (KeyValueCollection)customTypeObject;
        if (tkvPrinter == null) {
            tkvPrinter = KeyValuePrinter.getDefaultPrinter();
        }
        tkvPrinter.appendValue(buf, list);
    }

    public static interface PrinterStorage {
        public KeyValuePrinter getPrinter();
    }
}

