/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.commons.broker;

import com.genesyslab.platform.applicationblocks.commons.broker.BrokerServiceBase;
import com.genesyslab.platform.commons.protocol.Receiver;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.SingleThreadInvoker;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageBrokerService<T>
extends BrokerServiceBase<T> {
    private volatile boolean isActive;
    private final Object invokerLock = new Object();
    private final Semaphore threadReady = new Semaphore(1);
    private AsyncInvoker invoker = null;
    private boolean disposeInvoker = false;
    private Runnable receiverHandler = new HandleMessage();
    protected LifecycleStage status = LifecycleStage.Initialized;
    protected final Object lifecycleLock = new Object();

    protected MessageBrokerService() {
    }

    protected MessageBrokerService(AsyncInvoker theInvoker) {
        this.invoker = theInvoker;
        this.disposeInvoker = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncInvoker getInvoker() {
        Object object = this.invokerLock;
        synchronized (object) {
            if (this.invoker == null) {
                this.disposeInvoker = true;
                this.invoker = new SingleThreadInvoker("messageBroker.defaultInvoker");
            }
            return this.invoker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInvoker(AsyncInvoker theInvoker) {
        if (theInvoker == null) {
            throw new NullPointerException("invoker: Value can't be null.");
        }
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.status != LifecycleStage.Initialized) {
                throw new IllegalStateException("Can't change Invoker when broker is active or disposed.");
            }
            Object object2 = this.invokerLock;
            synchronized (object2) {
                this.disposeInvoker();
                this.invoker = theInvoker;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            return this.status == LifecycleStage.Activated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.status == LifecycleStage.Activated) {
                return;
            }
            if (this.status == LifecycleStage.Disposed) {
                throw new IllegalStateException("Can't activate a disposed object.");
            }
            if (this.getGenericReceiver() == null) {
                throw new IllegalStateException("Reciver is null");
            }
            this.switchSubscribersList(new CopyOnWriteArrayList());
            this.isActive = true;
            this.threadReady.tryAcquire();
            this.getInvoker().invoke(this.receiverHandler);
            try {
                this.threadReady.acquire();
                this.status = LifecycleStage.Activated;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.status == LifecycleStage.Initialized) {
                return;
            }
            if (this.status == LifecycleStage.Disposed) {
                throw new IllegalStateException("Can't deactivate a disposed object.");
            }
            this.switchSubscribersList(new LinkedList());
            this.isActive = false;
            Receiver genericReceiver = this.getGenericReceiver();
            if (genericReceiver != null) {
                genericReceiver.releaseReceivers();
            }
            try {
                this.threadReady.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.status = LifecycleStage.Initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.status != LifecycleStage.Disposed) {
                if (this.isActive()) {
                    this.deactivate();
                }
                this.disposeInvoker();
                this.status = LifecycleStage.Disposed;
            }
            this.unregisterAll();
        }
    }

    protected abstract T receive() throws InterruptedException;

    protected abstract Receiver getGenericReceiver();

    private void disposeInvoker() {
        if (this.disposeInvoker) {
            this.invoker.dispose();
            this.disposeInvoker = false;
        }
        this.invoker = null;
    }

    class HandleMessage
    implements Runnable {
        HandleMessage() {
        }

        public void run() {
            MessageBrokerService.this.threadReady.release();
            while (MessageBrokerService.this.isActive) {
                try {
                    Object message = MessageBrokerService.this.receive();
                    if (message == null) continue;
                    MessageBrokerService.this.publish(message);
                }
                catch (InterruptedException interruptedException) {}
            }
            MessageBrokerService.this.threadReady.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LifecycleStage {
        Initialized,
        Activated,
        Disposed;

    }
}

