/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.management.PSDKMBeanBase;
import com.genesyslab.platform.commons.protocol.AbstractChannel;
import com.genesyslab.platform.commons.protocol.ChannelManagerMBean;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolDescriptionSupport;
import com.genesyslab.platform.commons.protocol.Receiver;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ChannelManager
extends PSDKMBeanBase
implements ChannelManagerMBean {
    protected final WeakReference<AbstractChannel> channelRef;
    private AtomicInteger messagesSentCounter = new AtomicInteger(0);
    private AtomicInteger messagesReceivedCounter = new AtomicInteger(0);

    protected ChannelManager(AbstractChannel channel, String mbType, String mbName) {
        super(mbType, mbName, Integer.valueOf(channel.getChannelId()));
        this.channelRef = new WeakReference<AbstractChannel>(channel);
    }

    protected int getChannelId() {
        AbstractChannel channel = (AbstractChannel)this.channelRef.get();
        if (channel != null) {
            return channel.getChannelId();
        }
        return 0;
    }

    public String getEndpoint() {
        Endpoint endpoint;
        AbstractChannel channel = (AbstractChannel)this.channelRef.get();
        if (channel != null && (endpoint = channel.getEndpoint()) != null) {
            return endpoint.toString();
        }
        return null;
    }

    public final String getProtocolDescription() {
        ProtocolDescription protoDescr;
        AbstractChannel channel = (AbstractChannel)this.channelRef.get();
        if (channel instanceof ProtocolDescriptionSupport && (protoDescr = ((ProtocolDescriptionSupport)((Object)channel)).getProtocolDescription()) != null) {
            return protoDescr.toString();
        }
        return null;
    }

    public String getChannelState() {
        AbstractChannel channel = (AbstractChannel)this.channelRef.get();
        if (channel != null) {
            return channel.getState().toString();
        }
        return null;
    }

    public String getChannelConfiguration() {
        ConnectionConfiguration conf;
        Endpoint endpoint;
        AbstractChannel channel = (AbstractChannel)this.channelRef.get();
        if (channel != null && (endpoint = channel.getEndpoint()) != null && (conf = endpoint.getConfiguration()) != null) {
            return conf.toString();
        }
        return null;
    }

    public synchronized void configure(String properties) {
        throw new UnsupportedOperationException();
    }

    public int getProtocolTimeout() {
        AbstractChannel channel = (AbstractChannel)this.channelRef.get();
        if (channel != null) {
            return (int)channel.getTimeout();
        }
        return 0;
    }

    public synchronized void setProtocolTimeout(int timeout) {
        AbstractChannel channel = (AbstractChannel)this.channelRef.get();
        if (channel != null) {
            channel.setTimeout(timeout);
        }
    }

    public int getReceiverInputSize() {
        AbstractChannel channel = (AbstractChannel)this.channelRef.get();
        if (channel instanceof Receiver) {
            return ((Receiver)((Object)channel)).getInputSize();
        }
        return 0;
    }

    public int getMessagesSentNumber() {
        return this.messagesSentCounter.get();
    }

    public void incMessagesSentNumber() {
        this.messagesSentCounter.incrementAndGet();
    }

    public int getMessagesReceivedNumber() {
        return this.messagesReceivedCounter.get();
    }

    public void incMessagesReceivedNumber() {
        this.messagesReceivedCounter.incrementAndGet();
    }
}

