/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Listener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ListenerHelper {
    private static final ILogger log = Log.getLogger(ListenerHelper.class);
    private Queue<Listener> listeners = new ConcurrentLinkedQueue<Listener>();

    public void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void notifyListeners(NotificationVisitor notificationVisitor) {
        int size = this.listeners.size();
        if (log.isDebug() && size > 0) {
            log.debugFormat("Notifying {0} listener(s)", (Object)size);
        }
        int success = 0;
        for (Listener listener : this.listeners) {
            try {
                notificationVisitor.visitListener(listener);
                ++success;
            }
            catch (Throwable e) {
                log.debug((Object)"Exception in listener", e);
            }
        }
        if (log.isDebug() && size > 0) {
            log.debugFormat("{0} listener(s) understood the event right", (Object)success);
        }
    }

    public static interface NotificationVisitor {
        public void visitListener(Listener var1);
    }
}

