/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth;

import com.genesyslab.platform.commons.protocol.auth.GssOptions;
import com.genesyslab.platform.commons.protocol.auth.KerberosUtil;
import java.security.PrivilegedExceptionAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AcquireKerberosTicketAction
implements PrivilegedExceptionAction<byte[]> {
    private String userPrincipalName;
    private String servicePrincipalName;
    private GssOptions options;

    public AcquireKerberosTicketAction(String userPrincipalName, String servicePrincipalName, GssOptions options) {
        if (null == userPrincipalName) {
            throw new IllegalArgumentException("userPrincipalName must not be null");
        }
        if (0 == userPrincipalName.length()) {
            throw new IllegalArgumentException("userPrincipalName must not be empty");
        }
        this.userPrincipalName = userPrincipalName;
        if (null == servicePrincipalName) {
            throw new IllegalArgumentException("servicePrincipalName must not be null");
        }
        if (0 == servicePrincipalName.length()) {
            throw new IllegalArgumentException("servicePrincipalName must not be empty");
        }
        this.servicePrincipalName = servicePrincipalName;
        if (null == options) {
            throw new IllegalArgumentException("options must not be null");
        }
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] run() throws GSSException {
        Oid kerb5Oid = KerberosUtil.getKerberos5Oid();
        Oid kerb5PrincipalNameOid = KerberosUtil.getKerberosPrincipalNameOid();
        GSSManager manager = GSSManager.getInstance();
        GSSName clientName = manager.createName(this.userPrincipalName, kerb5PrincipalNameOid);
        GSSCredential clientCred = manager.createCredential(clientName, this.options.getCredLifetime(), kerb5Oid, 1);
        GSSName serverName = manager.createName(this.servicePrincipalName, kerb5PrincipalNameOid);
        GSSContext context = manager.createContext(serverName, kerb5Oid, clientCred, this.options.getContextLifetime());
        try {
            context.requestMutualAuth(this.options.isMutualAuth());
            context.requestConf(this.options.isDataConf());
            context.requestInteg(this.options.isDataIntegrity());
            context.requestAnonymity(this.options.isAnonymity());
            context.requestCredDeleg(this.options.isCredDeleg());
            context.requestReplayDet(this.options.isReplayDet());
            context.requestSequenceDet(this.options.isSequenceDet());
            byte[] byArray = context.initSecContext(new byte[0], 0, 0);
            return byArray;
        }
        finally {
            context.dispose();
        }
    }
}

