/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.auth.AuthTicketAcquirer;
import com.genesyslab.platform.commons.protocol.auth.KerberosTicketAcquirer;

public class DefaultAuthTicketAcquirer {
    private static final ILogger log = Log.getLogger(KerberosTicketAcquirer.class);
    public static final String SYSPROP_TICKET_ACQUIRER = "com.genesys.protocol.auth.ticket.acquirer";
    private static AuthTicketAcquirer INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthTicketAcquirer getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DefaultAuthTicketAcquirer> clazz = DefaultAuthTicketAcquirer.class;
        synchronized (DefaultAuthTicketAcquirer.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = DefaultAuthTicketAcquirer.create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static AuthTicketAcquirer create() {
        String acquirerClassName = System.getProperty(SYSPROP_TICKET_ACQUIRER);
        if (acquirerClassName != null && acquirerClassName.length() > 0) {
            try {
                log.info((Object)("Creating default auth ticket acquirer: " + acquirerClassName));
                AuthTicketAcquirer provider = (AuthTicketAcquirer)Class.forName(acquirerClassName).newInstance();
                return provider;
            }
            catch (Throwable e) {
                log.error((Object)("error create default auth ticket acqurer: " + acquirerClassName), e);
            }
        }
        try {
            log.info((Object)"Creating default auth ticket acquirer: KerberosTicketAcquirer");
            return new KerberosTicketAcquirer();
        }
        catch (Throwable e) {
            log.error((Object)"error create default auth ticket acquirer: KerberosTicketAcquirer", e);
            return null;
        }
    }
}

