/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;

public class AttributeDescription {
    private String id;
    private final String name;
    private final Class valueType;
    private final Class enumClass;
    private final boolean logHidden;
    private final boolean serializationHidden;
    protected String logSignature;
    private boolean hidden = false;

    public AttributeDescription(String id, String name, Class valueType, Class enumClass, String logSignature, boolean logHidden) {
        this(id, name, valueType, enumClass, logSignature, false, logHidden);
    }

    public AttributeDescription(String id, String name, Class valueType, Class enumClass, String logSignature, boolean srlzHidden, boolean logHidden) {
        this(name, valueType, enumClass, logSignature, srlzHidden, logHidden);
        this.id = id;
    }

    private AttributeDescription(String name, Class valueType, Class enumClass, String logSignature, boolean srlzHidden, boolean logHidden) {
        this.name = name;
        this.valueType = valueType;
        this.enumClass = enumClass;
        this.logSignature = logSignature;
        this.serializationHidden = srlzHidden;
        this.logHidden = logHidden;
    }

    public boolean hasCodec() {
        return false;
    }

    public CustomTypeCodec createCodec(Message message, Object protocolData) {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public boolean isEnumProperty() {
        return this.enumClass != null || GEnum.class.isAssignableFrom(this.valueType);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHideable() {
        return this.logHidden;
    }

    public boolean isSerializationHidden() {
        return this.serializationHidden;
    }

    public Class getEnumClass() {
        return this.enumClass;
    }

    public String getLogSignature() {
        if (this.logSignature == null) {
            return this.name;
        }
        return this.logSignature;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributeDescription)) {
            return false;
        }
        return ((AttributeDescription)obj).id.equals(this.id);
    }

    public String toString() {
        return this.name;
    }
}

