/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.AttributeSubscriptionList;
import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.connection.impl.xml.XmlStructureHandler;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ConfigurationSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.MissingAttributeException;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.runtime.AbstractCodecAttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecAttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecSupport;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.LazyParsingPossible;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomPackager;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.EnumCodec;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ProtocolMessagePackagerImpl
implements MessagePackager,
XmlStructureHandler,
CodecSupport {
    private final ILogger log = Log.getLogger(ProtocolMessagePackagerImpl.class);
    private ConnectionImpl conn;
    private ProtocolFactory factory;
    private MessageHandler messageHandler;
    private ErrorHandler errorHandler;
    private Object protocolData;
    private ConnectionConfiguration config;

    public ProtocolMessagePackagerImpl(ProtocolFactory factory, ConnectionConfiguration config, MessageHandler messageHandler, ErrorHandler errorHandler) {
        this.factory = factory;
        this.config = config;
        this.messageHandler = messageHandler;
        this.errorHandler = errorHandler;
    }

    public void configure(ConnectionConfiguration config) {
        this.config = config;
    }

    public boolean isLazyParsingEnabled() {
        if (this.config != null) {
            return this.config.getBoolean("lazy_parsing_enabled", true);
        }
        return true;
    }

    public void sendMessage(Object message) throws PlatformException {
        Message msg = (Message)message;
        MessageTransport transport = this.conn.getConnection().getMessageTransport();
        try {
            Object state = transport.onNewMessage(null, msg.messageId());
            DataSupport ds = MetaData.asDataSupport(msg);
            this.transportData(transport, state, ds, msg);
            transport.onMessageEnd(state);
        }
        catch (PlatformException e) {
            this.log.warn((Object)"Problems sending message", (Throwable)e);
            throw e;
        }
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private void transportData(MessageTransport transport, Object state, DataSupport data, Message message) throws PlatformException {
        Map attributes;
        Map compounds = data.getCompounds();
        if (compounds != null) {
            this.transportCompounds(transport, state, compounds, message);
        }
        if ((attributes = data.attributes()) != null) {
            this.transportFlatAttributes(transport, state, attributes, data, message);
        }
    }

    private void transportFlatAttributes(MessageTransport transport, Object state, Map attributes, DataSupport data, Message message) throws PlatformException {
        MetaData meta = data.getMetaData();
        for (Map.Entry o : attributes.entrySet()) {
            Map.Entry entry = o;
            Object value = entry.getValue();
            if (value == null) continue;
            String key = entry.getKey().toString();
            state = this.transportAttribute(message, transport, state, meta.getAttributeDescription(key), value);
        }
    }

    private Object transportAttribute(Message message, MessageTransport transport, Object state, AttributeDescription key, Object value) throws PlatformException {
        CustomTypeCodec codec = this.getCodec(key, message);
        if (codec != null) {
            codec.setMessage(message);
            return codec.encodeForConnection(value, key.getId(), transport, state);
        }
        if (value instanceof Integer) {
            return transport.onAttribute(state, key.getId(), ((Integer)value).intValue());
        }
        if (value instanceof String) {
            return transport.onAttribute(state, key.getId(), (String)value);
        }
        if (value instanceof Long) {
            return transport.onAttribute(state, key.getId(), ((Long)value).longValue());
        }
        if (value instanceof byte[]) {
            return transport.onAttribute(state, key.getId(), (byte[])value);
        }
        String errMsg = "Unknonw type: " + value.getClass().getName() + "; attrId: " + key;
        this.log.debug((Object)errMsg);
        throw new RuntimeException("Codec expected, but not found");
    }

    private void transportCompounds(MessageTransport transport, Object state, Map compounds, Message message) throws PlatformException {
        if (compounds.isEmpty()) {
            return;
        }
        boolean isXml = transport instanceof XmlStructureHandler;
        for (Object compound : compounds.values()) {
            if (compound == null) continue;
            DataSupport data = MetaData.asDataSupport(compound);
            String id = data.getMetaData().getId();
            if (isXml) {
                ((XmlStructureHandler)transport).onComplexAttribute(state, id, null);
            }
            this.transportData(transport, state, data, message);
            if (!isXml) continue;
            ((XmlStructureHandler)transport).onComplexEnd(state, id);
        }
    }

    public void setConnection(ConnectionImpl connection) {
        this.conn = connection;
    }

    public Object onNewMessage(Object state, int messageId) throws ProtocolException {
        Message message;
        if (this.log.isDebug()) {
            this.log.debug((Object)("New message #" + messageId));
        }
        try {
            message = this.factory.createMessage(messageId);
        }
        catch (IllegalArgumentException e) {
            ProtocolException error = new ProtocolException("Failed to create message #" + messageId, e);
            this.errorHandler.handleError(error);
            throw error;
        }
        DataSupport dataSupport = MetaData.asDataSupport(message);
        List packagers = dataSupport.getCustomPackagers();
        if (packagers != null) {
            this.initPackagers(packagers, message);
        }
        return message;
    }

    public Object onAttribute(Object state, String id, String value) throws PlatformException {
        DataSupport dataSupport = MetaData.asDataSupport(state);
        MetaData meta = dataSupport.getMetaData();
        AttributeDescription key = meta.getAttributeDescription(id);
        Class valueType = null;
        if (key != null) {
            valueType = key.getValueType();
        }
        if (valueType == null || String.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, value);
        } else if (Integer.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, new Integer(value));
        } else if (Long.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, new Long(value));
        } else {
            this.storeAttribute(dataSupport, id, value);
        }
        return state;
    }

    public Object onAttribute(Object state, String id, int value) throws PlatformException {
        this.storeAttribute(MetaData.asDataSupport(state), id, value);
        return state;
    }

    public Object onAttribute(Object state, String id, byte[] value) throws PlatformException {
        this.storeAttribute(MetaData.asDataSupport(state), id, value);
        return state;
    }

    public Object onAttribute(Object state, String id, long value) throws PlatformException {
        this.storeAttribute(MetaData.asDataSupport(state), id, value);
        return state;
    }

    private void storeAttribute(DataSupport dataSupport, String id, Object value) throws PlatformException {
        Message message = this.asMessage(dataSupport);
        boolean resSubscr = this.processSubscription(message, id, value);
        if (resSubscr) {
            return;
        }
        try {
            boolean res = this.doStoreAttribute(dataSupport, message, id, value);
            if (!resSubscr && !res) {
                this.complainMissingAttribute(dataSupport, id, value);
            }
        }
        catch (PlatformException e) {
            this.errorHandler.handleError(new ProtocolException("Exception parsing message", e));
            throw e;
        }
        catch (Exception e) {
            ProtocolException protoException = new ProtocolException("Exception parsing message", e);
            this.errorHandler.handleError(protoException);
            throw protoException;
        }
    }

    private boolean processSubscription(Message msg, String id, Object value) {
        if (this.conn == null || msg == null || id == null || "".equals(id)) {
            return false;
        }
        int msgId = msg.messageId();
        if (AttributeSubscriptionList.attributeSubscribed((ConnectionContext)this.conn.context(), (int)msgId, (String)id)) {
            ((DataSupport)((Object)msg)).attributes().put(id, value);
            if (this.log.isDebug()) {
                this.log.debugFormat("User has subscription on attribute {0} in message {1}", (Object)new Object[]{id, msgId});
            }
            return true;
        }
        return false;
    }

    private Message asMessage(DataSupport dataSupport) {
        Message message = null;
        if (dataSupport instanceof Message) {
            message = (Message)((Object)dataSupport);
        }
        return message;
    }

    public Object onMessageEnd(Object state) throws CodecException {
        DataSupport msg = MetaData.asDataSupport(state);
        List packagers = msg.getCustomPackagers();
        if (packagers != null) {
            boolean lazyEnabled = this.isLazyParsingEnabled();
            for (Object codecO : packagers) {
                LazyParsingPossible iLazy;
                Map.Entry det;
                CustomPackager codec = null;
                if (codecO instanceof CustomPackager) {
                    codec = (CustomPackager)codecO;
                }
                if (codec == null) continue;
                if (lazyEnabled && (det = this.findAttributeInfo(msg, codec)) != null && det.getValue() instanceof CodecAttributeDescription && (iLazy = (LazyParsingPossible)det.getValue()).isLazyParsingPossible()) {
                    String key = ((CodecAttributeDescription)det.getValue()).getName();
                    msg.getLazyParser().addAction(key, codec, (AttributeDescription)((Object)iLazy));
                    msg.attributes().put(key, null);
                    continue;
                }
                codec.onMessageEnd();
            }
        }
        if (this.messageHandler != null) {
            this.messageHandler.onMessage((Message)state);
        } else {
            this.log.warn((Object)"MessageHandler is null in MessagePackager");
        }
        return state;
    }

    private Map.Entry findAttributeInfo(DataSupport msg, CustomPackager packager) {
        if (msg == null || packager == null) {
            return null;
        }
        Map attrs = msg.getMetaData().getAttributesDescriptions();
        for (Map.Entry obj : attrs.entrySet()) {
            AbstractCodecAttributeDescription acai;
            Map.Entry entry = obj;
            if (!(entry.getValue() instanceof AbstractCodecAttributeDescription) || !(acai = (AbstractCodecAttributeDescription)entry.getValue()).isSameCodec(packager)) continue;
            return entry;
        }
        return null;
    }

    public boolean needsProcessing(Object state, String attributeId, Element complexElement) {
        CustomTypeCodec codec;
        DataSupport data = MetaData.asDataSupport(state);
        AttributeDescription attrDesc = data.getMetaData().getAttributeDescription(attributeId);
        if (attrDesc != null && (codec = this.getCodec(attrDesc, data)) instanceof XmlStructureHandler) {
            XmlStructureHandler handler = (XmlStructureHandler)codec;
            return handler.needsProcessing(state, attributeId, complexElement);
        }
        return true;
    }

    public Object onComplexAttribute(Object state, String attributeId, Element elem) throws PlatformException {
        DataSupport data = MetaData.asDataSupport(state);
        Object currentState = null;
        MetaData metaData = data.getMetaData();
        AttributeDescription attrDesc = metaData.getAttributeDescription(attributeId);
        if (attrDesc != null) {
            CustomTypeCodec codec = this.getCodec(attrDesc, data);
            if (codec instanceof XmlStructureHandler) {
                currentState = this.encodeByCodec(codec, state, attributeId, elem);
            }
        } else {
            String attrId = this.useTagMappings(attributeId, metaData);
            currentState = data.getCompounds().get(attrId);
            if (currentState == null) {
                try {
                    Class clazz = (Class)metaData.getCompoundProperties().get(attrId);
                    if (clazz != null && (currentState = MetaData.createCompound(clazz)) != null) {
                        data.getCompounds().put(attrId, currentState);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (this.log.isDebug() && currentState == null) {
            this.log.debugFormat("Null state in {0} for id = {1}", (Object)new Object[]{data.getClass(), attributeId});
        }
        if (currentState == null) {
            currentState = state;
        }
        return currentState;
    }

    private String useTagMappings(String attributeId, MetaData metaData) {
        String attrId = null;
        Map mappings = metaData.getTagMappings();
        if (mappings != null) {
            attrId = (String)mappings.get(attributeId);
        }
        if (attrId == null) {
            attrId = attributeId;
        }
        return attrId;
    }

    private Object encodeByCodec(CustomTypeCodec codec, Object state, String attributeId, Element elem) throws PlatformException {
        XmlStructureHandler handler = (XmlStructureHandler)codec;
        Object currentState = handler.onComplexAttribute(state, attributeId, elem);
        if (this.log.isDebug() && currentState == null) {
            this.log.debugFormat("State is null from ''{0}''", (Object)handler);
        }
        return currentState;
    }

    public Object onComplexEnd(Object state, String attributeId) {
        return state;
    }

    public void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
    }

    public Object getProtocolData() {
        return this.protocolData;
    }

    private void initPackagers(List packagers, Message message) {
        String strEncoding = null;
        if (this.conn != null) {
            strEncoding = this.conn.getStringAttributesEncoding();
        }
        for (Object packager : packagers) {
            CustomPackager codec = (CustomPackager)packager;
            if (this.protocolData != null) {
                codec.setMessage(message);
                codec.setProtocolData(this.protocolData);
                if (codec instanceof ConfigurationSupport) {
                    ((ConfigurationSupport)((Object)codec)).configure(this.config);
                }
                if (codec instanceof EncodingSupport) {
                    ((EncodingSupport)codec).setStringAttributesEncoding(strEncoding);
                }
            }
            codec.onMessageStart(message);
        }
    }

    private boolean doStoreAttribute(DataSupport dataSupport, Message message, String id, Object value) throws PlatformException {
        this.notifyCustomPackagers(dataSupport, id, value);
        AttributeDescription key = dataSupport.getMetaData().getAttributeDescription(id);
        if (key != null) {
            CustomTypeCodec codec = this.getCodec(key, message);
            if (codec != null) {
                if (codec instanceof AttributeTypeCodec) {
                    value = ((AttributeTypeCodec)codec).decodeFromConnection(value, key);
                } else {
                    return true;
                }
            }
            dataSupport.attributes().put(key.getName(), this.convertValue(key, value, dataSupport));
            return true;
        }
        Map compounds = dataSupport.getCompounds();
        if (compounds == null) {
            return false;
        }
        for (Object o : compounds.values()) {
            DataSupport ds = MetaData.asDataSupport(o);
            boolean accepted = this.doStoreAttribute(ds, message, id, value);
            if (!accepted) continue;
            return true;
        }
        Map compsMeta = dataSupport.getMetaData().getCompoundProperties();
        if (compsMeta == null) {
            return false;
        }
        for (Map.Entry o : compsMeta.entrySet()) {
            Map.Entry entry = o;
            DataSupport ds = (DataSupport)compounds.get((String)entry.getKey());
            if (ds != null || (ds = (DataSupport)MetaData.createCompound((Class)entry.getValue())) == null || !this.doStoreAttribute(ds, message, id, value)) continue;
            compounds.put(entry.getKey(), ds);
            return true;
        }
        return false;
    }

    private Object convertValue(AttributeDescription key, Object value, DataSupport dataSupport) {
        CustomTypeCodec codec;
        if (key.hasCodec() && (codec = this.getCodec(key, dataSupport)) instanceof AttributeTypeCodec && key instanceof LazyParsingPossible && ((LazyParsingPossible)((Object)key)).isLazyParsingPossible() && this.isLazyParsingEnabled()) {
            dataSupport.getLazyParser().addAction(key.getName(), (AttributeTypeCodec)codec, key, value);
            return null;
        }
        if (value instanceof Integer && key.getValueType() == Long.class) {
            return new Long(((Integer)value).longValue());
        }
        return value;
    }

    private void notifyCustomPackagers(DataSupport dataSupport, String id, Object value) throws CodecException {
        List customPackagers = dataSupport.getCustomPackagers();
        if (customPackagers != null) {
            for (Object customPackager : customPackagers) {
                CustomPackager packager = (CustomPackager)customPackager;
                packager.onAttribute(id, value);
            }
        }
    }

    private CustomTypeCodec getCodec(AttributeDescription key, Message message) {
        CustomTypeCodec codec = key.createCodec(message, this.protocolData);
        if (codec == null && key.isEnumProperty()) {
            codec = new EnumCodec();
        }
        if (codec instanceof ConfigurationSupport) {
            ((ConfigurationSupport)((Object)codec)).configure(this.config);
        }
        if (codec instanceof EncodingSupport && this.conn != null) {
            ((EncodingSupport)codec).setStringAttributesEncoding(this.conn.getStringAttributesEncoding());
        }
        return codec;
    }

    private CustomTypeCodec getCodec(AttributeDescription key, DataSupport ds) {
        Message message = this.asMessage(ds);
        return this.getCodec(key, message);
    }

    private void complainMissingAttribute(DataSupport ds, String attrId, Object value) {
        MetaData data = ds.getMetaData();
        if (this.errorHandler != null) {
            MissingAttributeException e = new MissingAttributeException("Attribute is not accepted by the message.", data.getId(), attrId);
            this.errorHandler.handleError(e);
        }
        if (this.log.isDebug()) {
            this.log.debug((Object)("Attribute is not accepted by the message.attrId '" + attrId + "'(" + value.getClass().getSimpleName() + ") in msg '" + data.getId() + "/" + data.getName()));
        }
    }

    public static interface ErrorHandler {
        public void handleError(ProtocolException var1);
    }

    public static interface MessageHandler {
        public void onMessage(Message var1);
    }
}

