/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.channel;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GrowingBlockingQueue<T>
implements BlockingQueue<T> {
    private BlockingQueue<T> queue;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();

    public GrowingBlockingQueue(BlockingQueue<T> queue) {
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        this.readLock.lock();
        try {
            Object e = this.queue.poll();
            return (T)e;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove() {
        this.readLock.lock();
        try {
            Object e = this.queue.remove();
            return (T)e;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        this.readLock.lock();
        try {
            Object e = this.queue.peek();
            return (T)e;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T element() {
        this.readLock.lock();
        try {
            Object e = this.queue.element();
            return (T)e;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.queue.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.readLock.lock();
        try {
            boolean bl = this.queue.contains(o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        this.readLock.lock();
        try {
            Iterator iterator = this.queue.iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = this.queue.toArray();
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        this.readLock.lock();
        try {
            T[] TArray = this.queue.toArray(a);
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.readLock.lock();
        try {
            boolean bl = this.queue.remove(o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        this.readLock.lock();
        try {
            boolean bl = this.queue.containsAll(c);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.readLock.lock();
        try {
            boolean bl = this.queue.addAll(c);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.readLock.lock();
        try {
            boolean bl = this.queue.removeAll(c);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.readLock.lock();
        try {
            boolean bl = this.queue.retainAll(c);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.readLock.lock();
        try {
            this.queue.clear();
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T o) {
        this.readLock.lock();
        try {
            boolean bl = this.queue.offer(o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T o, long timeout, TimeUnit unit) throws InterruptedException {
        this.readLock.lock();
        try {
            boolean bl = this.queue.offer(o, timeout, unit);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.readLock.lock();
        try {
            T t = this.queue.poll(timeout, unit);
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T take() throws InterruptedException {
        this.readLock.lock();
        try {
            T t = this.queue.take();
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T o) throws InterruptedException {
        this.readLock.lock();
        try {
            this.queue.put(o);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        this.readLock.lock();
        try {
            int n = this.queue.remainingCapacity();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T o) {
        this.readLock.lock();
        try {
            boolean bl = this.queue.add(o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super T> c) {
        this.readLock.lock();
        try {
            int n = this.queue.drainTo(c);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        this.readLock.lock();
        try {
            int n = this.queue.drainTo(c, maxElements);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public abstract BlockingQueue<T> createQueue(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrowingBlockingQueue<T> growQueue(int newSize) {
        int size = this.size();
        if (newSize <= size) {
            throw new IllegalArgumentException("new size should be more then old one");
        }
        this.writeLock.lock();
        try {
            BlockingQueue<T> oldQueue = this.queue;
            this.queue = this.createQueue(newSize);
            this.queue.addAll(oldQueue);
            GrowingBlockingQueue growingBlockingQueue = this;
            return growingBlockingQueue;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public GrowingBlockingQueue<T> growQueueByFactor(float factor) {
        if (factor <= 1.0f) {
            throw new IllegalArgumentException("factor should be more then 1");
        }
        return this.growQueue((int)((float)this.size() * factor));
    }
}

