/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.NoDataCodec;
import com.genesyslab.platform.commons.xml.XmlUtil;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.w3c.dom.Element;

public class BooleanCodec
extends NoDataCodec
implements AttributeTypeCodec {
    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        Boolean b = this.asBoolean(customTypeObject);
        if (b.booleanValue()) {
            return transport.onAttribute(transportState, id, 1);
        }
        return transport.onAttribute(transportState, id, 0);
    }

    public Object decodeFromConnection(Object value, AttributeDescription attributeDescription) throws CodecException {
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            if (i == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (value instanceof String) {
            String s = (String)value;
            if ("true".equalsIgnoreCase(s)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(s)) {
                return Boolean.FALSE;
            }
            try {
                return this.decodeFromConnection(new Integer(s), attributeDescription);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        throw new CodecException("Can't parse Boolean from '" + value);
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        Boolean b = this.asBoolean(customTypeObject);
        String val = b != false ? "1" : "0";
        CodecUtil.appendText(val, attributeElement);
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        return this.decodeFromXml(CodecUtil.asElement(attributeElement));
    }

    private Object decodeFromXml(Element attributeElement) {
        String val = XmlUtil.getElementText((Element)attributeElement);
        if (val.trim().equals("0")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getLogType() {
        return "bool";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) throws CodecException {
        Boolean b = this.asBoolean(customTypeObject);
        buf.append(b);
    }

    private Boolean asBoolean(Object customTypeObject) throws CodecException {
        try {
            return (Boolean)customTypeObject;
        }
        catch (ClassCastException e) {
            throw new CodecException("Boolean expected", e);
        }
    }
}

