/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.MessageProducer;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.UnsupportedEncodingException;

public class CommonMessageProducerImpl
implements MessageProducer {
    private static final ILogger log = Log.getLogger(CommonMessageProducerImpl.class);
    private byte[] buf;
    private int pos;
    private MessagePackager packager;
    private String stringAttributesEncoding;

    public CommonMessageProducerImpl(byte[] buf, int pos, MessagePackager packager, String strAttrEncoding) {
        this.buf = buf;
        this.pos = pos;
        this.packager = packager;
        this.stringAttributesEncoding = strAttrEncoding;
    }

    public void parse() throws InvalidPacketException {
        int attrCount = this.buf[this.pos++];
        int messageId = this.getInt();
        try {
            Object message = this.packager.onNewMessage(null, messageId);
            for (int i = 0; i < attrCount; ++i) {
                int attrId = this.getInt();
                char attrType = this.getAttrType();
                message = this.addObject(message, String.valueOf(attrId), attrType);
            }
            this.packager.onMessageEnd(message);
        }
        catch (PlatformException e) {
            throw new InvalidPacketException("Problems parsing message", e);
        }
    }

    private Object addObject(Object message, String attrId, char attrType) throws PlatformException {
        Object newMessage = null;
        switch (attrType) {
            case 'i': {
                newMessage = this.packager.onAttribute(message, attrId, this.getInt());
                break;
            }
            case 's': {
                newMessage = this.packager.onAttribute(message, attrId, this.getStringAttr());
                break;
            }
            case 'b': {
                newMessage = this.packager.onAttribute(message, attrId, this.getBinaryAttr());
                break;
            }
            case 'B': {
                newMessage = this.packager.onAttribute(message, attrId, this.getLongBinaryAttr());
                break;
            }
            case 'S': {
                newMessage = this.packager.onAttribute(message, attrId, this.getLongStringAttrValue());
                break;
            }
            case 'l': {
                newMessage = this.packager.onAttribute(message, attrId, this.getLong());
                break;
            }
            default: {
                if (!log.isWarn()) break;
                log.warn((Object)("Unknown attribute type: '" + attrType));
            }
        }
        return newMessage;
    }

    private int getShort() {
        return (0xFF00 & this.buf[this.pos++] << 8) + (0xFF & this.buf[this.pos++]);
    }

    private byte[] getBinaryAttr() {
        int slen = this.getShort() - 2;
        byte[] bb = new byte[slen];
        System.arraycopy(this.buf, this.pos, bb, 0, slen);
        this.pos += slen;
        return bb;
    }

    private byte[] getLongBinaryAttr() {
        int slen = this.getInt();
        byte[] bb = new byte[slen];
        System.arraycopy(this.buf, this.pos, bb, 0, slen);
        this.pos += slen;
        return bb;
    }

    private String getStringAttr() {
        int slen = this.getShort();
        String str = this.bytes2string(this.buf, this.pos, slen);
        this.pos += slen;
        return str;
    }

    private String getLongStringAttrValue() {
        int slen = this.getInt();
        String str = this.bytes2string(this.buf, this.pos, slen);
        this.pos += slen;
        return str;
    }

    private char getAttrType() {
        return (char)this.buf[this.pos++];
    }

    private int getInt() {
        int i = CommonMessageProducerImpl.getInt(this.buf, this.pos);
        this.pos += 4;
        return i;
    }

    static int getInt(byte[] bb, int offset) {
        int currOfset = offset;
        return (0xFF000000 & bb[currOfset++] << 24) + (0xFF0000 & bb[currOfset++] << 16) + (0xFF00 & bb[currOfset++] << 8) + (0xFF & bb[currOfset]);
    }

    private long getLong() {
        return (0xFF00000000000000L & (long)this.buf[this.pos++] << 56) + (0xFF000000000000L & (long)this.buf[this.pos++] << 48) + (0xFF0000000000L & (long)this.buf[this.pos++] << 40) + (0xFF00000000L & (long)this.buf[this.pos++] << 32) + (0xFF000000L & (long)this.buf[this.pos++] << 24) + (0xFF0000L & (long)this.buf[this.pos++] << 16) + (0xFF00L & (long)this.buf[this.pos++] << 8) + (0xFFL & (long)this.buf[this.pos++]);
    }

    private String bytes2string(byte[] bytes, int pos, int len) {
        if (this.stringAttributesEncoding == null) {
            return new String(bytes, pos, len);
        }
        try {
            return new String(bytes, pos, len, this.stringAttributesEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

