/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.collections.KVList;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.TKVSerializer;
import com.genesyslab.platform.commons.connection.ConnectionMessage;
import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

public class ConnectionMessagePackagerImpl
implements MessagePackager {
    private static final ILogger log = Log.getLogger(ConnectionMessagePackagerImpl.class);
    private ConnectionImpl conn;
    private MessageHandler handler;

    public void configure(ConnectionConfiguration config) {
    }

    public void sendMessage(Object message) throws PlatformException {
        Object state;
        MessageTransport transport;
        if (message instanceof ConnectionMessage) {
            ConnectionMessage msg = (ConnectionMessage)message;
            transport = this.conn.getConnection().getMessageTransport();
            state = transport.onNewMessage(null, msg.getMessageId());
            Iterator attrs = msg.getEntries();
            while (attrs.hasNext()) {
                Map.Entry entry = (Map.Entry)attrs.next();
                Integer id = (Integer)entry.getKey();
                Object value = entry.getValue();
                state = this.transportAttribute(transport, state, id, value);
            }
        } else {
            throw new IllegalArgumentException("ConnectionMessage expectedas message");
        }
        transport.onMessageEnd(state);
    }

    public void setConnection(ConnectionImpl connection) {
        this.conn = connection;
    }

    public Object onNewMessage(Object state, int messageId) {
        return new ConnectionMessage(messageId);
    }

    public Object onAttribute(Object state, String id, String value) throws PlatformException {
        ConnectionMessage message = (ConnectionMessage)state;
        message.add(this.asInt(id), value);
        return message;
    }

    public Object onAttribute(Object state, String id, int value) throws PlatformException {
        ConnectionMessage message = (ConnectionMessage)state;
        message.add(this.asInt(id), value);
        return message;
    }

    public Object onAttribute(Object state, String id, byte[] value) throws PlatformException {
        ConnectionMessage message = (ConnectionMessage)state;
        message.add(this.asInt(id), value);
        return message;
    }

    public Object onAttribute(Object state, String id, long value) throws PlatformException {
        ConnectionMessage message = (ConnectionMessage)state;
        message.add(this.asInt(id), value);
        return message;
    }

    public Object onMessageEnd(Object state) {
        ConnectionMessage message = (ConnectionMessage)state;
        this.fireMessageEvent(message);
        return message;
    }

    public Object onComplexAttribute(Object state, String attributeId) {
        return state;
    }

    public Object onComplexEnd(Object state, String attributeId) {
        return state;
    }

    private int asInt(String id) throws PlatformException {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException ex) {
            throw new PlatformException("Exception parsing interger value '" + id + "'", (Throwable)ex);
        }
    }

    private void fireMessageEvent(ConnectionMessage msg) {
        if (log.isDebug()) {
            log.debug((Object)("Firing event about message: " + msg.toString()));
        }
        if (this.handler != null) {
            try {
                this.handler.onMessage(msg);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception in message handler", e);
            }
        } else {
            log.debug((Object)"Handler is null in ConnectionMessagePackagerImpl");
        }
    }

    public void setMessageHandler(MessageHandler handler) {
        this.handler = handler;
    }

    private Object transportAttribute(MessageTransport transport, Object state, int id, Object value) throws PlatformException {
        Object newState = null;
        if (value instanceof String) {
            newState = transport.onAttribute(state, String.valueOf(id), (String)value);
        } else if (value instanceof Integer) {
            newState = transport.onAttribute(state, String.valueOf(id), (Integer)value);
        } else if (value instanceof byte[]) {
            newState = transport.onAttribute(state, String.valueOf(id), (byte[])value);
        } else if (value instanceof Long) {
            newState = transport.onAttribute(state, String.valueOf(id), (Long)value);
        } else if (value instanceof KeyValueCollection) {
            byte[] b;
            try {
                b = TKVSerializer.getBytes((KVList)((KeyValueCollection)value), (String)this.conn.getStringAttributesEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
            newState = transport.onAttribute(state, String.valueOf(id), b);
        } else if (log.isWarn()) {
            log.warn((Object)("Unsupported attribute type in ConnectionMessage: " + value));
        }
        return newState;
    }

    public static interface MessageHandler {
        public void onMessage(ConnectionMessage var1);
    }
}

