/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.mux;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.impl.AbstractConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.connection.impl.mux.BufferWritePoint;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class UdpConnectionImpl
extends AbstractConnectionImpl
implements Connection,
ConnectionImpl {
    private DatagramChannel channel;
    private final UdpWritePipeImpl writePipe = new UdpWritePipeImpl();
    private final ILogger log = Log.getLogger(UdpConnectionImpl.class);
    private String udpUri = null;

    public void open() {
        super.open();
        try {
            this.log.debugFormat("Opening UdpConnection {0}", (Object)this);
            this.setConnectionState(ConnectionState.OPENING);
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            this.configureLocalEndpoint();
            if (this.address == null) {
                this.address = new InetSocketAddress(this.host, this.port);
            }
            this.channel.connect(this.address);
            this.setConnectionState(ConnectionState.OPENED);
            this.notifyEstablishedHandler();
        }
        catch (IOException e) {
            this.log.debug((Object)("Failed to connect to SocketChannel '" + this), (Throwable)e);
            this.forceClose(e);
            return;
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)("Failed to connect to SocketChannel '" + this), (Throwable)e);
            this.forceClose(e);
            return;
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)("Failed to connect to SocketChannel '" + this), (Throwable)e);
            this.forceClose(e);
            return;
        }
        this.log.debugFormat("Connection sequence initiated for {0}", (Object)this);
    }

    public void attach(DatagramChannel channel) throws IOException {
        this.setConnectionState(ConnectionState.OPENING);
        this.log.debugFormat("Attaching to io channel : {0} on connection {1}", (Object)new Object[]{channel, this});
        this.channel = channel;
        channel.configureBlocking(false);
        DatagramSocket socket = channel.socket();
        InetAddress inetAddress = socket.getInetAddress();
        this.host = inetAddress.getHostName();
        this.port = socket.getPort();
        this.address = new InetSocketAddress(inetAddress, this.port);
        this.udpUri = null;
        this.setConnectionState(ConnectionState.OPENED);
    }

    public String getUri() {
        if (this.udpUri == null && this.host != null) {
            this.udpUri = "udp://" + this.host + ':' + this.port;
        }
        return this.udpUri;
    }

    public WritePipe getWritePipe() {
        return this.writePipe;
    }

    public DatagramChannel getChannel() {
        return this.channel;
    }

    protected void startClose(Throwable closeReason) {
        this.writePipe.close(closeReason);
    }

    protected void doClose(Throwable closeReason) {
        this.log.debugFormat("Closing UdpConnection: {0}", (Object)this);
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (IOException e) {
            this.log.debug((Object)("IO failure closing SocketChannel '" + this), (Throwable)e);
        }
        super.doClose(closeReason);
    }

    private void configureLocalEndpoint() throws IOException {
        if (this.config == null || this.channel == null) {
            return;
        }
        DatagramSocket socket = this.channel.socket();
        if (socket == null) {
            return;
        }
        String host = this.config.getOption("transport-address");
        Integer port = this.config.getInteger("transport-port");
        if (host == null && port == null) {
            return;
        }
        int bindPort = 0;
        if (port != null) {
            bindPort = port;
        }
        InetSocketAddress address = host == null ? new InetSocketAddress(bindPort) : new InetSocketAddress(host, bindPort);
        this.log.debugFormat("Binding local endpoint to {0}", (Object)address);
        socket.bind(address);
    }

    public InetSocketAddress getRemoteEndPoint() {
        SocketAddress sa = null;
        if (this.channel != null && this.channel.socket() != null) {
            sa = this.channel.socket().getRemoteSocketAddress();
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    public InetSocketAddress getLocalEndPoint() {
        SocketAddress sa = null;
        if (this.channel != null && this.channel.socket() != null) {
            sa = this.channel.socket().getLocalSocketAddress();
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    private class UdpWritePipeImpl
    implements WritePipe {
        private UdpWritePipeImpl() {
        }

        public void write(WritePoint writePoint) {
            if (UdpConnectionImpl.this.channel == null) {
                throw new IllegalArgumentException("Channel is not opened");
            }
            if (writePoint instanceof BufferWritePoint) {
                ByteBuffer data = ((BufferWritePoint)writePoint).getBuffers();
                int len = data.remaining();
                if (len > 0) {
                    int sent = 0;
                    try {
                        sent = UdpConnectionImpl.this.channel.write(data);
                    }
                    catch (IOException e) {
                        UdpConnectionImpl.this.log.error((Object)"Exception while sending datagram packet", (Throwable)e);
                    }
                    if (sent != len) {
                        UdpConnectionImpl.this.log.warn((Object)("Error sending udp datagram: sent " + sent + " bytes of " + len));
                    }
                }
            } else {
                throw new IllegalArgumentException("BufferedWritePoint supported only");
            }
        }

        public WritePoint createWritePoint() {
            return new BufferWritePoint();
        }

        public void close(Throwable closeReason) {
            UdpConnectionImpl.this.log.debug((Object)"Issuing close command", closeReason);
            try {
                UdpConnectionImpl.this.channel.close();
            }
            catch (IOException e) {
                UdpConnectionImpl.this.log.warn((Object)"Exception while closing datagram channel", (Throwable)e);
            }
            UdpConnectionImpl.this.doClose(closeReason);
        }
    }
}

