/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class AliasKeyManager
extends X509ExtendedKeyManager {
    private static final ILogger log = Log.getLogger(AliasKeyManager.class);
    private KeyStore keyStore;
    private String alias;
    private char[] password;

    public AliasKeyManager(KeyStore keyStore, String alias, char[] password) {
        this.keyStore = keyStore;
        this.alias = alias;
        this.password = password;
        log.debugFormat("KeyManager initialized. Certificate alias used: \"{0}\"", (Object)alias);
    }

    public AliasKeyManager(KeyStore keyStore, String alias) {
        this(keyStore, alias, null);
    }

    public String[] getClientAliases(String s, Principal[] principals) {
        return new String[]{this.alias};
    }

    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.alias;
    }

    public String[] getServerAliases(String s, Principal[] principals) {
        return new String[]{this.alias};
    }

    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.alias;
    }

    public X509Certificate[] getCertificateChain(String s) {
        X509Certificate[] chain = null;
        try {
            chain = (X509Certificate[])this.keyStore.getCertificateChain(this.alias);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Could not get certificate chain from key store", (Throwable)e);
        }
        return chain;
    }

    public PrivateKey getPrivateKey(String s) {
        PrivateKey key = null;
        try {
            key = (PrivateKey)this.keyStore.getKey(this.alias, this.password);
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"Could not get private key from key store", (Throwable)e);
        }
        return key;
    }

    public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
        return this.alias;
    }

    public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
        return this.alias;
    }
}

